/*
 * Decompiled with CFR 0.152.
 */
package com.marty.walkup;

import com.google.inject.Provides;
import com.marty.walkup.AudioPlayer;
import com.marty.walkup.MartyWalkupConfig;
import java.io.File;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Marty's Walk Up Plugin")
public class MartyWalkupPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(MartyWalkupPlugin.class);
    @Inject
    private Client client;
    @Inject
    private MartyWalkupConfig config;
    private String displayName = null;
    private boolean playOnFirstTick = false;

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.displayName == null && this.client.getGameState() == GameState.LOGGED_IN && this.playOnFirstTick) {
            String[] pairs;
            if (this.client.getLocalPlayer() == null || this.client.getLocalPlayer().getName() == null) {
                log.info("No displayname yet...");
                return;
            }
            this.displayName = this.client.getLocalPlayer().getName();
            char[] displayNameArr = this.displayName.toCharArray();
            for (int i = 0; i < displayNameArr.length; ++i) {
                if (displayNameArr[i] != '\u00a0') continue;
                displayNameArr[i] = 32;
            }
            this.displayName = new String(displayNameArr);
            log.info("User " + this.displayName + " logged in.");
            for (String p : pairs = this.config.friendsAndSounds().split("\n")) {
                String[] pair = p.split("=");
                if (pair.length != 2) continue;
                String user = pair[0];
                String sound = pair[1];
                if (!user.equals(this.displayName)) continue;
                try {
                    File audioFile = new File(AudioPlayer.getSoundsDir() + "/" + sound);
                    AudioPlayer.play(audioFile.toString(), this.config);
                }
                catch (Exception e) {
                    this.client.addChatMessage(ChatMessageType.CONSOLE, "", e.toString(), "[Marty's Entrance Error]");
                }
                return;
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            boolean bl = this.playOnFirstTick = this.config.playOwnSound() && !this.config.mute();
        }
        if (this.displayName != null && this.client.getGameState() == GameState.LOGIN_SCREEN || this.client.getGameState() == GameState.HOPPING) {
            this.displayName = null;
            this.playOnFirstTick = this.config.playOwnSound() && !this.config.mute();
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage message) {
        String msgContent;
        if (message.getType() == ChatMessageType.LOGINLOGOUTNOTIFICATION && (msgContent = message.getMessage()).contains("has logged in.")) {
            String username = msgContent.split(" has")[0];
            log.info("Got sign in message for user: " + username + ".");
            String[] pairs = this.config.friendsAndSounds().split("\n");
            char[] usernameArr = username.toCharArray();
            for (int i = 0; i < usernameArr.length; ++i) {
                if (usernameArr[i] != '\u00a0') continue;
                usernameArr[i] = 32;
            }
            username = new String(usernameArr);
            for (String p : pairs) {
                String[] pair = p.split("=");
                String user = pair[0];
                String sound = pair[1];
                log.info("User: " + user + ", Username: " + username + ".");
                if (user.equals(username)) {
                    log.info("User matched");
                    File audioFile = new File(AudioPlayer.getSoundsDir() + "/" + sound);
                    try {
                        AudioPlayer.play(audioFile.toString(), this.config);
                    }
                    catch (Exception e) {
                        this.client.addChatMessage(ChatMessageType.CONSOLE, "", e.toString(), "[Marty's Entrance Error]");
                    }
                    return;
                }
                if (user.length() != username.length()) {
                    log.info("User: " + user + " length: " + user.length());
                    log.info(" Username " + username + " length: " + username.length());
                }
                int len = username.length();
                if (user.length() <= username.length()) {
                    len = user.length();
                }
                for (int j = 0; j < len; ++j) {
                    if (user.charAt(j) == username.charAt(j)) continue;
                    log.info("Mismatch! User: " + user.charAt(j) + " Username: " + username.charAt(j));
                }
            }
        }
    }

    @Provides
    MartyWalkupConfig provideConfig(ConfigManager configManager) {
        return (MartyWalkupConfig)configManager.getConfig(MartyWalkupConfig.class);
    }
}

