/*
 * Decompiled with CFR 0.152.
 */
package com.marty.walkup;

import com.marty.walkup.MartyWalkupConfig;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.runelite.client.RuneLite;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioPlayer {
    private static final Logger log = LoggerFactory.getLogger(AudioPlayer.class);
    private static Clip clip = null;
    private static File fileLocation = null;

    public static File getSoundsDir() {
        if (fileLocation == null || !fileLocation.exists()) {
            File runeliteDir = new File(RuneLite.RUNELITE_DIR.toString());
            if (!runeliteDir.exists()) {
                log.info("$HOME/.runelite doesn't exist");
                return null;
            }
            if (!runeliteDir.isDirectory()) {
                log.info("$HOME/.runelite isn't a directory");
                return null;
            }
            File soundsDir = new File(runeliteDir.getPath() + "/sounds/marty/entrance");
            log.info(soundsDir.getAbsolutePath());
            if (!soundsDir.exists()) {
                HttpUrl git;
                log.info("$HOME/.runelite/sounds doesn't exist");
                if (!soundsDir.mkdirs()) {
                    log.info("Failed to make soundsDir");
                }
                if ((git = HttpUrl.parse((String)"https://raw.githubusercontent.com/Martyrshot/runelite-marty-entrance/master/sounds/com/marty/entrance/")) == null) {
                    return null;
                }
                HttpUrl martyUrl = git.newBuilder().addPathSegment("marty.wav").build();
                try {
                    OkHttpClient httpClient = new OkHttpClient();
                    try (Response res = httpClient.newCall(new Request.Builder().url(martyUrl).build()).execute();){
                        if (res.body() != null) {
                            Files.copy(new BufferedInputStream(res.body().byteStream()), Paths.get(soundsDir + "/marty.wav", new String[0]), new CopyOption[0]);
                        }
                    }
                }
                catch (Exception e) {
                    log.info("Couldn't download very important file");
                }
            }
            fileLocation = soundsDir;
        }
        return fileLocation;
    }

    public static void play(String fileName, MartyWalkupConfig config) throws UnsupportedAudioFileException, IOException, IllegalArgumentException, SecurityException, LineUnavailableException {
        block8: {
            if (config.mute()) {
                log.info("Is muted");
                return;
            }
            File audioFile = new File(fileName);
            log.info(audioFile.getPath());
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(audioFile);
            Clip clip = AudioSystem.getClip();
            clip.open(audioInputStream);
            AudioPlayer.setVolume(clip, config.volume());
            if (AudioPlayer.clip == null || !AudioPlayer.clip.isRunning()) {
                AudioPlayer.clip = clip;
                AudioPlayer.clip.start();
            } else {
                long timeRemainingMS = AudioPlayer.clip.getMicrosecondLength() - AudioPlayer.clip.getMicrosecondPosition();
                try {
                    if (config.interrupt()) {
                        if (AudioPlayer.clip != null && AudioPlayer.clip.isRunning()) {
                            AudioPlayer.clip.stop();
                        }
                        AudioPlayer.clip = clip;
                        AudioPlayer.clip.start();
                        break block8;
                    }
                    while (AudioPlayer.clip.isRunning()) {
                        TimeUnit.MICROSECONDS.sleep(timeRemainingMS);
                        if (AudioPlayer.clip.isRunning()) continue;
                        AudioPlayer.clip = clip;
                        AudioPlayer.clip.start();
                        break;
                    }
                }
                catch (Exception e) {
                    log.info("Failed to sleep: " + e);
                }
            }
        }
    }

    private static void setVolume(Clip c, float volume) {
        FloatControl gainControl = (FloatControl)c.getControl(FloatControl.Type.MASTER_GAIN);
        float range = gainControl.getMaximum() - gainControl.getMinimum();
        System.out.println("Max: " + gainControl.getMaximum() + " Min: " + gainControl.getMinimum());
        System.out.println("Range: " + range);
        if (volume < 0.0f || volume > 100.0f) {
            throw new IllegalArgumentException("Volume Not Valid: " + volume);
        }
        float gain = range * (volume /= 100.0f) + gainControl.getMinimum();
        System.out.println("Range * volume: " + range * volume);
        System.out.println("Gain: " + gain);
        gainControl.setValue(gain);
    }
}

