/*
 * Decompiled with CFR 0.152.
 */
package com.skulltimer;

import com.google.inject.Provides;
import com.skulltimer.SkullTimerConfig;
import com.skulltimer.SkulledTimer;
import java.awt.image.BufferedImage;
import java.time.Duration;
import java.time.Instant;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Emblem Trader Skull Timer", description="Displays a timer when your character receives a skull from the emblem trader.")
public class SkullTimerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SkullTimerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private SkullTimerConfig config;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ItemManager itemManager;
    private SkulledTimer timer;
    private final Duration durationTrader = Duration.ofMinutes(20L);

    protected void shutDown() throws Exception {
        this.removeTimer(this.timer != null);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) throws InterruptedException {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN && this.config.skullDuration() != null && this.timer == null) {
            this.addTimer(this.config.skullDuration());
        } else if ((gameStateChanged.getGameState() == GameState.LOGIN_SCREEN || gameStateChanged.getGameState() == GameState.HOPPING) && this.timer != null) {
            this.removeTimer(true);
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage messageEvent) {
        if (messageEvent.getType() == ChatMessageType.MESBOX && (messageEvent.getMessage().equalsIgnoreCase("Your PK skull will now last for the full 20 minutes.") || messageEvent.getMessage().equalsIgnoreCase("You are now skulled."))) {
            this.addTimer(this.durationTrader);
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTickEvent) {
        if (this.timer != null && (Instant.now().isAfter(this.timer.getEndTime()) || this.client.getLocalPlayer().getSkullIcon() == null)) {
            this.removeTimer(false);
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (this.timer != null) {
            this.addTimer(this.timer.getRemainingTime());
        }
    }

    public void addTimer(Duration timerDuration) throws IllegalArgumentException {
        this.removeTimer(this.timer != null);
        this.timer = new SkulledTimer(timerDuration, (BufferedImage)this.itemManager.getImage(964), this, this.config.textColour(), this.config.warningTextColour());
        this.timer.setTooltip("Time left until your character becomes unskulled.");
        this.infoBoxManager.addInfoBox((InfoBox)this.timer);
    }

    public void removeTimer(boolean saveConfig) throws IllegalArgumentException {
        if (saveConfig) {
            this.config.skullDuration(this.timer.getRemainingTime());
        } else {
            this.config.skullDuration(null);
        }
        this.infoBoxManager.removeIf(t -> t instanceof SkulledTimer);
        this.timer = null;
    }

    @Provides
    SkullTimerConfig provideConfig(ConfigManager configManager) {
        return (SkullTimerConfig)configManager.getConfig(SkullTimerConfig.class);
    }
}

