/*
 * Decompiled with CFR 0.152.
 */
package com.zebakroarchat;

import com.google.inject.Provides;
import com.zebakroarchat.ZebakRoarChatConfig;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.swing.Timer;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Zebak Roar Chat")
public class ZebakRoarChatPlugin
extends Plugin
implements ActionListener {
    private static final Logger log = LoggerFactory.getLogger(ZebakRoarChatPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ZebakRoarChatConfig config;
    private boolean isRoaring = false;
    private NPC zebak = null;

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        if (npcDespawned.getNpc().getId() == 10680) {
            if (this.isRoaring) {
                this.endRoar();
            }
            if (this.zebak != null) {
                this.zebak = null;
            }
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        if (this.isRoaring) {
            return;
        }
        if (!(event.getActor() instanceof NPC)) {
            return;
        }
        NPC npc = (NPC)event.getActor();
        if (npc.getId() != 10680 || npc.getAnimation() != 9628) {
            return;
        }
        this.zebak = npc;
        this.startRoar();
    }

    protected void startRoar() {
        this.isRoaring = true;
        this.zebak.setOverheadText(this.config.zebakMessage());
        Timer timer = new Timer(5500, this);
        timer.setRepeats(false);
        timer.start();
    }

    protected void endRoar() {
        this.isRoaring = false;
        this.zebak.setOverheadText("");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.endRoar();
    }

    @Provides
    ZebakRoarChatConfig provideConfig(ConfigManager configManager) {
        return (ZebakRoarChatConfig)configManager.getConfig(ZebakRoarChatConfig.class);
    }
}

