/*
 * Decompiled with CFR 0.152.
 */
package com.xpdropextended;

import com.google.inject.Provides;
import com.xpdropextended.XpDropExtendedConfig;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.widgets.Widget;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;

@PluginDescriptor(name="XP Drop Extended", description="Extended functionality to the existing XP Drop plugin.", tags={"experience", "levels", "tick", "skilling", "skill", "xpdrop"})
public class XpDropExtendedPlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private XpDropExtendedConfig config;
    private Widget currentWidget;

    @Provides
    XpDropExtendedConfig provideConfig(ConfigManager configManager) {
        return (XpDropExtendedConfig)configManager.getConfig(XpDropExtendedConfig.class);
    }

    @Subscribe
    public void onScriptPreFired(ScriptPreFired scriptPreFired) {
        if (scriptPreFired.getScriptId() == 996) {
            int[] intStack = this.client.getIntStack();
            int intStackSize = this.client.getIntStackSize();
            this.currentWidget = this.client.getWidget(intStack[intStackSize - 4]);
            int n = intStack[intStackSize - 4];
        }
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired scriptPostFired) {
        if (scriptPostFired.getScriptId() == 996 && this.config.hideMaxXPIcon()) {
            this.hideMaxXPIcon(this.currentWidget);
        }
    }

    private void hideMaxXPIcon(Widget xpDrop) {
        Widget text = xpDrop.getChild(0);
        if (text.getText().startsWith("<img=11>")) {
            text.setText(text.getText().substring(9));
            text.revalidate();
            Widget[] children = xpDrop.getChildren();
            for (int i = 1; i < children.length; ++i) {
                Widget child = children[i];
                if (child == null) continue;
                child.setOriginalX(child.getOriginalX() + 14);
                child.revalidate();
            }
        }
    }
}

