/*
 * Decompiled with CFR 0.152.
 */
package com.zom.nmz_util;

import com.google.common.collect.ArrayListMultimap;
import com.google.inject.Provides;
import com.zom.nmz_util.NMZUtilConfig;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuEntry;
import net.runelite.api.Skill;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameTick;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="NMZ Utilities")
public class NMZUtilPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(NMZUtilPlugin.class);
    private static final int[] NMZ_MAP_REGION = new int[]{9033};
    @Inject
    private Client client;
    @Inject
    private Notifier notifier;
    @Inject
    private NMZUtilConfig config;
    private boolean hitPointsReduced = false;
    private boolean hitpointsNotificationSend = true;
    private final ArrayListMultimap<String, Integer> optionIndexes = ArrayListMultimap.create();

    @Subscribe
    private void onGameTick(GameTick event) {
        if (this.client.getGameState() != GameState.LOGGED_IN || this.client.isMenuOpen()) {
            return;
        }
        if (!this.isInNightmareZone() && !this.hitpointsNotificationSend) {
            this.hitpointsNotificationSend = true;
        }
        if (this.config.hitPointsNotification()) {
            this.checkHealth();
        }
    }

    @Subscribe
    public void onClientTick(ClientTick event) {
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        int idx = 0;
        this.optionIndexes.clear();
        for (MenuEntry entry : menuEntries) {
            String option = Text.removeTags((String)entry.getOption()).toLowerCase();
            this.optionIndexes.put((Object)option, (Object)idx++);
        }
        idx = 0;
        for (MenuEntry entry : menuEntries) {
            this.swapMenuEntry(idx++, entry);
        }
    }

    private void checkHealth() {
        int realHealth = this.client.getRealSkillLevel(Skill.HITPOINTS);
        int currentHealth = this.client.getBoostedSkillLevel(Skill.HITPOINTS);
        if (this.config.hitPointThreshold() >= realHealth || this.config.hitPointThreshold() == 0) {
            return;
        }
        if (!this.hitpointsNotificationSend && this.hitPointsReduced) {
            if (currentHealth > this.config.hitPointThreshold()) {
                this.notifier.notify("Hitpoints are above: " + this.config.hitPointThreshold());
                this.hitpointsNotificationSend = true;
            }
        } else if (currentHealth <= this.config.hitPointThreshold()) {
            this.hitPointsReduced = true;
            this.hitpointsNotificationSend = false;
        }
    }

    private void swapMenuEntry(int index, MenuEntry menuEntry) {
        String option = Text.removeTags((String)menuEntry.getOption()).toLowerCase();
        String target = Text.removeTags((String)menuEntry.getTarget()).toLowerCase();
        if (this.config.swapBarrels() && (target.equals("absorption potion") || target.equals("overload potion") || target.equals("super magic potion") || target.equals("super ranging potion")) && option.equals("check")) {
            this.swap("take", option, target, index);
        }
    }

    private void swap(String optionA, String optionB, String target, int index) {
        this.swap(optionA, optionB, target, index, true);
    }

    private void swap(String optionA, String optionB, String target, int index, boolean strict) {
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        int thisIndex = this.findIndex(menuEntries, index, optionB, target, strict);
        int optionIdx = this.findIndex(menuEntries, thisIndex, optionA, target, strict);
        if (thisIndex >= 0 && optionIdx >= 0) {
            this.swap(this.optionIndexes, menuEntries, optionIdx, thisIndex);
        }
    }

    private int findIndex(MenuEntry[] entries, int limit, String option, String target, boolean strict) {
        if (strict) {
            List indexes = this.optionIndexes.get((Object)option);
            for (int i = indexes.size() - 1; i >= 0; --i) {
                int idx = (Integer)indexes.get(i);
                MenuEntry entry = entries[idx];
                String entryTarget = Text.removeTags((String)entry.getTarget()).toLowerCase();
                if (idx > limit || !entryTarget.equals(target)) continue;
                return idx;
            }
        } else {
            for (int i = limit; i >= 0; --i) {
                MenuEntry entry = entries[i];
                String entryOption = Text.removeTags((String)entry.getOption()).toLowerCase();
                String entryTarget = Text.removeTags((String)entry.getTarget()).toLowerCase();
                if (!entryOption.contains(option.toLowerCase()) || !entryTarget.equals(target)) continue;
                return i;
            }
        }
        return -1;
    }

    private void swap(ArrayListMultimap<String, Integer> optionIndexes, MenuEntry[] entries, int index1, int index2) {
        MenuEntry entry = entries[index1];
        entries[index1] = entries[index2];
        entries[index2] = entry;
        this.client.setMenuEntries(entries);
        optionIndexes.clear();
        int idx = 0;
        for (MenuEntry menuEntry : entries) {
            String option = Text.removeTags((String)menuEntry.getOption()).toLowerCase();
            optionIndexes.put((Object)option, (Object)idx++);
        }
    }

    public boolean isInNightmareZone() {
        return Arrays.equals(this.client.getMapRegions(), NMZ_MAP_REGION);
    }

    protected void startUp() throws Exception {
        this.hitpointsNotificationSend = true;
    }

    protected void shutDown() throws Exception {
        this.hitpointsNotificationSend = true;
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("nmzutil")) {
            this.hitPointsReduced = false;
        }
    }

    @Provides
    NMZUtilConfig provideConfig(ConfigManager configManager) {
        return (NMZUtilConfig)configManager.getConfig(NMZUtilConfig.class);
    }
}

