/*
 * Decompiled with CFR 0.152.
 */
package com.github.calebwhiting.runelite.plugins.actionprogress.detect;

import com.github.calebwhiting.runelite.api.InterruptManager;
import com.github.calebwhiting.runelite.api.InventoryManager;
import com.github.calebwhiting.runelite.plugins.actionprogress.Action;
import com.github.calebwhiting.runelite.plugins.actionprogress.detect.ActionDetector;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.Player;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.Subscribe;

@Singleton
public class WintertodtDetector
extends ActionDetector {
    public static final int[] WOODCUTTING_ANIMATIONS = new int[]{24, 867, 869, 871, 873, 875, 877, 879, 2117, 2846, 7264, 8303, 8324, 8778};
    private static final int WINTERTODT_PRISON_REGION_ID = 6462;
    private static final String[] INTERRUPT_MESSAGES = new String[]{"The cold of the Wintertodt seeps into your bones.", "The freezing cold attack", "The brazier is broken and shrapnel damages you.", "The brazier has gone out."};
    private static final int[] BRUMA_KINDLING_MATERIALS = new int[]{946, 20695};
    @Inject
    private Client client;
    @Inject
    private InventoryManager inventoryManager;
    @Inject
    private InterruptManager interruptManager;

    private boolean isInWintertodtPrison() {
        Player me = this.client.getLocalPlayer();
        if (me == null) {
            return false;
        }
        WorldPoint worldPoint = me.getWorldLocation();
        int region = worldPoint.getRegionID();
        return region == 6462;
    }

    @Subscribe
    public void onChatMessage(ChatMessage evt) {
        ChatMessageType chatMessageType = evt.getType();
        if (chatMessageType != ChatMessageType.GAMEMESSAGE && chatMessageType != ChatMessageType.SPAM) {
            return;
        }
        Action action = this.actionManager.getCurrentAction();
        if (action != Action.WINTERTODT_FIREMAKING && action != Action.WINTERTODT_FLETCHING) {
            return;
        }
        String message = evt.getMessage();
        Stream.of(INTERRUPT_MESSAGES).filter(message::startsWith).findFirst().ifPresent(x -> this.interruptManager.interrupt(evt));
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked evt) {
        if (evt.getMenuAction() != MenuAction.WIDGET_TARGET_ON_WIDGET) {
            return;
        }
        ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
        Widget widget = this.client.getSelectedWidget();
        if (inventory == null || widget == null) {
            return;
        }
        int[] items = new int[]{Objects.requireNonNull(inventory.getItem(widget.getId())).getId(), Objects.requireNonNull(inventory.getItem(evt.getParam0())).getId()};
        Arrays.sort(items);
        if (Arrays.equals(items, BRUMA_KINDLING_MATERIALS)) {
            this.actionManager.setAction(Action.WINTERTODT_FLETCHING, this.inventoryManager.getItemCountById(20695), 20696);
        }
    }

    @Subscribe
    public void onGameTick(GameTick evt) {
        Player local = this.client.getLocalPlayer();
        if (local == null || !this.isInWintertodtPrison()) {
            return;
        }
        Action action = this.actionManager.getCurrentAction();
        if (Arrays.binarySearch(WOODCUTTING_ANIMATIONS, local.getAnimation()) >= 0) {
            int rem = this.inventoryManager.getFreeSpaces();
            if (action != Action.WINTERTODT_WOODCUTTING) {
                this.actionManager.setAction(Action.WINTERTODT_WOODCUTTING, rem, 20695);
            }
        } else if (local.getAnimation() == 832 && action != Action.WINTERTODT_FIREMAKING) {
            int rem = this.inventoryManager.getItemCountById(20695, 20696);
            this.actionManager.setAction(Action.WINTERTODT_FIREMAKING, rem, 20695);
        }
    }

    static {
        Arrays.sort(BRUMA_KINDLING_MATERIALS);
    }
}

