/*
 * Decompiled with CFR 0.152.
 */
package com.github.calebwhiting.runelite.plugins.actionprogress.detect;

import com.github.calebwhiting.runelite.api.InventoryManager;
import com.github.calebwhiting.runelite.api.event.LocalAnimationChanged;
import com.github.calebwhiting.runelite.plugins.actionprogress.Action;
import com.github.calebwhiting.runelite.plugins.actionprogress.detect.ActionDetector;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TemporossDetector
extends ActionDetector {
    private static final Logger log = LoggerFactory.getLogger(TemporossDetector.class);
    private static final int TEMPOROSS_REGION = 12078;
    private static final int[] TEMPOROSS_AMMUNITION_CRATE = new int[]{10576, 10577, 10578, 10579};
    private static final int[] TEMPOROSS_AMMUNITION = new int[]{25564, 25565, 25566};
    @Inject
    private Client client;
    @Inject
    private InventoryManager inventoryManager;

    @Subscribe
    public void onLocalAnimationChanged(LocalAnimationChanged evt) {
        int id;
        Action action = this.actionManager.getCurrentAction();
        Player me = evt.getLocalPlayer();
        int region = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)me.getLocalLocation()).getRegionID();
        if (region != 12078) {
            log.debug("not in tempoross region");
            return;
        }
        if (action == Action.TEMPOROSS_FILL_CRATE || action == Action.TEMPOROSS_COOKING) {
            log.debug("action is already {}", (Object)action);
            return;
        }
        if (me.getAnimation() != 896) {
            log.debug("incorrect animation");
            return;
        }
        Actor interacting = me.getInteracting();
        int n = id = interacting instanceof NPC ? ((NPC)interacting).getId() : -1;
        if (id != -1 && Arrays.binarySearch(TEMPOROSS_AMMUNITION_CRATE, id) >= 0) {
            log.debug("filling crate");
            int amount = this.inventoryManager.getItemCountById(TEMPOROSS_AMMUNITION);
            this.actionManager.setAction(Action.TEMPOROSS_FILL_CRATE, amount, -1);
        } else {
            log.debug("cooking fish");
            int amount = this.inventoryManager.getItemCountById(25564);
            this.actionManager.setAction(Action.TEMPOROSS_COOKING, amount, 25565);
        }
    }

    static {
        Arrays.sort(TEMPOROSS_AMMUNITION_CRATE);
        Arrays.sort(TEMPOROSS_AMMUNITION);
    }
}

