/*
 * Decompiled with CFR 0.152.
 */
package com.github.calebwhiting.runelite.plugins.actionprogress.detect;

import com.github.calebwhiting.runelite.plugins.actionprogress.Action;
import com.github.calebwhiting.runelite.plugins.actionprogress.detect.ActionDetector;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.runelite.api.Client;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.events.VarClientIntChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;

@Singleton
public class SmithingDetector
extends ActionDetector
implements KeyListener {
    @Inject
    private Client client;
    @Inject
    private KeyManager keyManager;
    private static final Pattern X_BARS_PATTERN = Pattern.compile("^(?<x>\\d*) (bars?)$");
    private static final int VAR_AVAILABLE_MATERIALS = 2224;
    private static final int VAR_SMITHING_INTERFACE = 989;
    private static final int VAR_SELECTED_SMITHING_INDEX = 13895;
    private static final int SCRIPT_SMITHING_INIT = 431;
    private static final int ENUM_SMITHING_WIDGET_INDEX = 1101;
    private static final int ENUM_SMITHING_ITEM_BAR = 845;
    private int smithingItemid;
    private int numberOfBarsForSelectedItem;
    private boolean waitingForSmithingSelection = false;
    private HashMap<Integer, Integer> indexToItemId = new HashMap();

    public void keyTyped(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyPressed(KeyEvent event) {
        if (this.waitingForSmithingSelection && event.getKeyCode() == 32) {
            int availableBars = this.client.getVarpValue(2224);
            this.actionManager.setAction(Action.SMITHING, availableBars / this.numberOfBarsForSelectedItem, this.smithingItemid);
        }
    }

    @Override
    public void setup() {
        this.keyManager.registerKeyListener((KeyListener)this);
    }

    @Override
    public void shutDown() {
        this.keyManager.unregisterKeyListener((KeyListener)this);
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged evt) {
        int index;
        if (evt.getVarbitId() == 13895 && this.indexToItemId.containsKey(index = evt.getValue())) {
            this.smithingItemid = this.indexToItemId.get(index);
            this.numberOfBarsForSelectedItem = this.client.getEnum(845).getIntValue(this.smithingItemid);
        }
    }

    @Subscribe
    public void onVarClientIntChanged(VarClientIntChanged varClientIntChanged) {
        if (varClientIntChanged.getIndex() == 989) {
            this.waitingForSmithingSelection = !this.waitingForSmithingSelection;
        }
    }

    @Subscribe
    public void onScriptPreFired(ScriptPreFired evt) {
        if (evt.getScriptId() == 431) {
            int[] intStack = this.client.getIntStack();
            int intStackSize = this.client.getIntStackSize();
            int widgetId = intStack[intStackSize - 4];
            int itemId = intStack[intStackSize - 3];
            int index = this.client.getEnum(1101).getIntValue(widgetId);
            this.indexToItemId.put(index, itemId);
            int var_index = this.client.getVarbitValue(13895);
            this.smithingItemid = this.indexToItemId.get(var_index);
            this.numberOfBarsForSelectedItem = this.client.getEnum(845).getIntValue(this.smithingItemid);
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked evt) {
        int param1 = evt.getParam1();
        if (param1 == -1) {
            return;
        }
        Widget widget = this.client.getWidget(param1);
        if (widget == null) {
            return;
        }
        if (widget.getParentId() == 20447232) {
            Widget widget1 = widget.getChild(1);
            Widget widget2 = widget.getChild(2);
            String text = widget1.getText();
            String text2 = widget2.getText();
            Matcher matcher = X_BARS_PATTERN.matcher(text);
            Matcher matcher2 = X_BARS_PATTERN.matcher(text2);
            if (matcher.matches() || matcher2.matches()) {
                String x = matcher.matches() ? matcher.group("x") : matcher2.group("x");
                int barsPerItem = Integer.parseInt(x);
                int availableBars = this.client.getVarpValue(2224);
                int productId = matcher.matches() ? widget2.getItemId() : widget1.getItemId();
                this.actionManager.setAction(Action.SMITHING, availableBars / barsPerItem, productId);
            }
        }
    }
}

