/*
 * Decompiled with CFR 0.152.
 */
package com.github.calebwhiting.runelite.plugins.actionprogress.detect;

import com.github.calebwhiting.runelite.api.InventoryManager;
import com.github.calebwhiting.runelite.data.Herblore;
import com.github.calebwhiting.runelite.plugins.actionprogress.Action;
import com.github.calebwhiting.runelite.plugins.actionprogress.ActionManager;
import com.github.calebwhiting.runelite.plugins.actionprogress.detect.ActionDetector;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.client.eventbus.Subscribe;

@Singleton
public class ItemClickDetector
extends ActionDetector {
    @Inject
    private Client client;
    @Inject
    private InventoryManager inventoryManager;
    @Inject
    private ActionManager actionManager;

    @Override
    public void setup() {
        super.setup();
        this.registerAction(Action.HERB_CLEAN, Herblore.GRIMY_HERBS);
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked evt) {
        if (evt.getMenuAction() != MenuAction.CC_OP) {
            return;
        }
        if (evt.getParam1() != 149) {
            return;
        }
        ItemContainer inventory = this.client.getItemContainer(InventoryID.INVENTORY);
        if (inventory == null) {
            return;
        }
        Item item = inventory.getItem(evt.getParam0());
        if (item == null) {
            return;
        }
        Action action = (Action)((Object)this.itemActions.get(item.getId()));
        if (action == null) {
            return;
        }
        int amount = this.inventoryManager.getItemCountById(item.getId());
        this.actionManager.setAction(action, amount, item.getId());
    }
}

