/*
 * Decompiled with CFR 0.152.
 */
package com.github.calebwhiting.runelite.plugins.actionprogress.detect;

import com.github.calebwhiting.runelite.data.Crafting;
import com.github.calebwhiting.runelite.plugins.actionprogress.Action;
import com.github.calebwhiting.runelite.plugins.actionprogress.detect.ActionDetector;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.Subscribe;

public class FurnaceCastingDetector
extends ActionDetector {
    private static final int[] FURNACE_SILVER_PARENTS = new int[]{393222, 393226, 393230, 393234, 393238};
    private static final int[] FURNACE_GOLD_PARENTS;
    private static final int VAR_FURNACE_MAKE_AMOUNT = 2224;
    @Inject
    private Client client;

    @Override
    public void setup() {
        this.registerAction(Action.CRAFT_CAST_GOLD_AND_SILVER, Crafting.SILVER_AND_GOLD_ITEMS);
    }

    @Subscribe
    @Singleton
    public void onMenuOptionClicked(MenuOptionClicked evt) {
        if (evt.getParam1() <= 0 || evt.getMenuAction() != MenuAction.CC_OP) {
            return;
        }
        Widget widget = this.client.getWidget(evt.getParam1());
        if (widget == null) {
            return;
        }
        int actionCount = this.client.getVarpValue(2224);
        if (Arrays.binarySearch(FURNACE_SILVER_PARENTS, widget.getParentId()) >= 0) {
            Widget itemContainer = widget.getChild(0);
            if (itemContainer != null) {
                int product = itemContainer.getItemId();
                this.setActionByItemId(product, actionCount);
            }
        } else if (Arrays.binarySearch(FURNACE_GOLD_PARENTS, widget.getParentId()) >= 0) {
            int product = widget.getItemId();
            this.setActionByItemId(product, actionCount);
        }
    }

    static {
        Arrays.sort(FURNACE_SILVER_PARENTS);
        FURNACE_GOLD_PARENTS = new int[]{29229059, 29229073, 29229076, 29229086, 29229103};
        Arrays.sort(FURNACE_GOLD_PARENTS);
    }
}

