/*
 * Decompiled with CFR 0.152.
 */
package com.github.calebwhiting.runelite.plugins.actionprogress.detect;

import com.github.calebwhiting.runelite.api.InventoryManager;
import com.github.calebwhiting.runelite.data.Cooking;
import com.github.calebwhiting.runelite.data.Crafting;
import com.github.calebwhiting.runelite.data.Fletching;
import com.github.calebwhiting.runelite.data.Herblore;
import com.github.calebwhiting.runelite.data.IDs;
import com.github.calebwhiting.runelite.data.Ingredient;
import com.github.calebwhiting.runelite.data.Magic;
import com.github.calebwhiting.runelite.data.Recipe;
import com.github.calebwhiting.runelite.data.Smithing;
import com.github.calebwhiting.runelite.plugins.actionprogress.Action;
import com.github.calebwhiting.runelite.plugins.actionprogress.ActionUtils;
import com.github.calebwhiting.runelite.plugins.actionprogress.Product;
import com.github.calebwhiting.runelite.plugins.actionprogress.detect.ActionDetector;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Objects;
import net.runelite.api.Client;
import net.runelite.api.ScriptEvent;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ChatboxDetector
extends ActionDetector {
    private static final Logger log = LoggerFactory.getLogger(ChatboxDetector.class);
    private static final int VAR_MAKE_AMOUNT = 200;
    private static final int VAR_SELECTED_INDEX = 2673;
    private static final int WIDGET_MAKE_PARENT = 270;
    private static final int WIDGET_MAKE_QUESTION = 5;
    private static final int WIDGET_MAKE_SLOT_START = 14;
    private static final int WIDGET_MAKE_SLOT_COUNT = 9;
    private static final int WIDGET_MAKE_SLOT_ITEM = 38;
    private static final int WIDGET_ID_CHATBOX_FIRST_MAKE_BUTTON = 0x10E000E;
    private static final int MAKE_X_SETUP = 2046;
    private static final int MAKE_X_BUTTON_CLICK = 2050;
    private static final int MAKE_X_BUTTON_KEY = 2051;
    private static final int MAKE_X_BUTTON_TRIGGERED = 2052;
    private static final Product[] MULTI_MATERIAL_PRODUCTS = new Product[]{new Product(Action.CRAFT_LEATHER, 1135, new Ingredient(1745, 3)), new Product(Action.CRAFT_LEATHER, 1099, new Ingredient(1745, 2)), new Product(Action.CRAFT_LEATHER, 2499, new Ingredient(2505, 3)), new Product(Action.CRAFT_LEATHER, 2493, new Ingredient(2505, 2)), new Product(Action.CRAFT_LEATHER, 2501, new Ingredient(2507, 3)), new Product(Action.CRAFT_LEATHER, 2495, new Ingredient(2507, 2)), new Product(Action.CRAFT_LEATHER, 2503, new Ingredient(2509, 3)), new Product(Action.CRAFT_LEATHER, 2497, new Ingredient(2509, 2)), new Product(Action.CRAFT_LEATHER, 6326, new Ingredient(6289, 5)), new Product(Action.CRAFT_LEATHER, 6322, new Ingredient(6289, 15)), new Product(Action.CRAFT_LEATHER, 6328, new Ingredient(6289, 6)), new Product(Action.CRAFT_LEATHER, 6324, new Ingredient(6289, 12)), new Product(Action.CRAFT_LEATHER, 6330, new Ingredient(6289, 8)), new Product(Action.CRAFT_LEATHER, 13385, new Ingredient(13383, 3)), new Product(Action.CRAFT_LEATHER, 13387, new Ingredient(13383, 5)), new Product(Action.CRAFT_LEATHER, 13389, new Ingredient(13383, 4)), new Product(Action.CRAFT_LEATHER, 13389, new Ingredient(13383, 4)), new Product(Action.CRAFT_LEATHER, 1059, new Ingredient(1741)), new Product(Action.CRAFT_LEATHER, 1061, new Ingredient(1741)), new Product(Action.CRAFT_LEATHER, 1167, new Ingredient(1741)), new Product(Action.CRAFT_LEATHER, 1063, new Ingredient(1741)), new Product(Action.CRAFT_LEATHER, 1129, new Ingredient(1741)), new Product(Action.CRAFT_LEATHER, 1095, new Ingredient(1741)), new Product(Action.CRAFT_LEATHER, 1169, new Ingredient(1741)), new Product(Action.CRAFT_HARD_LEATHER, 1131, new Ingredient(1743, 1)), new Product(Action.CRAFT_BATTLESTAVES, 1397, new Ingredient(573), new Ingredient(1391)), new Product(Action.CRAFT_BATTLESTAVES, 1393, new Ingredient(569), new Ingredient(1391)), new Product(Action.CRAFT_BATTLESTAVES, 1399, new Ingredient(575), new Ingredient(1391)), new Product(Action.CRAFT_BATTLESTAVES, 1395, new Ingredient(571), new Ingredient(1391)), new Product(Action.SMELTING, 2349, new Ingredient(438), new Ingredient(436)), new Product(Action.SMELTING, 2351, new Ingredient(440)), new Product(Action.SMELTING, 2355, new Ingredient(442)), new Product(Action.SMELTING, 2353, new Ingredient(440), new Ingredient(453, 2)), new Product(Action.SMELTING, 2357, new Ingredient(444)), new Product(Action.SMELTING, 2359, new Ingredient(447), new Ingredient(453, 4)), new Product(Action.SMELTING, 2361, new Ingredient(449), new Ingredient(453, 6)), new Product(Action.SMELTING, 2363, new Ingredient(451), new Ingredient(453, 8)), new Product(Action.SMELTING_CANNONBALLS, 2, new Ingredient[]{new Ingredient(2353)}, new Ingredient(27012)), new Product(Action.CRAFT_CUT_GEMS, 1609, true, new Ingredient(1625)), new Product(Action.CRAFT_CUT_GEMS, 1611, true, new Ingredient(1627)), new Product(Action.CRAFT_CUT_GEMS, 1613, true, new Ingredient(1629)), new Product(Action.CRAFT_CUT_GEMS, 1607, true, new Ingredient(1623)), new Product(Action.CRAFT_CUT_GEMS, 1605, true, new Ingredient(1621)), new Product(Action.CRAFT_CUT_GEMS, 1603, true, new Ingredient(1619)), new Product(Action.CRAFT_CUT_GEMS, 1601, true, new Ingredient(1617)), new Product(Action.CRAFT_CUT_GEMS, 1615, true, new Ingredient(1631)), new Product(Action.CRAFT_CUT_GEMS, 6573, true, new Ingredient(6571)), new Product(Action.CRAFT_CUT_GEMS, 19493, true, new Ingredient(19496)), new Product(Action.CRAFT_STRING_JEWELLERY, 10132, new Ingredient(10134), new Ingredient(1759)), new Product(Action.CRAFT_STRING_JEWELLERY, 1718, new Ingredient(1714), new Ingredient(1759)), new Product(Action.CRAFT_STRING_JEWELLERY, 1724, new Ingredient(1720), new Ingredient(1759)), new Product(Action.CRAFT_STRING_JEWELLERY, 21108, new Ingredient(21099), new Ingredient(1759)), new Product(Action.CRAFT_STRING_JEWELLERY, 21111, new Ingredient(21102), new Ingredient(1759)), new Product(Action.CRAFT_STRING_JEWELLERY, 1694, new Ingredient(1675), new Ingredient(1759)), new Product(Action.CRAFT_STRING_JEWELLERY, 21114, new Ingredient(21105), new Ingredient(1759)), new Product(Action.CRAFT_STRING_JEWELLERY, 1696, new Ingredient(1677), new Ingredient(1759)), new Product(Action.CRAFT_STRING_JEWELLERY, 1698, new Ingredient(1679), new Ingredient(1759)), new Product(Action.CRAFT_STRING_JEWELLERY, 1700, new Ingredient(1681), new Ingredient(1759)), new Product(Action.CRAFT_STRING_JEWELLERY, 1702, new Ingredient(1683), new Ingredient(1759)), new Product(Action.CRAFT_STRING_JEWELLERY, 6581, new Ingredient(6579), new Ingredient(1759)), new Product(Action.CRAFT_STRING_JEWELLERY, 19541, new Ingredient(19501), new Ingredient(1759)), new Product(Action.CRAFT_MOLTEN_GLASS, 1775, new Ingredient(1783), new Ingredient(1781)), new Product(Action.CRAFT_BLOW_GLASS, 1919, new Ingredient(1775)), new Product(Action.CRAFT_BLOW_GLASS, 4527, new Ingredient(1775)), new Product(Action.CRAFT_BLOW_GLASS, 4525, new Ingredient(1775)), new Product(Action.CRAFT_BLOW_GLASS, 229, new Ingredient(1775)), new Product(Action.CRAFT_BLOW_GLASS, 6667, new Ingredient(1775)), new Product(Action.CRAFT_BLOW_GLASS, 567, new Ingredient(1775)), new Product(Action.CRAFT_BLOW_GLASS, 4542, new Ingredient(1775)), new Product(Action.CRAFT_BLOW_GLASS, 10980, new Ingredient(1775)), new Product(Action.CRAFT_LOOM, 5376, new Ingredient(5933, 6)), new Product(Action.CRAFT_LOOM, 5418, new Ingredient(5931, 4)), new Product(Action.CRAFT_LOOM_DRIFT_NET, 21652, new Ingredient(5931, 2)), new Product(Action.CRAFT_LOOM, 3224, new Ingredient(1759, 4)), new Product(Action.CRAFT_SHIELD, 22269, new Ingredient(1745, 2), new Ingredient(22257), new Ingredient(4819, 15)), new Product(Action.CRAFT_SHIELD, 22272, new Ingredient(6289, 2), new Ingredient(22254), new Ingredient(4820, 15)), new Product(Action.CRAFT_SHIELD, 22275, new Ingredient(1745, 2), new Ingredient(22257), new Ingredient(1539, 15)), new Product(Action.CRAFT_SHIELD, 22278, new Ingredient(2505, 2), new Ingredient(22260), new Ingredient(4822, 15)), new Product(Action.CRAFT_SHIELD, 22281, new Ingredient(2507, 2), new Ingredient(22263), new Ingredient(4823, 15)), new Product(Action.CRAFT_SHIELD, 22284, new Ingredient(2509, 2), new Ingredient(22266), new Ingredient(4824, 15)), new Product(Action.FLETCH_CUT_BOW, 48, new Ingredient(1511)), new Product(Action.FLETCH_CUT_BOW, 56, new Ingredient(1521)), new Product(Action.FLETCH_CUT_BOW, 58, new Ingredient(1519)), new Product(Action.FLETCH_CUT_BOW, 62, new Ingredient(1517)), new Product(Action.FLETCH_CUT_BOW, 66, new Ingredient(1515)), new Product(Action.FLETCH_CUT_BOW, 70, new Ingredient(1513)), new Product(Action.FLETCH_CUT_BOW, 50, new Ingredient(1511)), new Product(Action.FLETCH_CUT_BOW, 54, new Ingredient(1521)), new Product(Action.FLETCH_CUT_BOW, 60, new Ingredient(1519)), new Product(Action.FLETCH_CUT_BOW, 64, new Ingredient(1517)), new Product(Action.FLETCH_CUT_BOW, 68, new Ingredient(1515)), new Product(Action.FLETCH_CUT_BOW, 72, new Ingredient(1513)), new Product(Action.FLETCH_STRING_BOW, 839, new Ingredient(48), new Ingredient(1777)), new Product(Action.FLETCH_STRING_BOW, 845, new Ingredient(56), new Ingredient(1777)), new Product(Action.FLETCH_STRING_BOW, 847, new Ingredient(58), new Ingredient(1777)), new Product(Action.FLETCH_STRING_BOW, 851, new Ingredient(62), new Ingredient(1777)), new Product(Action.FLETCH_STRING_BOW, 855, new Ingredient(66), new Ingredient(1777)), new Product(Action.FLETCH_STRING_BOW, 859, new Ingredient(70), new Ingredient(1777)), new Product(Action.FLETCH_STRING_BOW, 841, new Ingredient(50), new Ingredient(1777)), new Product(Action.FLETCH_STRING_BOW, 843, new Ingredient(54), new Ingredient(1777)), new Product(Action.FLETCH_STRING_BOW, 849, new Ingredient(60), new Ingredient(1777)), new Product(Action.FLETCH_STRING_BOW, 853, new Ingredient(64), new Ingredient(1777)), new Product(Action.FLETCH_STRING_BOW, 857, new Ingredient(68), new Ingredient(1777)), new Product(Action.FLETCH_STRING_BOW, 861, new Ingredient(72), new Ingredient(1777)), new Product(Action.FLETCH_SHIELD, 22251, new Ingredient(1521, 2)), new Product(Action.FLETCH_SHIELD, 22254, new Ingredient(1519, 2)), new Product(Action.FLETCH_SHIELD, 22257, new Ingredient(1517, 2)), new Product(Action.FLETCH_SHIELD, 22260, new Ingredient(1515, 2)), new Product(Action.FLETCH_SHIELD, 22263, new Ingredient(1513, 2)), new Product(Action.FLETCH_SHIELD, 22266, new Ingredient(19669, 2)), new Product(Action.FLETCH_CUT_CROSSBOW, 9440, new Ingredient(1511)), new Product(Action.FLETCH_CUT_CROSSBOW, 9442, new Ingredient(1521)), new Product(Action.FLETCH_CUT_CROSSBOW, 9444, new Ingredient(1519)), new Product(Action.FLETCH_CUT_CROSSBOW, 9446, new Ingredient(6333)), new Product(Action.FLETCH_CUT_CROSSBOW, 9448, new Ingredient(1517)), new Product(Action.FLETCH_CUT_CROSSBOW, 9450, new Ingredient(6332)), new Product(Action.FLETCH_CUT_CROSSBOW, 9452, new Ingredient(1515)), new Product(Action.FLETCH_CUT_CROSSBOW, 21952, new Ingredient(1513)), new Product(Action.FLETCH_ATTACH_CROSSBOW, 9454, new Ingredient(9440), new Ingredient(9420)), new Product(Action.FLETCH_ATTACH_CROSSBOW, 9456, new Ingredient(9442), new Ingredient(9422)), new Product(Action.FLETCH_ATTACH_CROSSBOW, 9457, new Ingredient(9444), new Ingredient(9423)), new Product(Action.FLETCH_ATTACH_CROSSBOW, 9459, new Ingredient(9446), new Ingredient(9425)), new Product(Action.FLETCH_ATTACH_CROSSBOW, 9461, new Ingredient(9448), new Ingredient(9427)), new Product(Action.FLETCH_ATTACH_CROSSBOW, 9463, new Ingredient(9450), new Ingredient(9429)), new Product(Action.FLETCH_ATTACH_CROSSBOW, 9465, new Ingredient(9452), new Ingredient(9431)), new Product(Action.FLETCH_ATTACH_CROSSBOW, 21921, new Ingredient(21952), new Ingredient(21918)), new Product(Action.FLETCH_STRING_CROSSBOW, 9174, new Ingredient(9454), new Ingredient(9438)), new Product(Action.FLETCH_STRING_CROSSBOW, 9176, new Ingredient(9456), new Ingredient(9438)), new Product(Action.FLETCH_STRING_CROSSBOW, 9177, new Ingredient(9457), new Ingredient(9438)), new Product(Action.FLETCH_STRING_CROSSBOW, 9179, new Ingredient(9459), new Ingredient(9438)), new Product(Action.FLETCH_STRING_CROSSBOW, 9181, new Ingredient(9461), new Ingredient(9438)), new Product(Action.FLETCH_STRING_CROSSBOW, 9183, new Ingredient(9463), new Ingredient(9438)), new Product(Action.FLETCH_STRING_CROSSBOW, 9185, new Ingredient(9465), new Ingredient(9438)), new Product(Action.FLETCH_STRING_CROSSBOW, 21902, new Ingredient(21921), new Ingredient(9438)), new Product(Action.FLETCH_ATTACH_TIPS, 21969, new Ingredient(21905, 10), new Ingredient(9192, 10)), new Product(Action.FLETCH_ATTACH_TIPS, 21971, new Ingredient(21905, 10), new Ingredient(9192, 10)), new Product(Action.FLETCH_ATTACH_TIPS, 21965, new Ingredient(21905, 10), new Ingredient(9192, 10)), new Product(Action.FLETCH_ATTACH_TIPS, 21957, new Ingredient(21905, 10), new Ingredient(9192, 10)), new Product(Action.FLETCH_ATTACH_TIPS, 21973, new Ingredient(21905, 10), new Ingredient(9192, 10)), new Product(Action.FLETCH_ATTACH_TIPS, 21955, new Ingredient(21905, 10), new Ingredient(9192, 10)), new Product(Action.FLETCH_ATTACH_TIPS, 21959, new Ingredient(21905, 10), new Ingredient(9192, 10)), new Product(Action.FLETCH_ATTACH_TIPS, 21967, new Ingredient(21905, 10), new Ingredient(9192, 10)), new Product(Action.FLETCH_ATTACH_TIPS, 21963, new Ingredient(21905, 10), new Ingredient(9192, 10)), new Product(Action.FLETCH_ATTACH_TIPS, 21961, new Ingredient(21905, 10), new Ingredient(9192, 10)), new Product(Action.FLETCH_DART, 806, new Ingredient(819, 10), new Ingredient(314, 10)), new Product(Action.FLETCH_DART, 807, new Ingredient(820, 10), new Ingredient(314, 10)), new Product(Action.FLETCH_DART, 808, new Ingredient(821, 10), new Ingredient(314, 10)), new Product(Action.FLETCH_DART, 809, new Ingredient(822, 10), new Ingredient(314, 10)), new Product(Action.FLETCH_DART, 810, new Ingredient(823, 10), new Ingredient(314, 10)), new Product(Action.FLETCH_DART, 811, new Ingredient(824, 10), new Ingredient(314, 10)), new Product(Action.FLETCH_DART, 25849, new Ingredient(25853, 10), new Ingredient(314, 10)), new Product(Action.FLETCH_DART, 11230, new Ingredient(11232, 10), new Ingredient(314, 10)), new Product(Action.FARM_ULTRA_COMPOST, 21483, new Ingredient(21622, 2), new Ingredient(6034))};
    private final int[] widgetProductIds = new int[9];
    @Inject
    private Client client;
    @Inject
    private InventoryManager inventoryManager;
    @Inject
    private ActionUtils actionUtils;
    private int selectedIndex = -1;
    private String question;

    @Subscribe
    public void onVarbitChanged(VarbitChanged evt) {
        if (evt.getValue() == 2673) {
            this.selectedIndex = this.client.getVarpValue(evt.getValue());
        }
    }

    @Subscribe
    public void onScriptPreFired(ScriptPreFired evt) {
        if (evt.getScriptId() == 2051 || evt.getScriptId() == 2050) {
            Widget source;
            ScriptEvent se = evt.getScriptEvent();
            Widget widget = source = se == null ? null : se.getSource();
            if (source != null) {
                this.selectedIndex = source.getId() - 0x10E000E;
            }
        }
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired evt) {
        if (evt.getScriptId() == 2046) {
            log.debug("[proc_itembutton_draw] updating products");
            this.updateProducts();
        } else if (evt.getScriptId() == 2052) {
            this.onQuestionAnswered();
        }
    }

    @Override
    protected void unhandled(int itemId) {
        log.warn("[*] Unhandled chatbox action");
        log.warn(" |-> Question: {}", (Object)this.question);
        log.warn(" |-> Item ID: {}", (Object)itemId);
    }

    @Override
    public void setup() {
        this.registerAction(Action.COOKING_TOP_PIZZA, 2285, 2287, 2301, 2297, 2293);
        this.registerAction(Action.COOKING_MIX_GRAPES, 1995, 1996, 20752);
        this.registerAction(Action.COOKING_MIX_DOUGH, 2307, 1953, 1863, 2283);
        this.registerAction(Action.FLETCH_ATTACH, Fletching.UNENCHANTED_BOLTS_AND_ARROWS);
        this.registerAction(Action.FLETCH_ATTACH, 53, 2865, 21316, 21326);
        this.registerAction(Action.FLETCH_JAVELIN, Fletching.JAVELINS);
        this.registerAction(Action.FLETCH_CUT_ARROW_SHAFT, 52, 20696, 2864);
        this.registerAction(Action.FLETCH_CUT_TIPS, Fletching.BOLT_TIPS);
        this.registerAction(Action.CRAFT_AMETHYST_HEADS_AND_TIPS, Crafting.AMETHYST_HEADS_AND_TIPS);
        this.registerAction(Action.HERB_MIX_TAR, 10142, 10143, 10144, 10145);
        for (Recipe recipe : Herblore.UNFINISHED_POTIONS) {
            this.registerAction(Action.HERB_MIX_UNFINISHED, recipe.getProductId());
        }
        for (Recipe recipe : Herblore.POTIONS) {
            this.registerAction(Action.HERB_MIX_POTIONS, recipe.getIsSelectingIngredientAsProduct() != false ? recipe.getRequirements()[0].getItemId() : recipe.getProductId());
        }
        this.registerAction(Action.MAGIC_ENCHANT_BOLTS, Fletching.ENCHANTED_BOLTS);
    }

    private void onQuestionAnswered() {
        String question;
        int currentProductId = this.widgetProductIds[this.selectedIndex];
        int amount = this.getActionCount(currentProductId);
        switch (question = this.question == null ? "?" : this.question) {
            case "How many would you like to cook?": 
            case "What would you like to cook?": {
                this.actionManager.setAction(Action.COOKING, amount, currentProductId);
                break;
            }
            case "How would you like to cut the pineapple?": {
                if (currentProductId == 2118) {
                    amount = Math.min(amount, this.actionUtils.getActionsUntilFull(4, 1));
                }
                this.actionManager.setAction(Action.COOKING_CUT_FRUIT, amount, currentProductId);
                break;
            }
            case "How many would you like to charge?": {
                Magic.ChargeOrbSpell spell = Magic.ChargeOrbSpell.byProduct(currentProductId);
                Objects.requireNonNull(spell, "No charge orb spell found for product: " + currentProductId);
                this.actionManager.setAction(Action.MAGIC_CHARGE_ORB, Math.min(amount, spell.getSpell().getAvailableCasts(this.client)), currentProductId);
                break;
            }
            default: {
                Product recipe = (Product)Recipe.forProduct((Recipe[])MULTI_MATERIAL_PRODUCTS, (int)currentProductId);
                if (recipe != null) {
                    amount = Math.min(amount, recipe.getMakeProductCount(this.inventoryManager));
                    this.actionManager.setAction(recipe.getAction(), amount, recipe.getIsSelectingIngredientAsProduct() != false ? recipe.getProductId() : currentProductId);
                    break;
                }
                this.setActionByItemId(currentProductId, amount);
            }
        }
    }

    private void updateProducts() {
        for (int slotIndex = 0; slotIndex < 9; ++slotIndex) {
            int id;
            Widget slotWidget = this.client.getWidget(270, 14 + slotIndex);
            Widget container = slotWidget == null ? null : slotWidget.getChild(38);
            int n = id = container == null ? -1 : container.getItemId();
            if (id == -1 || id == 5610 || id == 12841) continue;
            this.widgetProductIds[slotIndex] = id;
        }
        Widget questionWidget = this.client.getWidget(270, 5);
        if (questionWidget != null) {
            this.question = questionWidget.getText();
        }
        log.debug("updated products: {}", (Object)Arrays.toString(this.widgetProductIds));
    }

    private int getActionCount(int productId) {
        int n = this.client.getVarcIntValue(200);
        for (Smithing.Bar bar : Smithing.Bar.values()) {
            if (productId != bar.getItemId()) continue;
            return Math.min(n, bar.countAvailableOres(this.client));
        }
        for (Enum enum_ : Cooking.Cookable.values()) {
            IDs raw = ((Cooking.Cookable)enum_).getRaw();
            IDs cooked = ((Cooking.Cookable)enum_).getCooked();
            if (!cooked.contains(productId)) continue;
            int rawFish = this.inventoryManager.getItemCount(raw::contains);
            return Math.min(n, rawFish);
        }
        return n;
    }
}

