/*
 * Decompiled with CFR 0.152.
 */
package com.github.calebwhiting.runelite.plugins.actionprogress.detect;

import com.github.calebwhiting.runelite.plugins.actionprogress.Action;
import com.github.calebwhiting.runelite.plugins.actionprogress.ActionManager;
import com.google.inject.Inject;
import java.util.HashMap;
import net.runelite.client.game.ItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionDetector {
    private static final Logger log = LoggerFactory.getLogger(ActionDetector.class);
    protected final HashMap<Integer, Action> itemActions = new HashMap();
    @Inject
    protected ItemManager itemManager;
    @Inject
    protected ActionManager actionManager;

    protected void registerAction(Action action, int ... itemIds) {
        for (int id : itemIds) {
            this.itemActions.put(id, action);
            log.debug("Registered action {} for item: {}", (Object)action, (Object)id);
        }
    }

    protected void setActionByItemId(int itemId, int amount) {
        log.debug("looking for action by item id: {}", (Object)itemId);
        Action action = this.itemActions.get(itemId);
        if (action == null) {
            this.unhandled(itemId);
        } else {
            this.actionManager.setAction(action, amount, itemId);
        }
    }

    protected void unhandled(int itemId) {
        log.error("Unhandled product: {}", (Object)itemId);
    }

    public void setup() {
    }

    public void shutDown() {
    }
}

