/*
 * Decompiled with CFR 0.152.
 */
package com.github.calebwhiting.runelite.plugins.actionprogress;

import com.github.calebwhiting.runelite.api.ui.Alignment;
import com.github.calebwhiting.runelite.api.ui.Rendering;
import com.github.calebwhiting.runelite.plugins.actionprogress.ActionManager;
import com.github.calebwhiting.runelite.plugins.actionprogress.ActionProgressConfig;
import com.github.calebwhiting.runelite.plugins.actionprogress.ActionProgressPlugin;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import net.runelite.api.Client;
import net.runelite.client.config.RuneLiteConfig;
import net.runelite.client.ui.overlay.Overlay;

@Singleton
public class ActionProgressOverlay
extends Overlay {
    private static final Dimension EMPTY = new Dimension(0, 0);
    private static final int ICON_SIZE = 32;
    private static final int INSET = 5;
    private static final int PAD = 2;
    private static final int PROGRESS_MIN_HEIGHT = 40;
    private static final int PROGRESS_MIN_WIDTH = 150;
    private static final int PROGRESS_MIN_WIDTH_VERTICAL = 5;
    @Inject
    private ActionProgressPlugin plugin;
    @Inject
    private ActionManager actionManager;
    @Inject
    private Client client;
    @Inject
    private RuneLiteConfig runeLiteConfig;
    @Inject
    private ActionProgressConfig config;

    public Dimension render(Graphics2D g) {
        try {
            long value;
            long max;
            long min;
            Dimension preferredDimension = this.getPreferredSize();
            int tick = this.client.getTickCount();
            Image icon = this.plugin.getCurrentProductImage();
            if (tick > this.actionManager.getActionEndTick()) {
                return EMPTY;
            }
            String timeString = this.config.useTicks() ? String.format("%dt", Math.round(this.actionManager.getTicksLeft())) : String.format("%ds", Math.round((float)this.actionManager.getApproximateCompletionTime() / 1000.0f));
            String header = String.format("%s", this.plugin.getCurrentActionName());
            String count = String.format("%d/%d", this.actionManager.getCurrentActionProcessed(), this.actionManager.getActionCount());
            if (this.config.smoothProgressBar()) {
                min = this.actionManager.getActionStartMs();
                max = this.actionManager.getActionEndMs();
                value = System.currentTimeMillis();
            } else {
                min = this.actionManager.getActionStartTick();
                max = this.actionManager.getActionEndTick();
                value = tick;
            }
            return this.renderInfobox(g, header, count, timeString, icon, min, max, value, preferredDimension);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return EMPTY;
        }
    }

    private Dimension renderInfobox(Graphics2D g, String header, String count, String timeString, Image icon, long min, long max, long value, Dimension preferredDimension) {
        int height;
        FontMetrics fm = g.getFontMetrics();
        int minWidthHorizontal = 194;
        int preferredWidth = preferredDimension != null ? (int)preferredDimension.getWidth() : 200;
        int widthWithIcon = 54;
        int preferredHeight = preferredDimension != null ? (int)preferredDimension.getHeight() : 55;
        int heightWithIcon = 37 + fm.getHeight();
        boolean isVertical = false;
        int width = 0;
        if (preferredWidth < minWidthHorizontal) {
            isVertical = true;
            width = Math.max(24, preferredWidth);
            height = Math.max(84, preferredHeight);
        } else {
            width = Math.max(194, preferredWidth);
            height = Math.max(10 + fm.getHeight() + 5 + 5 + 2 + 2, preferredHeight);
        }
        Color border = Rendering.outsideStrokeColor(this.runeLiteConfig.overlayBackgroundColor());
        Color progressDoneColor = this.config.progressDoneColor();
        Color progressLeftColor = this.config.progressLeftColor();
        g.setColor(this.runeLiteConfig.overlayBackgroundColor());
        g.fillRect(0, 0, width, height);
        g.setColor(border);
        g.drawRect(0, 0, width, height);
        Object actionText = header + " (" + count + ")";
        if (isVertical) {
            Rectangle left = new Rectangle(5, 5, fm.getHeight(), height - 10);
            Rectangle right = new Rectangle((int)left.getMaxX() + left.x, left.y, Math.max(5, width - left.width - 5 - left.x - 2), height - 10);
            if (height < ((String)actionText).length() * 10 + 32 + 5 + 5 + 5) {
                actionText = count;
            }
            if (width <= widthWithIcon) {
                Rendering.drawText(g, new Rectangle(2, left.y, width, 5 + fm.getHeight() + 2), Color.ORANGE, Alignment.CENTER, timeString, false);
                Rendering.drawText(g, new Rectangle(left.x, 7 + fm.getHeight() + 5 + 2, left.width, Math.max(5, right.height - 2 - 5 - fm.getHeight() - 2)), Color.WHITE, Alignment.CENTER, (String)actionText, isVertical);
            } else {
                left = new Rectangle(5, 37, 32, height - 32 - 10);
                right = new Rectangle(39, 5, Math.max(5, width - 5 - 32 - 2 - 5), height - 10);
                int iconWidth = icon.getWidth(null);
                int iconHeight = icon.getHeight(null);
                g.drawImage(icon, 21 - iconWidth / 2, 21 - iconHeight / 2, iconWidth, iconHeight, null);
                Rendering.drawText(g, new Rectangle(right.x, right.y, right.width, 5 + fm.getHeight() + 2), Color.ORANGE, Alignment.CENTER, timeString, false);
                Rendering.drawText(g, left, Color.WHITE, Alignment.CENTER, (String)actionText, isVertical);
            }
            Rendering.drawProgressBar(g, new Rectangle(right.x, 7 + fm.getHeight() + 5 + 2, right.width, Math.max(5, right.height - 2 - 5 - fm.getHeight() - 2)), border, progressLeftColor, progressDoneColor, min, max, value, isVertical);
        } else {
            if (height <= heightWithIcon) {
                Rendering.drawText(g, new Rectangle(5, height / 2 - fm.getHeight() / 2, 32, fm.getHeight() + 2), Color.ORANGE, Alignment.CENTER, timeString, isVertical);
            } else {
                int iconWidth = icon.getWidth(null);
                int iconHeight = icon.getHeight(null);
                g.drawImage(icon, 21 - iconWidth / 2, 21 - iconHeight / 2, iconWidth, iconHeight, null);
                Rendering.drawText(g, new Rectangle(5, Math.max(39, height / 2), 32, fm.getHeight()), Color.ORANGE, Alignment.CENTER, timeString, isVertical);
            }
            Rectangle right = new Rectangle(39, 5, Math.max(150, width - 5 - 32 - 2 - 5), height - 10);
            Rendering.drawText(g, new Rectangle(right.x, right.y, right.width, 5 + fm.getHeight() + 2), Color.WHITE, Alignment.CENTER, (String)actionText, isVertical);
            Rendering.drawProgressBar(g, new Rectangle(right.x, 7 + fm.getHeight() + 5 + 2, right.width, height - (10 + fm.getHeight() + 5 + 5)), border, progressLeftColor, progressDoneColor, min, max, value, isVertical);
        }
        return new Dimension(width, height);
    }
}

