/*
 * Decompiled with CFR 0.152.
 */
package com.github.calebwhiting.runelite.plugins.actionprogress;

import java.awt.Color;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;

@ConfigGroup(value="actionprogress")
public interface ActionProgressConfig
extends Config {
    @ConfigSection(name="Cooking actions", description="Enable/Disable cooking specific actions.", position=7)
    public static final String COOKING = "Cooking actions";
    @ConfigSection(name="Smithing actions", description="Enable/Disable smithing specific actions.", position=8)
    public static final String SMITHING = "Smithing actions";
    @ConfigSection(name="Crafting actions", description="Enable/Disable crafting specific actions.", position=9)
    public static final String CRAFTING = "Crafting actions";
    @ConfigSection(name="Fletching actions", description="Enable/Disable fletching specific actions.", position=10)
    public static final String FLETCHING = "Fletching actions";
    @ConfigSection(name="Herblore actions", description="Enable/Disable herblore specific actions.", position=11)
    public static final String HERBLORE = "Herblore actions";
    @ConfigSection(name="Magic actions", description="Enable/Disable magic specific actions.", position=12)
    public static final String MAGIC = "Magic actions";
    @ConfigSection(name="Farming actions", description="Enable/Disable Farming actions.", position=13)
    public static final String FARMING = "Farming actions";
    @ConfigSection(name="Tempoross actions", description="Enable/Disable tempoross specific actions.", position=14)
    public static final String TEMPOROSS = "Tempoross actions";
    @ConfigSection(name="Wintertodt actions (not yet supported)", description="Enable/Disable wintertodt specific actions.", position=15, closedByDefault=true)
    public static final String WINTERTODT = "Wintertodt actions";
    @ConfigSection(name="Miscellaneous actions", description="Enable/Disable miscellaneous actions.", position=16)
    public static final String MISCELLANEOUS = "Miscellaneous actions";

    @ConfigItem(name="Show ticks instead of seconds", keyName="use-ticks", description="Enable/Disable the usage of ticks when displaying the progress bar.", position=0)
    default public boolean useTicks() {
        return false;
    }

    @ConfigItem(name="Notify when finished", keyName="notify-when-finished", description="Enable/Disable notifications when actions are completed or interrupted.", position=1)
    default public boolean notifyWhenFinished() {
        return true;
    }

    @ConfigItem(name="Smooth progress bar", keyName="smooth-progress-bar", description="Enable/Disable smooth progress bar.", position=2)
    default public boolean smoothProgressBar() {
        return true;
    }

    @ConfigItem(name="Product icons", keyName="show-product-icons", description="When enabled, show the product icon in the infobox where available. Otherwise fallback to skill icons.", position=3)
    default public boolean showProductIcons() {
        return true;
    }

    @ConfigItem(name="Ignore single actions", keyName="ignore-single-actions", description="Ignore single actions", position=4)
    default public boolean ignoreSingleActions() {
        return true;
    }

    @Alpha
    @ConfigItem(name="Progress left color", keyName="progress-left-color", description="Color to be used to display the remaining actions on the progress bar", position=5)
    default public Color progressLeftColor() {
        return new Color(255, 52, 52, 100);
    }

    @Alpha
    @ConfigItem(name="Progress done color", keyName="progress-done-color", description="Color to be used to display the completed actions on the progress bar", position=6)
    default public Color progressDoneColor() {
        return new Color(0, 255, 52, 100);
    }

    @ConfigItem(name="Cooking", keyName="cooking.cooking", description="Enable/Disable monitoring cooking.", section="Cooking actions")
    default public boolean cookingCooking() {
        return true;
    }

    @ConfigItem(name="Mixing wine", keyName="cooking.mix-wine", description="Enable/Disable monitoring mixing wine.", section="Cooking actions")
    default public boolean cookingMixWines() {
        return true;
    }

    @ConfigItem(name="Mixing pastry", keyName="cooking.mix-pastry", description="Enable/Disable monitoring mixing pastry.", section="Cooking actions")
    default public boolean cookingMixPastry() {
        return true;
    }

    @ConfigItem(name="Topping pizza", keyName="cooking.top-pizza", description="Enable/Disable monitoring topping pizza.", section="Cooking actions")
    default public boolean cookingTopPizza() {
        return true;
    }

    @ConfigItem(name="Cutting fruit", keyName="cooking.slicing", description="Enable/Disable monitoring cutting fruit.", section="Cooking actions")
    default public boolean cookingCutFruit() {
        return true;
    }

    @ConfigItem(name="Smelting Items", keyName="smithing.smelting", description="Enable/Disable monitoring smelting.", section="Smithing actions")
    default public boolean smithSmelting() {
        return true;
    }

    @ConfigItem(name="Smithing Items", keyName="smithing.smithing", description="Enable/Disable monitoring smithing items.", section="Smithing actions")
    default public boolean smithSmithing() {
        return true;
    }

    @ConfigItem(name="Cannonballs", keyName="smithing.cannonballs", description="Enable/Disable monitoring casting cannonballs", section="Smithing actions")
    default public boolean smithCannonballs() {
        return true;
    }

    @ConfigItem(name="Casting gold & silver", keyName="crafting.cast-gold-and-silver", description="Enable/Disable monitoring casting gold & silver items.", section="Crafting actions")
    default public boolean craftCastGoldAndSilver() {
        return true;
    }

    @ConfigItem(name="Creating molten glass", keyName="crafting.molten-glass", description="Enable/Disable monitoring creating molten glass.", section="Crafting actions")
    default public boolean craftMakeMoltenGlass() {
        return true;
    }

    @ConfigItem(name="Glassblowing", keyName="crafting.glassblowing", description="Enable/Disable monitoring glassblowing.", section="Crafting actions")
    default public boolean craftGlassblowing() {
        return true;
    }

    @ConfigItem(name="Stringing jewellery", keyName="crafting.string", description="Enable/Disable monitoring stringing jewellery.", section="Crafting actions")
    default public boolean craftStringJewellery() {
        return true;
    }

    @ConfigItem(name="Cutting gems", keyName="crafting.gems", description="Enable/Disable monitoring cutting gems.", section="Crafting actions")
    default public boolean craftCutGems() {
        return true;
    }

    @ConfigItem(name="Leather-working", keyName="crafting.leather", description="Enable/Disable monitoring leather-working.", section="Crafting actions")
    default public boolean craftLeatherWorking() {
        return true;
    }

    @ConfigItem(name="Battlestaves", keyName="crafting.battlestaves", description="Enable/Disable monitoring attaching orbs to battlestaves.", section="Crafting actions")
    default public boolean craftBattlestaves() {
        return true;
    }

    @ConfigItem(name="Weaving", keyName="crafting.waeving", description="Enable/Disable monitoring for items crafted at a loom.", section="Crafting actions")
    default public boolean craftWeaving() {
        return true;
    }

    @ConfigItem(name="Making shields", keyName="crafting.shields", description="Enable/Disable monitoring for crafting wooden shields into leather shields.", section="Crafting actions")
    default public boolean craftShields() {
        return true;
    }

    @ConfigItem(name="Making amethyst heads and tips", keyName="crafting.headsAndTips", description="Enable/Disable monitoring for crafting amethyst heads and tips.", section="Crafting actions")
    default public boolean craftHeadsAndTips() {
        return true;
    }

    @ConfigItem(name="Arrows & bolts", keyName="fletching.ammunition", description="Enable/Disable monitoring fletching arrows & bolts.", section="Fletching actions")
    default public boolean fletchArrowsAndBolts() {
        return true;
    }

    @ConfigItem(name="Making bows", keyName="fletching.bows", description="Enable/Disable monitoring cutting & stringing bows.", section="Fletching actions")
    default public boolean fletchBows() {
        return true;
    }

    @ConfigItem(name="Making crossbows", keyName="fletching.crossbows", description="Enable/Disable monitoring cutting & stringing crossbows.", section="Fletching actions")
    default public boolean fletchCrossbows() {
        return true;
    }

    @ConfigItem(name="Making shields", keyName="fletching.shields", description="Enable/Disable monitoring cutting logs into shields.", section="Fletching actions")
    default public boolean fletchShields() {
        return true;
    }

    @ConfigItem(name="Making javelins", keyName="fletching.javelins", description="Enable/Disable monitoring attaching heads on javelin shafts.", section="Fletching actions")
    default public boolean fletchJavelin() {
        return true;
    }

    @ConfigItem(name="Herb cleaning", keyName="herblore.cleaning", description="Enable/Disable monitoring herb cleaning.", section="Herblore actions")
    default public boolean herbCleaning() {
        return true;
    }

    @ConfigItem(name="Mixing potions", keyName="herblore.potions", description="Enable/Disable monitoring mixing potions.", section="Herblore actions")
    default public boolean herbPotions() {
        return true;
    }

    @ConfigItem(name="Chemistry amulet", keyName="herblore.chemistry", description="Stop when chemistry amulet breaks.", section="Herblore actions")
    default public boolean herbChemistry() {
        return true;
    }

    @ConfigItem(name="Mixing tar", keyName="herblore.tar", description="Enable/Disable monitoring mixing tar.", section="Herblore actions")
    default public boolean herbTar() {
        return true;
    }

    @ConfigItem(name="Enchant jewellery spells", keyName="magic.enchant-jewellery", description="Enable/Disable monitoring jewellery enchantment spells.", section="Magic actions")
    default public boolean magicEnchantJewellery() {
        return true;
    }

    @ConfigItem(name="Charge orb spells", keyName="magic.charge-orbs", description="Enable/Disable monitoring charge obs spells.", section="Magic actions")
    default public boolean magicChargeOrbs() {
        return true;
    }

    @ConfigItem(name="Plank make spell", keyName="magic.plank-make", description="Enable/Disable monitoring plank make spell.", section="Magic actions")
    default public boolean magicPlankMake() {
        return true;
    }

    @ConfigItem(name="Enchant bolt spells", keyName="magic.enchant-bolts", description="Enable/Disable monitoring bolt enchantment spells.", section="Magic actions")
    default public boolean magicEnchantBolts() {
        return true;
    }

    @ConfigItem(name="Creating tablets", keyName="magic.tablets", description="Enable/Disable monitoring creating magic tablets at a lectern.", section="Magic actions")
    default public boolean magicTablets() {
        return true;
    }

    @ConfigItem(name="Creating ultracompost", keyName="farming.ultracompost", description="Enable/Disable monitoring for creating ultracompost.", section="Farming actions")
    default public boolean farmUltraCompost() {
        return true;
    }

    @ConfigItem(name="Cooking", keyName="tempoross.cooking", description="Enable/Disable monitoring tempoross cooking.", section="Tempoross actions")
    default public boolean temporossCooking() {
        return true;
    }

    @ConfigItem(name="Firing", keyName="tempoross.firing", description="Enable/Disable monitoring tempoross firing.", section="Tempoross actions")
    default public boolean temporossFiring() {
        return true;
    }

    @ConfigItem(name="Reward pool", keyName="tempoross.reward-pool", description="Enable/Disable monitoring tempoross reward pool.", section="Tempoross actions")
    default public boolean temporossRewardPool() {
        return true;
    }

    @ConfigItem(name="Woodcutting", keyName="wintertodt.woodcutting", description="Enable/Disable monitoring wintertodt woodcutting.", section="Wintertodt actions")
    default public boolean wintertodtWoodcutting() {
        return true;
    }

    @ConfigItem(name="Burning", keyName="wintertodt.burning", description="Enable/Disable monitoring wintertodt burning.", section="Wintertodt actions")
    default public boolean wintertodtLighting() {
        return true;
    }

    @ConfigItem(name="Fletching", keyName="wintertodt.fletching", description="Enable/Disable monitoring wintertodt fletching.", section="Wintertodt actions")
    default public boolean wintertodtFletching() {
        return true;
    }

    @ConfigItem(name="Collecting sand", keyName="misc.collect-sand", description="Enable/Disable monitoring collecting sand.", section="Miscellaneous actions")
    default public boolean collectSand() {
        return true;
    }

    @ConfigItem(name="Grinding items", keyName="misc.grinding", description="Enable/Disable monitoring grinding items.", section="Miscellaneous actions")
    default public boolean grinding() {
        return true;
    }
}

