/*
 * Decompiled with CFR 0.152.
 */
package com.github.calebwhiting.runelite.plugins.actionprogress;

import com.github.calebwhiting.runelite.api.InterruptManager;
import com.github.calebwhiting.runelite.api.TickManager;
import com.github.calebwhiting.runelite.api.event.Interrupt;
import com.github.calebwhiting.runelite.plugins.actionprogress.Action;
import com.github.calebwhiting.runelite.plugins.actionprogress.ActionProgressConfig;
import com.github.calebwhiting.runelite.plugins.actionprogress.event.ActionStartedEvent;
import com.github.calebwhiting.runelite.plugins.actionprogress.event.ActionStoppedEvent;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.events.GameTick;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ActionManager {
    private static final Logger log = LoggerFactory.getLogger(ActionManager.class);
    @Inject
    private EventBus eventBus;
    @Inject
    private Client client;
    @Inject
    private InterruptManager interruptManager;
    @Inject
    private TickManager tickManager;
    @Inject
    private ActionProgressConfig config;
    private int actionStartTick;
    private long actionStartMs;
    private int actionEndTick;
    private long actionEndMs;
    private int actionCount;
    private Action currentAction;
    private int currentProductId = -1;

    private static int calculateActionTicks(Action action, int actionCount) {
        int nTicksElapsed = 0;
        int[] timings = action.getTickTimes();
        for (int i = 0; i < actionCount; ++i) {
            nTicksElapsed += timings[i >= timings.length ? timings.length - 1 : i];
        }
        return nTicksElapsed;
    }

    public void setAction(Action action, int actionCount, int itemId) {
        if (!action.getEnabledFunction().apply(this.config).booleanValue()) {
            log.debug("action {} is disabled", (Object)action);
            return;
        }
        if (actionCount <= 1 && this.config.ignoreSingleActions()) {
            log.debug("ignoring single action");
            return;
        }
        this.currentAction = action;
        this.currentProductId = itemId;
        this.actionStartTick = this.client.getTickCount();
        this.actionEndTick = this.actionStartTick + ActionManager.calculateActionTicks(action, actionCount);
        long duration = (long)ActionManager.calculateActionTicks(action, actionCount) * 600L;
        this.actionStartMs = System.currentTimeMillis();
        this.actionEndMs = this.actionStartMs + duration;
        this.actionCount = actionCount;
        this.interruptManager.setWaiting(true);
        log.debug("Started action: {} x {} ({} -> {})", new Object[]{this.actionCount, action.name(), this.actionStartTick, this.actionEndTick});
        this.eventBus.post((Object)new ActionStartedEvent(action, itemId, actionCount, this.actionStartTick, this.actionEndTick));
    }

    private void resetAction() {
        log.debug("resetting action");
        if (this.currentAction != null) {
            this.eventBus.post((Object)new ActionStoppedEvent(this.currentAction, this.currentProductId, this.actionCount, this.actionStartTick, this.actionEndTick, this.client.getTickCount() < this.actionEndTick));
        }
        this.currentAction = null;
        this.actionCount = -1;
        this.actionEndTick = -1;
        this.actionStartTick = -1;
        this.currentProductId = -1;
        this.actionEndMs = 0L;
        this.actionStartMs = 0L;
    }

    @Subscribe(priority=-1.0f)
    public void onInterrupt(Interrupt evt) {
        if (!evt.isConsumed()) {
            this.resetAction();
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        this.actionEndMs = System.currentTimeMillis() + this.getApproximateCompletionTime();
        if (this.actionEndTick != -1 && this.client.getTickCount() >= this.actionEndTick) {
            log.debug("action end tick has passed");
            if (this.interruptManager.isWaiting()) {
                this.interruptManager.setWaiting(false);
            }
            this.resetAction();
        }
    }

    public int getCurrentActionProcessed() {
        int[] timings;
        if (this.currentAction == null) {
            return 0;
        }
        int actions = 0;
        int rem = this.client.getTickCount() - this.actionStartTick;
        for (int tickTime : timings = this.currentAction.getTickTimes()) {
            if ((rem -= tickTime) >= 0) {
                ++actions;
                continue;
            }
            rem = 0;
            break;
        }
        return actions + rem / timings[timings.length - 1];
    }

    public float getTicksLeft() {
        int tick = this.client.getTickCount();
        float ticksLeft = (float)this.actionEndTick - (float)tick;
        if (ticksLeft <= 0.0f) {
            return 0.0f;
        }
        return ticksLeft;
    }

    public long getApproximateCompletionTime() {
        float ticksLeft = this.getTicksLeft();
        long timeSinceTick = System.currentTimeMillis() - this.tickManager.getLastTickTime();
        return Math.round(ticksLeft * 600.0f - (float)timeSinceTick);
    }

    public int getActionStartTick() {
        return this.actionStartTick;
    }

    public long getActionStartMs() {
        return this.actionStartMs;
    }

    public int getActionEndTick() {
        return this.actionEndTick;
    }

    public long getActionEndMs() {
        return this.actionEndMs;
    }

    public int getActionCount() {
        return this.actionCount;
    }

    public Action getCurrentAction() {
        return this.currentAction;
    }

    public int getCurrentProductId() {
        return this.currentProductId;
    }

    public void setCurrentProductId(int currentProductId) {
        this.currentProductId = currentProductId;
    }
}

