/*
 * Decompiled with CFR 0.152.
 */
package com.github.calebwhiting.runelite.data;

import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;

public interface Smithing {

    public static class OreRequirement {
        private final Ore ore;
        private final int amount;

        public OreRequirement(Ore ore, int amount) {
            this.ore = ore;
            this.amount = amount;
        }

        public Ore getOre() {
            return this.ore;
        }

        public int getAmount() {
            return this.amount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OreRequirement)) {
                return false;
            }
            OreRequirement other = (OreRequirement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getAmount() != other.getAmount()) {
                return false;
            }
            Ore this$ore = this.getOre();
            Ore other$ore = other.getOre();
            return !(this$ore == null ? other$ore != null : !((Object)((Object)this$ore)).equals((Object)other$ore));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OreRequirement;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAmount();
            Ore $ore = this.getOre();
            result = result * 59 + ($ore == null ? 43 : ((Object)((Object)$ore)).hashCode());
            return result;
        }

        public String toString() {
            return "Smithing.OreRequirement(ore=" + this.getOre() + ", amount=" + this.getAmount() + ")";
        }
    }

    public static enum Ore {
        TIN(438),
        COPPER(436),
        IRON(440),
        BLURITE(668),
        SILVER(442),
        COAL(453),
        GOLD(444),
        MITHRIL(447),
        ADAMANTITE(449),
        RUNITE(451);

        private final int itemId;

        public int getItemId() {
            return this.itemId;
        }

        private Ore(int itemId) {
            this.itemId = itemId;
        }
    }

    public static enum Bar {
        BRONZE(2349, new OreRequirement(Ore.COPPER, 1), new OreRequirement(Ore.TIN, 1)),
        BLURITE(9467, new OreRequirement(Ore.BLURITE, 1)),
        IRON(2351, new OreRequirement(Ore.IRON, 1)),
        SILVER(2355, new OreRequirement(Ore.SILVER, 1)),
        STEEL(2353, new OreRequirement(Ore.IRON, 1), new OreRequirement(Ore.COAL, 2)),
        GOLD(2357, new OreRequirement(Ore.GOLD, 1)),
        MITHRIL(2359, new OreRequirement(Ore.MITHRIL, 1), new OreRequirement(Ore.COAL, 4)),
        ADAMANTITE(2361, new OreRequirement(Ore.ADAMANTITE, 1), new OreRequirement(Ore.COAL, 6)),
        RUNITE(2363, new OreRequirement(Ore.RUNITE, 1), new OreRequirement(Ore.COAL, 8));

        private final int itemId;
        private final OreRequirement[] requirements;

        private Bar(int itemId, OreRequirement ... requirements) {
            this.itemId = itemId;
            this.requirements = requirements;
        }

        public int countAvailableOres(Client client) {
            ItemContainer inventory = client.getItemContainer(InventoryID.INVENTORY);
            if (inventory == null) {
                return 0;
            }
            int count = Integer.MAX_VALUE;
            for (OreRequirement requirement : this.requirements) {
                int oreCount = inventory.count(requirement.getOre().getItemId());
                if (oreCount == 0) {
                    return 0;
                }
                count = Math.min(count, oreCount / requirement.getAmount());
            }
            return count;
        }

        public int getItemId() {
            return this.itemId;
        }

        public OreRequirement[] getRequirements() {
            return this.requirements;
        }
    }
}

