/*
 * Decompiled with CFR 0.152.
 */
package com.github.calebwhiting.runelite.data;

import com.github.calebwhiting.runelite.api.InventoryManager;
import com.github.calebwhiting.runelite.data.Ingredient;
import java.util.Arrays;

public class Recipe {
    private final int productId;
    private final Ingredient[] requirements;
    private final Ingredient tool;
    private final Boolean isSelectingIngredientAsProduct;

    public Recipe(int productId, Ingredient[] requirements, Ingredient tool) {
        this.productId = productId;
        this.requirements = requirements;
        this.tool = tool;
        this.isSelectingIngredientAsProduct = false;
    }

    public Recipe(int productId, Ingredient ... requirements) {
        this.productId = productId;
        this.requirements = requirements;
        this.tool = null;
        this.isSelectingIngredientAsProduct = false;
    }

    public Recipe(int productId, Boolean isSelectingIngredientAsProduct, Ingredient ... requirements) {
        this.productId = productId;
        this.requirements = requirements;
        this.tool = null;
        this.isSelectingIngredientAsProduct = isSelectingIngredientAsProduct;
    }

    public static <T extends Recipe> T forProduct(T[] all, int productId) {
        for (T v : all) {
            if (((Recipe)v).getIsSelectingIngredientAsProduct().booleanValue()) {
                for (Ingredient ingredient : ((Recipe)v).getRequirements()) {
                    if (ingredient.getItemId() != productId) continue;
                    return v;
                }
                continue;
            }
            if (((Recipe)v).getProductId() != productId) continue;
            return v;
        }
        return null;
    }

    public int getMakeProductCount(InventoryManager inventoryManager) {
        int amount = Integer.MAX_VALUE;
        for (Ingredient requirement : this.getRequirements()) {
            if (!requirement.isConsumed()) continue;
            amount = this.getTool() != null && inventoryManager.getItems().anyMatch(item -> item.getId() == this.tool.getItemId()) ? Math.min(amount, this.getMakeProductCountWithTool(inventoryManager.getItemCountById(requirement.getItemId()) / requirement.getAmount())) : Math.min(amount, inventoryManager.getItemCountById(requirement.getItemId()) / requirement.getAmount());
        }
        return amount;
    }

    private int getMakeProductCountWithTool(int amount) {
        int toolAmount = Integer.MAX_VALUE;
        switch (this.productId) {
            case 2: {
                toolAmount = (int)Math.ceil((double)amount / 2.0);
                break;
            }
            default: {
                toolAmount = amount;
            }
        }
        return toolAmount;
    }

    public int getProductId() {
        return this.productId;
    }

    public Ingredient[] getRequirements() {
        return this.requirements;
    }

    public Ingredient getTool() {
        return this.tool;
    }

    public Boolean getIsSelectingIngredientAsProduct() {
        return this.isSelectingIngredientAsProduct;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Recipe)) {
            return false;
        }
        Recipe other = (Recipe)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getProductId() != other.getProductId()) {
            return false;
        }
        Boolean this$isSelectingIngredientAsProduct = this.getIsSelectingIngredientAsProduct();
        Boolean other$isSelectingIngredientAsProduct = other.getIsSelectingIngredientAsProduct();
        if (this$isSelectingIngredientAsProduct == null ? other$isSelectingIngredientAsProduct != null : !((Object)this$isSelectingIngredientAsProduct).equals(other$isSelectingIngredientAsProduct)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getRequirements(), other.getRequirements())) {
            return false;
        }
        Ingredient this$tool = this.getTool();
        Ingredient other$tool = other.getTool();
        return !(this$tool == null ? other$tool != null : !this$tool.equals(other$tool));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Recipe;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getProductId();
        Boolean $isSelectingIngredientAsProduct = this.getIsSelectingIngredientAsProduct();
        result = result * 59 + ($isSelectingIngredientAsProduct == null ? 43 : ((Object)$isSelectingIngredientAsProduct).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getRequirements());
        Ingredient $tool = this.getTool();
        result = result * 59 + ($tool == null ? 43 : $tool.hashCode());
        return result;
    }

    public String toString() {
        return "Recipe(productId=" + this.getProductId() + ", requirements=" + Arrays.deepToString(this.getRequirements()) + ", tool=" + this.getTool() + ", isSelectingIngredientAsProduct=" + this.getIsSelectingIngredientAsProduct() + ")";
    }
}

