/*
 * Decompiled with CFR 0.152.
 */
package com.github.calebwhiting.runelite.data;

import com.github.calebwhiting.runelite.data.Crafting;
import com.github.calebwhiting.runelite.data.IDs;
import java.util.Arrays;
import net.runelite.api.Client;
import net.runelite.api.EnumComposition;
import net.runelite.api.InventoryID;
import net.runelite.api.ItemContainer;
import org.apache.commons.lang3.ArrayUtils;

public interface Magic {

    public static class RuneRequirement {
        private final Rune rune;
        private final int amount;

        public RuneRequirement(Rune rune, int amount) {
            this.rune = rune;
            this.amount = amount;
        }

        public Rune getRune() {
            return this.rune;
        }

        public int getAmount() {
            return this.amount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RuneRequirement)) {
                return false;
            }
            RuneRequirement other = (RuneRequirement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getAmount() != other.getAmount()) {
                return false;
            }
            Rune this$rune = this.getRune();
            Rune other$rune = other.getRune();
            return !(this$rune == null ? other$rune != null : !((Object)((Object)this$rune)).equals((Object)other$rune));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RuneRequirement;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAmount();
            Rune $rune = this.getRune();
            result = result * 59 + ($rune == null ? 43 : ((Object)((Object)$rune)).hashCode());
            return result;
        }

        public String toString() {
            return "Magic.RuneRequirement(rune=" + this.getRune() + ", amount=" + this.getAmount() + ")";
        }
    }

    public static interface Spell {
        public String getName();

        public int getGroupId();

        public int getChildId();

        public int getLevelRequirement();

        public RuneRequirement[] getRuneRequirements();

        default public int getWidgetId() {
            return this.getGroupId() << 16 | this.getChildId();
        }

        default public int getAvailableCasts(Client client) {
            int min = Integer.MAX_VALUE;
            for (RuneRequirement requirement : this.getRuneRequirements()) {
                int amount = requirement.getRune().countAvailable(client);
                min = Math.min(min, amount / requirement.getAmount());
            }
            return min;
        }
    }

    public static interface RuneIDs {
        public static final IDs SMOKE = new IDs(4697);
        public static final IDs DUST = new IDs(4696);
        public static final IDs LAVA = new IDs(4699);
        public static final IDs MIST = new IDs(4695);
        public static final IDs MUD = new IDs(4698);
        public static final IDs STEAM = new IDs(4694);
        public static final IDs AIR = new IDs(SMOKE, DUST, MIST, 556, 11715, 6422, 7558, 9693, 11688);
        public static final IDs WATER = new IDs(MIST, MUD, STEAM, 555, 11716, 6424, 7556, 9691, 11687);
        public static final IDs EARTH = new IDs(DUST, LAVA, MUD, 557, 11717, 6426, 9695, 11689);
        public static final IDs FIRE = new IDs(SMOKE, LAVA, STEAM, 554, 11718, 6428, 7554, 9699, 11686);
        public static final IDs MIND = new IDs(558, 6436, 9697, 11690);
        public static final IDs BODY = new IDs(559, 6438, 11691);
        public static final IDs COSMIC = new IDs(564, 11696);
        public static final IDs CHAOS = new IDs(562, 11712, 6430, 7560, 11694);
        public static final IDs ASTRAL = new IDs(9075, 11699);
        public static final IDs NATURE = new IDs(561, 11693);
        public static final IDs LAW = new IDs(563, 6434, 11695);
        public static final IDs DEATH = new IDs(560, 11713, 6432, 11692);
        public static final IDs BLOOD = new IDs(565, 11714, 11697);
        public static final IDs SOUL = new IDs(566, 11698);
        public static final IDs WRATH = new IDs(21880, 22208);
    }

    public static interface StaveIDs {
        public static final IDs SMOKE = new IDs(11998, 12000);
        public static final IDs DUST = new IDs(20736, 20739);
        public static final IDs MIST = new IDs(20730, 20733);
        public static final IDs MUD = new IDs(6562, 6563);
        public static final IDs LAVA = new IDs(3053, 21198, 3054, 21200);
        public static final IDs STEAM = new IDs(11787, 12795, 11789, 12796);
        public static final IDs AIR = new IDs(SMOKE, DUST, STEAM, 1381, 1397, 1405);
        public static final IDs WATER = new IDs(MUD, MIST, STEAM, 1383, 1395, 1403);
        public static final IDs EARTH = new IDs(DUST, MUD, LAVA, 1385, 1399, 1407);
        public static final IDs FIRE = new IDs(SMOKE, STEAM, LAVA, 1387, 1393, 1401);
    }

    public static enum ChargeOrbSpell {
        CHARGE_AIR_ORB(573, StandardSpell.CHARGE_AIR_ORB),
        CHARGE_EARTH_ORB(575, StandardSpell.CHARGE_EARTH_ORB),
        CHARGE_FIRE_ORB(569, StandardSpell.CHARGE_FIRE_ORB),
        CHARGE_WATER_ORB(571, StandardSpell.CHARGE_WATER_ORB);

        private final int product;
        private final Spell spell;

        public static ChargeOrbSpell byProduct(int productId) {
            return Arrays.stream(ChargeOrbSpell.values()).filter(x -> x.product == productId).findFirst().orElse(null);
        }

        public int getProduct() {
            return this.product;
        }

        public Spell getSpell() {
            return this.spell;
        }

        private ChargeOrbSpell(int product, Spell spell) {
            this.product = product;
            this.spell = spell;
        }
    }

    public static enum LecternSpell {
        ENCHANT_ONYX(8021, 5177355, StandardSpell.LVL_6_ENCHANT),
        LUMBRIDGE_TELEPORT(8008, 5177356, StandardSpell.LUMBRIDGE_TELEPORT),
        ENCHANT_DIAMOND(8019, 5177357, StandardSpell.LVL_4_ENCHANT),
        WATCHTOWER_TELEPORT(8012, 5177358, StandardSpell.WATCHTOWER_TELEPORT),
        HOUSE_TELEPORT(8013, 0x4F000F, StandardSpell.TELEPORT_TO_HOUSE),
        ENCHANT_EMERALD(8017, 5177360, StandardSpell.LVL_2_ENCHANT),
        ENCHANT_SAPPHIRE(8016, 5177361, StandardSpell.LVL_1_ENCHANT),
        FALADOR_TELEPORT(8009, 5177362, StandardSpell.FALADOR_TELEPORT),
        ARDOUGNE_TELEPORT(8011, 5177363, StandardSpell.ARDOUGNE_TELEPORT),
        BONES_TO_BANANAS(8014, 5177364, StandardSpell.BONES_TO_BANANAS),
        ENCHANT_DRAGONSTONE(8020, 5177365, StandardSpell.LVL_5_ENCHANT),
        ENCHANT_RUBY(8018, 5177366, StandardSpell.LVL_3_ENCHANT),
        VARROCK_TELEPORT(8007, 5177367, StandardSpell.VARROCK_TELEPORT),
        CAMELOT_TELEPORT(8010, 5177368, StandardSpell.CAMELOT_TELEPORT),
        BONES_TO_PEACHES(6926, 5177369, StandardSpell.BONES_TO_PEACHES);

        private final int product;
        private final int widgetId;
        private final Spell spell;

        public int getProduct() {
            return this.product;
        }

        public int getWidgetId() {
            return this.widgetId;
        }

        public Spell getSpell() {
            return this.spell;
        }

        private LecternSpell(int product, int widgetId, Spell spell) {
            this.product = product;
            this.widgetId = widgetId;
            this.spell = spell;
        }
    }

    public static enum Rune {
        AIR("Air", RuneIDs.AIR.build(), StaveIDs.AIR.build()),
        WATER("Water", RuneIDs.WATER.build(), new IDs(StaveIDs.WATER, 25574).build()),
        EARTH("Earth", RuneIDs.EARTH.build(), StaveIDs.EARTH.build()),
        FIRE("Fire", RuneIDs.FIRE.build(), new IDs(StaveIDs.FIRE, 20714).build()),
        MIND("Mind", RuneIDs.MIND.build()),
        BODY("Body", RuneIDs.BODY.build()),
        COSMIC("Cosmic", RuneIDs.COSMIC.build()),
        CHAOS("Chaos", RuneIDs.CHAOS.build()),
        ASTRAL("Astral", RuneIDs.ASTRAL.build()),
        NATURE("Nature", RuneIDs.NATURE.build()),
        LAW("Law", RuneIDs.LAW.build()),
        DEATH("Death", RuneIDs.DEATH.build()),
        BLOOD("Blood", RuneIDs.BLOOD.build()),
        SOUL("Soul", RuneIDs.SOUL.build()),
        WRATH("Wrath", RuneIDs.WRATH.build());

        private final String name;
        private final int[] runeIds;
        private final int[] unlimitedSources;
        private static final int RUNE_POUCH_NUM_SLOTS = 4;
        private static final int[] AMOUNT_VARBITS;
        private static final int[] RUNE_VARBITS;

        private Rune(String name, int ... runeId) {
            this(name, runeId, ArrayUtils.EMPTY_INT_ARRAY);
        }

        public int countAvailable(Client client) {
            for (int itemId : this.unlimitedSources) {
                ItemContainer equipment = client.getItemContainer(InventoryID.EQUIPMENT);
                if (equipment == null || !equipment.contains(itemId)) continue;
                return Integer.MAX_VALUE;
            }
            EnumComposition runepouchEnum = client.getEnum(982);
            int count = 0;
            for (int itemId : this.runeIds) {
                for (int i = 0; i < 4; ++i) {
                    int runeVarbit = RUNE_VARBITS[i];
                    int runepouchRuneId = client.getVarbitValue(runeVarbit);
                    int runeId = runepouchEnum.getIntValue(runepouchRuneId);
                    if (runeId != itemId) continue;
                    int amountVarbit = AMOUNT_VARBITS[i];
                    int amount = client.getVarbitValue(amountVarbit);
                    count += amount;
                }
                ItemContainer inventory = client.getItemContainer(InventoryID.INVENTORY);
                count += inventory == null ? 0 : inventory.count(itemId);
            }
            return count;
        }

        private Rune(String name, int[] runeIds, int[] unlimitedSources) {
            this.name = name;
            this.runeIds = runeIds;
            this.unlimitedSources = unlimitedSources;
        }

        public String getName() {
            return this.name;
        }

        public int[] getRuneIds() {
            return this.runeIds;
        }

        public int[] getUnlimitedSources() {
            return this.unlimitedSources;
        }

        static {
            AMOUNT_VARBITS = new int[]{1624, 1625, 1626, 14286};
            RUNE_VARBITS = new int[]{29, 1622, 1623, 14285};
        }
    }

    public static enum EnchantSpell {
        ENCHANT_SAPPHIRE(StandardSpell.LVL_1_ENCHANT, Crafting.SAPPHIRE_AND_OPAL_JEWELLERY),
        ENCHANT_EMERALD(StandardSpell.LVL_2_ENCHANT, Crafting.EMERALD_JEWELLERY),
        ENCHANT_RUBY(StandardSpell.LVL_3_ENCHANT, Crafting.TOPAZ_AND_RUBY_JEWELLERY),
        ENCHANT_DIAMOND(StandardSpell.LVL_4_ENCHANT, Crafting.DIAMOND_JEWELLERY),
        ENCHANT_DRAGONSTONE(StandardSpell.LVL_5_ENCHANT, Crafting.DRAGONSTONE_JEWELLERY),
        ENCHANT_ONYX(StandardSpell.LVL_6_ENCHANT, Crafting.ONYX_JEWELLERY),
        ENCHANT_ZENYTE(StandardSpell.LVL_7_ENCHANT, Crafting.ZENYTE_JEWELLERY);

        private final Spell spell;
        private final int[] jewellery;

        private EnchantSpell(Spell spell, int[] jewellery) {
            this.spell = spell;
            this.jewellery = jewellery;
            Arrays.sort(jewellery);
        }

        public Spell getSpell() {
            return this.spell;
        }

        public int[] getJewellery() {
            return this.jewellery;
        }
    }

    public static enum PlankMakeSpell {
        PLANK_MAKE(LunarSpell.PLANK_MAKE, 1511, 70),
        PLANK_MAKE_OAK(LunarSpell.PLANK_MAKE, 1521, 175),
        PLANK_MAKE_TEAK(LunarSpell.PLANK_MAKE, 6333, 350),
        PLANK_MAKE_MAHOGANY(LunarSpell.PLANK_MAKE, 6332, 1050);

        private final Spell spell;
        private final int plank;
        private final int cost;

        private PlankMakeSpell(Spell spell, int plank, int cost) {
            this.spell = spell;
            this.plank = plank;
            this.cost = cost;
        }

        public Spell getSpell() {
            return this.spell;
        }

        public int getPlank() {
            return this.plank;
        }

        public int getCost() {
            return this.cost;
        }
    }

    public static enum LunarSpell implements Spell
    {
        PLANK_MAKE("Plank Make", 33, 86, new RuneRequirement(Rune.EARTH, 15), new RuneRequirement(Rune.ASTRAL, 2), new RuneRequirement(Rune.NATURE, 1));

        private static final int LUNAR_SPELLBOOK_GROUP_ID = 218;
        private static final int LUNAR_SPELLBOOK_FIRST_SPELL_INDEX = 101;
        private final String name;
        private final int index;
        private final int levelRequirement;
        private final RuneRequirement[] runeRequirements;

        private LunarSpell(String name, int index, int levelRequirement, RuneRequirement ... runeRequirements) {
            this.name = name;
            this.index = index;
            this.levelRequirement = levelRequirement;
            this.runeRequirements = runeRequirements;
        }

        @Override
        public int getGroupId() {
            return 218;
        }

        @Override
        public int getChildId() {
            return 101 + this.getIndex();
        }

        @Override
        public String getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public int getLevelRequirement() {
            return this.levelRequirement;
        }

        @Override
        public RuneRequirement[] getRuneRequirements() {
            return this.runeRequirements;
        }
    }

    public static enum StandardSpell implements Spell
    {
        LUMBRIDGE_HOME_TELEPORT("Lumbridge Home Teleport", 0, 0, new RuneRequirement[0]),
        WIND_STRIKE("Wind Strike", 1, 1, new RuneRequirement(Rune.AIR, 1), new RuneRequirement(Rune.MIND, 1)),
        CONFUSE("Confuse", 2, 3, new RuneRequirement(Rune.BODY, 1), new RuneRequirement(Rune.EARTH, 2), new RuneRequirement(Rune.WATER, 3)),
        ENCHANT_CROSSBOW_BOLT("Enchant Crossbow Bolt", 3, 4, new RuneRequirement[0]),
        WATER_STRIKE("Water Strike", 4, 5, new RuneRequirement(Rune.AIR, 1), new RuneRequirement(Rune.MIND, 1), new RuneRequirement(Rune.WATER, 1)),
        LVL_1_ENCHANT("Lvl-1 Enchant", 5, 7, new RuneRequirement(Rune.COSMIC, 1), new RuneRequirement(Rune.WATER, 1)),
        EARTH_STRIKE("Earth Strike", 6, 9, new RuneRequirement(Rune.AIR, 1), new RuneRequirement(Rune.EARTH, 2), new RuneRequirement(Rune.MIND, 1)),
        WEAKEN("Weaken", 7, 11, new RuneRequirement(Rune.BODY, 1), new RuneRequirement(Rune.EARTH, 2), new RuneRequirement(Rune.WATER, 3)),
        FIRE_STRIKE("Fire Strike", 8, 13, new RuneRequirement(Rune.AIR, 2), new RuneRequirement(Rune.FIRE, 3), new RuneRequirement(Rune.MIND, 1)),
        BONES_TO_BANANAS("Bones to Bananas", 9, 15, new RuneRequirement(Rune.EARTH, 2), new RuneRequirement(Rune.NATURE, 1), new RuneRequirement(Rune.WATER, 2)),
        WIND_BOLT("Wind Bolt", 10, 17, new RuneRequirement(Rune.AIR, 2), new RuneRequirement(Rune.CHAOS, 1)),
        CURSE("Curse", 11, 19, new RuneRequirement(Rune.BODY, 1), new RuneRequirement(Rune.EARTH, 3), new RuneRequirement(Rune.WATER, 2)),
        BIND("Bind", 12, 20, new RuneRequirement(Rune.EARTH, 3), new RuneRequirement(Rune.NATURE, 2), new RuneRequirement(Rune.WATER, 3)),
        LOW_LEVEL_ALCHEMY("Low Level Alchemy", 13, 21, new RuneRequirement(Rune.FIRE, 3), new RuneRequirement(Rune.NATURE, 1)),
        WATER_BOLT("Water Bolt", 14, 23, new RuneRequirement(Rune.AIR, 2), new RuneRequirement(Rune.CHAOS, 1), new RuneRequirement(Rune.WATER, 2)),
        VARROCK_TELEPORT("Varrock Teleport", 15, 25, new RuneRequirement(Rune.AIR, 3), new RuneRequirement(Rune.FIRE, 1), new RuneRequirement(Rune.LAW, 1)),
        LVL_2_ENCHANT("Lvl-2 Enchant", 16, 27, new RuneRequirement(Rune.AIR, 3), new RuneRequirement(Rune.COSMIC, 1)),
        EARTH_BOLT("Earth Bolt", 17, 29, new RuneRequirement(Rune.AIR, 3), new RuneRequirement(Rune.CHAOS, 1), new RuneRequirement(Rune.EARTH, 1)),
        LUMBRIDGE_TELEPORT("Lumbridge Teleport", 18, 31, new RuneRequirement(Rune.AIR, 3), new RuneRequirement(Rune.EARTH, 1), new RuneRequirement(Rune.LAW, 1)),
        TELEKINETIC_GRAB("Telekinetic Grab", 19, 33, new RuneRequirement(Rune.AIR, 1), new RuneRequirement(Rune.LAW, 1)),
        FIRE_BOLT("Fire Bolt", 20, 35, new RuneRequirement(Rune.AIR, 3), new RuneRequirement(Rune.CHAOS, 1), new RuneRequirement(Rune.FIRE, 4)),
        FALADOR_TELEPORT("Falador Teleport", 21, 37, new RuneRequirement(Rune.AIR, 3), new RuneRequirement(Rune.LAW, 1), new RuneRequirement(Rune.WATER, 1)),
        CRUMBLE_UNDEAD("Crumble Undead", 22, 39, new RuneRequirement(Rune.AIR, 2), new RuneRequirement(Rune.CHAOS, 1), new RuneRequirement(Rune.EARTH, 2)),
        TELEPORT_TO_HOUSE("Teleport to House", 23, 40, new RuneRequirement(Rune.AIR, 1), new RuneRequirement(Rune.EARTH, 1), new RuneRequirement(Rune.LAW, 1)),
        WIND_BLAST("Wind Blast", 24, 41, new RuneRequirement(Rune.AIR, 3), new RuneRequirement(Rune.DEATH, 1)),
        SUPERHEAT_ITEM("Superheat Item", 25, 43, new RuneRequirement(Rune.FIRE, 4), new RuneRequirement(Rune.NATURE, 1)),
        CAMELOT_TELEPORT("Camelot Teleport", 26, 45, new RuneRequirement(Rune.AIR, 5), new RuneRequirement(Rune.LAW, 1)),
        WATER_BLAST("Water Blast", 27, 47, new RuneRequirement(Rune.AIR, 3), new RuneRequirement(Rune.DEATH, 1), new RuneRequirement(Rune.WATER, 3)),
        LVL_3_ENCHANT("Lvl-3 Enchant", 28, 49, new RuneRequirement(Rune.COSMIC, 1), new RuneRequirement(Rune.FIRE, 5)),
        IBAN_BLAST("Iban Blast", 29, 50, new RuneRequirement(Rune.DEATH, 1), new RuneRequirement(Rune.FIRE, 5)),
        SNARE("Snare", 30, 50, new RuneRequirement(Rune.EARTH, 4), new RuneRequirement(Rune.NATURE, 3), new RuneRequirement(Rune.WATER, 4)),
        MAGIC_DART("Magic Dart", 31, 50, new RuneRequirement(Rune.DEATH, 1), new RuneRequirement(Rune.MIND, 4)),
        ARDOUGNE_TELEPORT("Ardougne Teleport", 32, 51, new RuneRequirement(Rune.LAW, 2), new RuneRequirement(Rune.WATER, 2)),
        EARTH_BLAST("Earth Blast", 33, 53, new RuneRequirement(Rune.AIR, 3), new RuneRequirement(Rune.DEATH, 1), new RuneRequirement(Rune.EARTH, 4)),
        HIGH_LEVEL_ALCHEMY("High Level Alchemy", 34, 55, new RuneRequirement(Rune.FIRE, 5), new RuneRequirement(Rune.NATURE, 1)),
        CHARGE_WATER_ORB("Charge Water Orb", 35, 56, new RuneRequirement(Rune.COSMIC, 3), new RuneRequirement(Rune.WATER, 30)),
        LVL_4_ENCHANT("Lvl-4 Enchant", 36, 57, new RuneRequirement(Rune.COSMIC, 1), new RuneRequirement(Rune.EARTH, 10)),
        WATCHTOWER_TELEPORT("Watchtower Teleport", 37, 58, new RuneRequirement(Rune.EARTH, 2), new RuneRequirement(Rune.LAW, 2)),
        FIRE_BLAST("Fire Blast", 38, 59, new RuneRequirement(Rune.AIR, 4), new RuneRequirement(Rune.DEATH, 1), new RuneRequirement(Rune.FIRE, 5)),
        CHARGE_EARTH_ORB("Charge Earth Orb", 39, 60, new RuneRequirement(Rune.COSMIC, 3), new RuneRequirement(Rune.EARTH, 30)),
        BONES_TO_PEACHES("Bones to Peaches", 40, 60, new RuneRequirement(Rune.EARTH, 2), new RuneRequirement(Rune.NATURE, 2), new RuneRequirement(Rune.WATER, 4)),
        SARADOMIN_STRIKE("Saradomin Strike", 41, 60, new RuneRequirement(Rune.AIR, 4), new RuneRequirement(Rune.BLOOD, 2), new RuneRequirement(Rune.FIRE, 2)),
        CLAWS_OF_GUTHIX("Claws of Guthix", 42, 60, new RuneRequirement(Rune.AIR, 4), new RuneRequirement(Rune.BLOOD, 2), new RuneRequirement(Rune.FIRE, 1)),
        FLAMES_OF_ZAMORAK("Flames of Zamorak", 43, 60, new RuneRequirement(Rune.AIR, 1), new RuneRequirement(Rune.BLOOD, 2), new RuneRequirement(Rune.FIRE, 4)),
        TROLLHEIM_TELEPORT("Trollheim Teleport", 44, 61, new RuneRequirement(Rune.FIRE, 2), new RuneRequirement(Rune.LAW, 2)),
        WIND_WAVE("Wind Wave", 45, 62, new RuneRequirement(Rune.AIR, 5), new RuneRequirement(Rune.BLOOD, 1)),
        CHARGE_FIRE_ORB("Charge Fire Orb", 46, 63, new RuneRequirement(Rune.COSMIC, 3), new RuneRequirement(Rune.FIRE, 30)),
        APE_ATOLL_TELEPORT("Ape Atoll Teleport", 47, 64, new RuneRequirement(Rune.FIRE, 2), new RuneRequirement(Rune.LAW, 2), new RuneRequirement(Rune.WATER, 2)),
        WATER_WAVE("Water Wave", 48, 65, new RuneRequirement(Rune.AIR, 5), new RuneRequirement(Rune.BLOOD, 1), new RuneRequirement(Rune.WATER, 7)),
        CHARGE_AIR_ORB("Charge Air Orb", 49, 66, new RuneRequirement(Rune.AIR, 30), new RuneRequirement(Rune.COSMIC, 3)),
        VULNERABILITY("Vulnerability", 50, 66, new RuneRequirement(Rune.EARTH, 5), new RuneRequirement(Rune.SOUL, 1), new RuneRequirement(Rune.WATER, 5)),
        LVL_5_ENCHANT("Lvl-5 Enchant", 51, 68, new RuneRequirement(Rune.COSMIC, 1), new RuneRequirement(Rune.EARTH, 15), new RuneRequirement(Rune.WATER, 15)),
        KOUREND_CASTLE_TELEPORT("Kourend Castle Teleport", 52, 69, new RuneRequirement(Rune.FIRE, 5), new RuneRequirement(Rune.LAW, 2), new RuneRequirement(Rune.SOUL, 2), new RuneRequirement(Rune.WATER, 4)),
        EARTH_WAVE("Earth Wave", 53, 70, new RuneRequirement(Rune.AIR, 5), new RuneRequirement(Rune.BLOOD, 1), new RuneRequirement(Rune.EARTH, 7)),
        ENFEEBLE("Enfeeble", 54, 73, new RuneRequirement(Rune.EARTH, 8), new RuneRequirement(Rune.SOUL, 1), new RuneRequirement(Rune.WATER, 8)),
        TELEOTHER_LUMBRIDGE("Teleother Lumbridge", 55, 74, new RuneRequirement(Rune.EARTH, 1), new RuneRequirement(Rune.LAW, 1), new RuneRequirement(Rune.SOUL, 1)),
        FIRE_WAVE("Fire Wave", 56, 75, new RuneRequirement(Rune.AIR, 5), new RuneRequirement(Rune.BLOOD, 1), new RuneRequirement(Rune.FIRE, 7)),
        ENTANGLE("Entangle", 57, 79, new RuneRequirement(Rune.EARTH, 5), new RuneRequirement(Rune.NATURE, 4), new RuneRequirement(Rune.WATER, 5)),
        STUN("Stun", 58, 80, new RuneRequirement(Rune.EARTH, 12), new RuneRequirement(Rune.SOUL, 1), new RuneRequirement(Rune.WATER, 12)),
        CHARGE("Charge", 59, 80, new RuneRequirement(Rune.AIR, 3), new RuneRequirement(Rune.BLOOD, 3), new RuneRequirement(Rune.FIRE, 3)),
        WIND_SURGE("Wind Surge", 60, 81, new RuneRequirement(Rune.AIR, 7), new RuneRequirement(Rune.WRATH, 1)),
        TELEOTHER_FALADOR("Teleother Falador", 61, 82, new RuneRequirement(Rune.LAW, 1), new RuneRequirement(Rune.SOUL, 1), new RuneRequirement(Rune.WATER, 1)),
        WATER_SURGE("Water Surge", 62, 85, new RuneRequirement(Rune.AIR, 7), new RuneRequirement(Rune.WATER, 10), new RuneRequirement(Rune.WRATH, 1)),
        TELE_BLOCK("Tele Block", 63, 85, new RuneRequirement(Rune.CHAOS, 1), new RuneRequirement(Rune.DEATH, 1), new RuneRequirement(Rune.LAW, 1)),
        TELEPORT_TO_BOUNTY_TARGET("Teleport to Bounty Target", 64, 85, new RuneRequirement(Rune.CHAOS, 1), new RuneRequirement(Rune.DEATH, 1), new RuneRequirement(Rune.LAW, 1)),
        LVL_6_ENCHANT("Lvl-6 Enchant", 65, 87, new RuneRequirement(Rune.COSMIC, 1), new RuneRequirement(Rune.EARTH, 20), new RuneRequirement(Rune.FIRE, 20)),
        TELEOTHER_CAMELOT("Teleother Camelot", 66, 90, new RuneRequirement(Rune.LAW, 1), new RuneRequirement(Rune.SOUL, 2)),
        EARTH_SURGE("Earth Surge", 67, 90, new RuneRequirement(Rune.AIR, 7), new RuneRequirement(Rune.EARTH, 10), new RuneRequirement(Rune.WRATH, 1)),
        LVL_7_ENCHANT("Lvl-7 Enchant", 68, 93, new RuneRequirement(Rune.BLOOD, 20), new RuneRequirement(Rune.COSMIC, 1), new RuneRequirement(Rune.SOUL, 20)),
        FIRE_SURGE("Fire Surge", 69, 95, new RuneRequirement(Rune.AIR, 7), new RuneRequirement(Rune.FIRE, 10), new RuneRequirement(Rune.WRATH, 1));

        private static final int STANDARD_SPELLBOOK_GROUP_ID = 218;
        private static final int STANDARD_SPELLBOOK_FIRST_SPELL_INDEX = 6;
        private final String name;
        private final int index;
        private final int levelRequirement;
        private final RuneRequirement[] runeRequirements;

        private StandardSpell(String name, int index, int levelRequirement, RuneRequirement ... runeRequirements) {
            this.name = name;
            this.index = index;
            this.levelRequirement = levelRequirement;
            this.runeRequirements = runeRequirements;
        }

        @Override
        public int getGroupId() {
            return 218;
        }

        @Override
        public int getChildId() {
            return 6 + this.getIndex();
        }

        @Override
        public String getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public int getLevelRequirement() {
            return this.levelRequirement;
        }

        @Override
        public RuneRequirement[] getRuneRequirements() {
            return this.runeRequirements;
        }
    }
}

