/*
 * Decompiled with CFR 0.152.
 */
package com.github.calebwhiting.runelite.data;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class IDs {
    private final Set<Integer> ids;

    public IDs(Set<Integer> ids) {
        this.ids = Collections.unmodifiableSet(ids);
    }

    public IDs(Object ... of) {
        this(Stream.of(of).map(IDs::objectToInts).flatMapToInt(IntStream::of).boxed().collect(Collectors.toSet()));
    }

    private static int[] objectToInts(Object o) {
        if (o instanceof int[]) {
            return (int[])o;
        }
        if (o instanceof Integer) {
            return new int[]{(Integer)o};
        }
        if (o instanceof IDs) {
            return ((IDs)o).build();
        }
        throw new IllegalArgumentException(String.format("Unsupported type: %s", o.getClass()));
    }

    public boolean contains(int id) {
        return this.ids.contains(id);
    }

    public int[] build() {
        return this.ids.stream().mapToInt(Integer::intValue).toArray();
    }

    public String toString() {
        return "IDs{" + this.ids + "}";
    }
}

