/*
 * Decompiled with CFR 0.152.
 */
package com.github.calebwhiting.runelite.api.ui;

import com.github.calebwhiting.runelite.api.ui.Alignment;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import net.runelite.client.ui.overlay.RenderableEntity;

public final class Rendering {
    private static final float INFOBOX_COLOR_OFFSET = 0.2f;
    private static final float INFOBOX_OUTER_COLOR_OFFSET = 0.8f;
    private static final float INFOBOX_INNER_COLOR_OFFSET = 1.2f;
    private static final float INFOBOX_ALPHA_COLOR_OFFSET = 1.4f;
    private static final int MAX_BYTE = 255;

    public static Color outsideStrokeColor(Color backgroundColor) {
        return new Color(Math.round((float)backgroundColor.getRed() * 0.8f), Math.round((float)backgroundColor.getGreen() * 0.8f), Math.round((float)backgroundColor.getBlue() * 0.8f), Math.min(255, Math.round((float)backgroundColor.getAlpha() * 1.4f)));
    }

    public static Color insideStrokeColor(Color backgroundColor) {
        return new Color(Math.min(255, Math.round((float)backgroundColor.getRed() * 1.2f)), Math.min(255, Math.round((float)backgroundColor.getGreen() * 1.2f)), Math.min(255, Math.round((float)backgroundColor.getBlue() * 1.2f)), Math.min(255, Math.round((float)backgroundColor.getAlpha() * 1.4f)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderEntityRelative(Graphics2D gfx, RenderableEntity entity, int x, int y) {
        Graphics2D g = (Graphics2D)gfx.create();
        try {
            g.translate(x, y);
            entity.render(g);
        }
        finally {
            g.dispose();
        }
    }

    private static int getCenteredTextY(FontMetrics fm, int boundaryHeight) {
        return (boundaryHeight - fm.getHeight()) / 2 + fm.getAscent();
    }

    public static void drawText(Graphics2D g, Rectangle bounds, Color color, Alignment alignment, String text, boolean isVertical) {
        Font currentFont = g.getFont();
        Font newFont = currentFont.deriveFont(currentFont.getStyle(), isVertical ? 13.0f : 16.0f);
        g.setFont(newFont);
        FontMetrics fm = g.getFontMetrics();
        double x = bounds.x;
        switch (alignment.getAlignmentX()) {
            case 0: {
                x = bounds.x;
                break;
            }
            case 1: {
                x = isVertical ? bounds.getCenterX() + (double)bounds.x - (double)(fm.getHeight() / 2) : bounds.getCenterX() - (double)fm.stringWidth(text) / 2.0;
                break;
            }
            case 2: {
                x = isVertical ? bounds.getMaxX() + (double)bounds.x - (double)fm.getHeight() : bounds.getMaxX() - (double)fm.stringWidth(text);
            }
        }
        double y = bounds.y;
        switch (alignment.getAlignmentY()) {
            case 0: {
                y = isVertical ? (double)(bounds.y + fm.getHeight()) : (double)bounds.y;
                break;
            }
            case 1: {
                y = isVertical ? bounds.getCenterY() - (double)(text.length() * 10 / 2) + (double)fm.getHeight() : (double)(bounds.y + Rendering.getCenteredTextY(fm, bounds.height));
                break;
            }
            case 2: {
                y = isVertical ? bounds.getMaxY() - (double)((text.length() - 1) * 10) : bounds.getMaxY() - (double)fm.getHeight();
            }
        }
        float fX = Math.round(x);
        float fY = Math.round(y);
        if (isVertical) {
            char[] textChar = text.toCharArray();
            for (int i = 0; i < textChar.length; ++i) {
                g.setColor(Color.BLACK);
                g.drawChars(textChar, i, 1, (int)fX + 1, (int)fY + 1 + i * 10);
                g.setColor(color);
                g.drawChars(textChar, i, 1, (int)fX, (int)fY + i * 10);
            }
        } else {
            g.setColor(Color.BLACK);
            g.drawString(text, fX + 1.0f, fY + 1.0f);
            g.setColor(color);
            g.drawString(text, fX, fY);
        }
    }

    public static void drawProgressBar(Graphics2D g, Rectangle bounds, Color borderColor, Color progressLeftColor, Color progressDoneColor, long min, long max, long value, boolean isVertical) {
        double progress = ((double)value - (double)min) / ((double)max - (double)min);
        progress = Math.min(1.0, progress);
        Rectangle progressDone = new Rectangle(bounds);
        Rectangle progressLeft = new Rectangle(bounds);
        if (isVertical) {
            progressDone.height = (int)Math.round(progress * (double)progressDone.height);
            progressLeft.y += progressDone.height;
            progressLeft.height -= progressDone.height;
        } else {
            progressDone.width = (int)Math.round(progress * (double)progressDone.width);
            progressLeft.x += progressDone.width;
            progressLeft.width -= progressDone.width;
        }
        g.setColor(progressLeftColor);
        g.fill(progressLeft);
        g.setColor(progressDoneColor);
        g.fill(progressDone);
        g.setColor(borderColor);
        g.draw(bounds);
    }

    private Rendering() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

