/*
 * Decompiled with CFR 0.152.
 */
package com.github.calebwhiting.runelite.api.event;

import lombok.NonNull;
import net.runelite.api.Actor;
import net.runelite.api.Player;

public class LocalInteractingChanged {
    @NonNull
    private final Player localPlayer;
    private final Actor target;

    public LocalInteractingChanged(@NonNull Player localPlayer, Actor target) {
        if (localPlayer == null) {
            throw new NullPointerException("localPlayer is marked non-null but is null");
        }
        this.localPlayer = localPlayer;
        this.target = target;
    }

    @NonNull
    public Player getLocalPlayer() {
        return this.localPlayer;
    }

    public Actor getTarget() {
        return this.target;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalInteractingChanged)) {
            return false;
        }
        LocalInteractingChanged other = (LocalInteractingChanged)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Player this$localPlayer = this.getLocalPlayer();
        Player other$localPlayer = other.getLocalPlayer();
        if (this$localPlayer == null ? other$localPlayer != null : !this$localPlayer.equals(other$localPlayer)) {
            return false;
        }
        Actor this$target = this.getTarget();
        Actor other$target = other.getTarget();
        return !(this$target == null ? other$target != null : !this$target.equals(other$target));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LocalInteractingChanged;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Player $localPlayer = this.getLocalPlayer();
        result = result * 59 + ($localPlayer == null ? 43 : $localPlayer.hashCode());
        Actor $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        return result;
    }

    public String toString() {
        return "LocalInteractingChanged(localPlayer=" + this.getLocalPlayer() + ", target=" + this.getTarget() + ")";
    }
}

