/*
 * Decompiled with CFR 0.152.
 */
package com.github.calebwhiting.runelite.api;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.eventbus.Subscribe;

@Singleton
public class TickManager {
    public static final long PERFECT_TICK_TIME = 600L;
    private static final int DEFAULT_BUFFER_SIZE = 1000;
    private final int bufferSize;
    private final Queue<Long> tickTimes;
    @Inject
    private Client client;
    private int lastTick;
    private long averageTickTime;
    private long lastTickTime;
    private boolean paused = true;
    private long tickTimesTotal;

    private TickManager(int bufferSize) {
        if (bufferSize <= 1) {
            throw new IllegalArgumentException("bufferSize must be more than 1");
        }
        this.bufferSize = bufferSize;
        this.averageTickTime = 600L;
        this.tickTimes = new LinkedList<Long>();
        for (int i = 0; i < bufferSize; ++i) {
            this.tickTimes.add(600L);
        }
        this.tickTimesTotal = (long)this.tickTimes.size() * 600L;
        this.lastTickTime = -1L;
    }

    @Inject
    public TickManager() {
        this(1000);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged evt) {
        boolean bl = this.paused = evt.getGameState() != GameState.LOGGED_IN;
        if (this.paused || this.lastTickTime != -1L) {
            return;
        }
        this.lastTickTime = System.currentTimeMillis();
    }

    @Subscribe
    public void onGameTick(GameTick evt) {
        long now = System.currentTimeMillis();
        if (!this.paused) {
            long tickTime = now - this.lastTickTime;
            if (this.tickTimes.size() != this.bufferSize) {
                throw new IllegalStateException("Somehow the tick time queue has become corrupted!");
            }
            long toRemove = Objects.requireNonNull(this.tickTimes.poll());
            this.tickTimesTotal = this.tickTimesTotal - toRemove + tickTime;
            this.averageTickTime = this.tickTimesTotal / (long)this.bufferSize;
            this.tickTimes.offer(tickTime);
            this.lastTick = this.client.getTickCount();
        }
        this.lastTickTime = now;
    }

    public int getLastTick() {
        return this.lastTick;
    }

    public long getAverageTickTime() {
        return this.averageTickTime;
    }

    public long getLastTickTime() {
        return this.lastTickTime;
    }

    public boolean isPaused() {
        return this.paused;
    }
}

