/*
 * Decompiled with CFR 0.152.
 */
package com.github.calebwhiting.runelite.api;

import com.github.calebwhiting.runelite.api.event.DestinationChanged;
import com.github.calebwhiting.runelite.api.event.LocalAnimationChanged;
import com.github.calebwhiting.runelite.api.event.LocalInteractingChanged;
import com.github.calebwhiting.runelite.api.event.LocalPositionChanged;
import com.github.calebwhiting.runelite.api.event.LocalRegionChanged;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.InteractingChanged;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;

@Singleton
public class LocalPlayerManager {
    @Inject
    private Client client;
    @Inject
    private EventBus eventBus;
    private LocalPoint pDest;
    private LocalPoint pPos;
    private int pRegionId = -1;

    @Subscribe
    public void onClientTick(ClientTick evt) {
        int regionId;
        Player me;
        LocalPoint pos;
        LocalPoint dest = this.client.getLocalDestinationLocation();
        if (this.isDifferent(dest, this.pDest)) {
            this.eventBus.post((Object)new DestinationChanged(this.pDest, dest));
            this.pDest = dest;
        }
        LocalPoint localPoint = pos = (me = this.client.getLocalPlayer()) == null ? null : me.getLocalLocation();
        if (this.isDifferent(pos, this.pPos)) {
            this.eventBus.post((Object)new LocalPositionChanged(this.pPos, pos));
            this.pPos = pos;
        }
        int n = regionId = pos == null ? -1 : WorldPoint.fromLocal((Client)this.client, (LocalPoint)pos).getRegionID();
        if (regionId != this.pRegionId) {
            this.eventBus.post((Object)new LocalRegionChanged(this.pRegionId, this.pRegionId));
            this.pRegionId = regionId;
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged evt) {
        Player me = this.client.getLocalPlayer();
        if (me != null && evt.getActor() == me) {
            this.eventBus.post((Object)new LocalAnimationChanged(me));
        }
    }

    @Subscribe
    public void onInteractingChanged(InteractingChanged evt) {
        Player me = this.client.getLocalPlayer();
        if (me != null && evt.getSource() == me) {
            this.eventBus.post((Object)new LocalInteractingChanged(me, evt.getTarget()));
        }
    }

    private boolean isDifferent(LocalPoint first, LocalPoint second) {
        if (first == second) {
            return false;
        }
        return first == null || second == null || first.distanceTo(second) > 0;
    }
}

