/*
 * Decompiled with CFR 0.152.
 */
package com.github.calebwhiting.runelite.api;

import com.github.calebwhiting.runelite.api.event.DestinationChanged;
import com.github.calebwhiting.runelite.api.event.Interrupt;
import com.github.calebwhiting.runelite.api.event.LocalInteractingChanged;
import com.github.calebwhiting.runelite.plugins.actionprogress.ActionProgressConfig;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.ResizeableChanged;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class InterruptManager {
    private static final Logger log = LoggerFactory.getLogger(InterruptManager.class);
    @Inject
    private ActionProgressConfig config;
    private static final int[] WIDGET_CLICK_INTERRUPTS = new int[]{InterruptManager.PACK(116, 72), InterruptManager.PACK(116, 73), InterruptManager.PACK(116, 74), InterruptManager.PACK(116, 75), 7602203, 7602204, 7602206, 25362433, 25362435, 25362437, 25362439, 38862852, 38862856, 38862860, 38862864, 38862878, 25362447, 25362448, 25362449, 25362457, 25362450, 25362451, 25362452, 25362453, 25362455, 25362454, 25362456, 35454981, 35454982, 35454983, 35454984, 35454985, 35454986, 35454987, 35454988, 35454989, 35454990, 35454991, 35454992, 35454993, 35454994, 35454995, 35454996, 35454997, 35454998, 35454999, 35455000, 35455001, 35455002, 35455003, 35455004, 35455005, 35455006, 35455007, 35455008};
    private static final int KOUREND_FAVOUR_OVERVIEW_GROUP_ID = 626;
    private static final int CHATBOX_MAKE_GROUP_ID = 270;
    private static final int SKILL_GUIDE_GROUP_ID = 214;
    private static final int COMBAT_ACHIEVEMENTS_GROUP_ID = 717;
    private static final int VAR_PLAYER_RUNNING = 173;
    private static final int[] WIDGET_GROUPS_INTERRUPT = new int[]{621, 233, 12, 213, 192, 259, 187, 15, 231, 217, 219, 193, 584, 421, 481, 483, 398, 367, 155, 465, 549, 464, 4, 190, 300, 631, 426, 312, 119, 626, 270, 214, 717};
    private static final MenuAction[] MENU_ACTIONS_INTERRUPT = new MenuAction[]{MenuAction.WALK, MenuAction.WIDGET_FIRST_OPTION, MenuAction.WIDGET_SECOND_OPTION, MenuAction.WIDGET_TARGET_ON_GAME_OBJECT, MenuAction.WIDGET_TARGET_ON_GROUND_ITEM, MenuAction.WIDGET_TARGET_ON_PLAYER, MenuAction.WIDGET_TARGET_ON_NPC, MenuAction.WIDGET_TARGET_ON_GROUND_ITEM, MenuAction.WIDGET_TARGET_ON_PLAYER, MenuAction.WIDGET_TARGET_ON_NPC, MenuAction.WIDGET_TARGET_ON_GAME_OBJECT, MenuAction.WIDGET_TARGET_ON_WIDGET};
    private boolean waiting;
    @Inject
    private Client client;
    @Inject
    private EventBus eventBus;

    private static int PACK(int groupId, int childId) {
        return groupId << 16 | childId;
    }

    public void interrupt(Object source) {
        if (this.waiting) {
            Interrupt interrupt = new Interrupt(source);
            this.eventBus.post((Object)interrupt);
            if (!interrupt.isConsumed()) {
                this.waiting = false;
                log.debug("Interrupted by {}", source);
            }
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged evt) {
        if (evt.getValue() == 173 && this.client.getLocalDestinationLocation() == null) {
            this.interrupt("run toggled");
        }
    }

    public void setWaiting(boolean waiting) {
        this.waiting = waiting;
    }

    @Subscribe
    public void onDestinationChanged(DestinationChanged evt) {
        if (evt.getTo() != null) {
            this.interrupt(evt);
        }
    }

    @Subscribe
    public void onLocalInteractingChanged(LocalInteractingChanged evt) {
        this.interrupt(evt);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged evt) {
        if (evt.getGameState() == GameState.LOGIN_SCREEN) {
            this.interrupt(evt);
        }
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied evt) {
        if (evt.getActor() == this.client.getLocalPlayer() && evt.getHitsplat().isMine()) {
            this.interrupt(evt);
        }
    }

    @Subscribe
    public void onResizeableChanged(ResizeableChanged evt) {
        this.interrupt(evt);
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked evt) {
        if (Arrays.binarySearch(MENU_ACTIONS_INTERRUPT, evt.getMenuAction()) >= 0) {
            this.interrupt(evt);
        } else if (evt.getMenuAction() == MenuAction.CC_OP && Arrays.binarySearch(WIDGET_CLICK_INTERRUPTS, evt.getParam1()) >= 0) {
            this.interrupt(evt);
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded evt) {
        int groupId = evt.getGroupId();
        if (Arrays.binarySearch(WIDGET_GROUPS_INTERRUPT, groupId) >= 0) {
            this.interrupt(evt);
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage evt) {
        if (evt.getType() == ChatMessageType.GAMEMESSAGE) {
            if (evt.getMessage().matches("You need level (\\d*) ([A-Za-z]*) to (.*)$")) {
                this.interrupt(evt);
            } else if (evt.getMessage().matches("The [a-z-]*, [a-z-]* portal shield has dropped!")) {
                this.interrupt(evt);
            } else if (evt.getMessage().matches("Your amulet of chemistry helps you create a [0-9]{1}-dose potion. <col=ff0000>It then crumbles to dust.</col>") && this.config.herbChemistry()) {
                this.interrupt(evt);
            }
        }
    }

    public boolean isWaiting() {
        return this.waiting;
    }

    static {
        Arrays.sort(WIDGET_CLICK_INTERRUPTS);
        Arrays.sort(WIDGET_GROUPS_INTERRUPT);
        Arrays.sort(MENU_ACTIONS_INTERRUPT);
    }
}

