/*
 * Decompiled with CFR 0.152.
 */
package com.spirit;

import com.google.inject.Provides;
import com.spirit.SpiritTreeMenuConfig;
import java.util.ArrayList;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Spirit Tree Menu", description="Updates the Spirit Tree navigation menu", tags={"spirit", "teleport", "tree"})
public class SpiritTreeMenuPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SpiritTreeMenuPlugin.class);
    private static final String MENU_TITLE = "Spirit Tree Locations";
    private static final int ADVENTURE_LOG_TITLE = 0;
    private static final int ADVENTURE_LOG_LIST = 3;
    private static final String MENU_REGEX = "(<col[^>]+>)(\\S+)(</col>):\\s+(.+)";
    private static final String KHAZARD_LONG = "Battlefield of Khazard";
    private static final String KHAZARD_SHORT = "B'field of Khazard";
    private static final String YOUR_HOUSE = "Your house";
    private static final int LEFT_PIXELS = 7;
    private static final String CANCEL = "Cancel";
    private static final String INACTIVE_COLOR = "5f5f5f";
    @Inject
    private ClientThread clientThread;
    @Inject
    private Client client;
    @Inject
    private SpiritTreeMenuConfig config;

    protected void startUp() {
        log.debug("Spirit Tree Menu started!");
    }

    protected void shutDown() {
        log.debug("Spirit Tree Menu stopped!");
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded e) {
        if (e.getGroupId() == 187) {
            log.debug("Adventure Log loaded!");
            this.clientThread.invokeLater(() -> {
                if (Objects.requireNonNull(this.client.getWidget(187, 0)).getChild(1).getText().equals(MENU_TITLE)) {
                    Widget adventureLogList = this.client.getWidget(187, 3);
                    ArrayList<Widget> treeLocations = new ArrayList<Widget>();
                    for (Widget childWidget : Objects.requireNonNull(adventureLogList).getDynamicChildren()) {
                        if (this.config.hideUnavailable() && childWidget.getText().toLowerCase().contains(INACTIVE_COLOR)) {
                            childWidget.setHidden(true);
                            continue;
                        }
                        treeLocations.add(childWidget);
                    }
                    int numItems = treeLocations.size();
                    int newWidgetWidth = adventureLogList.getOriginalWidth() / 2;
                    int numEachCol = (numItems - numItems % 2) / 2;
                    int newWidgetHeight = adventureLogList.getOriginalHeight() / numEachCol - 1;
                    for (int i = 0; i < treeLocations.size(); ++i) {
                        Widget childWidget = (Widget)treeLocations.get(i);
                        if (i < numEachCol) {
                            childWidget.setOriginalY(newWidgetHeight * i);
                            childWidget.setXTextAlignment(0);
                            childWidget.setText(this.updatedText(childWidget.getText(), false));
                            childWidget.setOriginalWidth(newWidgetWidth + 7);
                        } else {
                            childWidget.setOriginalY(newWidgetHeight * (i - numEachCol));
                            childWidget.setOriginalX(newWidgetWidth + 7);
                            childWidget.setXTextAlignment(2);
                            childWidget.setText(this.updatedText(childWidget.getText(), true));
                            childWidget.setOriginalWidth(newWidgetWidth - 7);
                        }
                        if (numItems % 2 == 1 && childWidget.getText().contains(CANCEL)) {
                            childWidget.setHidden(true);
                        }
                        childWidget.setOriginalHeight(newWidgetHeight);
                        childWidget.setFontId(this.config.menuFont().toInt());
                        childWidget.setWidthMode(0);
                        childWidget.setXPositionMode(0);
                        childWidget.revalidate();
                        log.debug(childWidget.getText());
                    }
                }
            });
        }
    }

    private String updatedText(String text, boolean right) {
        Pattern menuItemPattern = Pattern.compile(MENU_REGEX);
        Matcher matcher = menuItemPattern.matcher(text);
        if (!matcher.matches()) {
            return text;
        }
        String colOpen = matcher.group(1);
        String shortcutKey = matcher.group(2);
        String colClose = matcher.group(3);
        String teleportName = matcher.group(4);
        if (teleportName.contains(YOUR_HOUSE)) {
            teleportName = YOUR_HOUSE;
        }
        if (this.config.menuFont().toInt() > 500 && teleportName.equals(KHAZARD_LONG)) {
            teleportName = KHAZARD_SHORT;
        }
        if (this.config.hideShortcuts()) {
            return teleportName;
        }
        if (right) {
            return teleportName + " " + colOpen + "(" + shortcutKey + ")" + colClose;
        }
        return colOpen + "(" + shortcutKey + ")" + colClose + " " + teleportName;
    }

    @Provides
    SpiritTreeMenuConfig provideConfig(ConfigManager configManager) {
        return (SpiritTreeMenuConfig)configManager.getConfig(SpiritTreeMenuConfig.class);
    }
}

