/*
 * Decompiled with CFR 0.152.
 */
package com.joelhalen.droptracker.ui;

import com.joelhalen.droptracker.DropTrackerPlugin;
import com.joelhalen.droptracker.DropTrackerPluginConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MembersComboBox
extends JButton {
    private DefaultListModel<CheckboxListItem> listModel;
    private JList<CheckboxListItem> list;
    private String[] groupMembers;
    private Map<String, CheckboxListItem> membersMap = new HashMap<String, CheckboxListItem>();

    public MembersComboBox(DropTrackerPlugin plugin, DropTrackerPluginConfig config) {
        Object cachedGroupMembers = null;
        long cacheExpiryTime = 0L;
        this.groupMembers = plugin.getGroupMembers();
        final JTextField filterField = new JTextField(15);
        filterField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateList();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateList();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateList();
            }

            public void updateList() {
                String searchText = filterField.getText();
                MembersComboBox.this.listModel.clear();
                for (String member : MembersComboBox.this.groupMembers) {
                    if (!member.toLowerCase().contains(searchText.toLowerCase())) continue;
                    MembersComboBox.this.listModel.addElement(MembersComboBox.this.membersMap.get(member));
                }
            }
        });
        this.listModel = new DefaultListModel();
        for (String member : this.groupMembers) {
            CheckboxListItem item = new CheckboxListItem(member);
            this.listModel.addElement(item);
            this.membersMap.put(member, item);
        }
        this.list = new JList<CheckboxListItem>(this.listModel);
        this.list.setCellRenderer(new CheckboxListRenderer());
        this.list.setSelectionMode(0);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                CheckboxListItem item;
                JList list = (JList)event.getSource();
                int index = list.locationToIndex(event.getPoint());
                item.setSelected(!(item = (CheckboxListItem)list.getModel().getElementAt(index)).isSelected());
                list.repaint(list.getCellBounds(index, index));
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)filterField, "North");
        panel.add((Component)new JScrollPane(this.list), "Center");
        JPopupMenu popup = new JPopupMenu();
        popup.add(panel);
        this.addActionListener(e -> popup.show(this, 0, this.getHeight()));
    }

    public List<String> getSelectedItems() {
        ArrayList<String> selectedItems = new ArrayList<String>();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            CheckboxListItem item = this.listModel.getElementAt(i);
            if (!item.isSelected()) continue;
            selectedItems.add(item.toString());
        }
        return selectedItems;
    }

    class CheckboxListRenderer
    extends JCheckBox
    implements ListCellRenderer<CheckboxListItem> {
        CheckboxListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends CheckboxListItem> list, CheckboxListItem value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setEnabled(list.isEnabled());
            this.setSelected(value.isSelected());
            this.setFont(list.getFont());
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
            this.setText(value.toString());
            return this;
        }
    }

    class CheckboxListItem {
        private String label;
        private boolean isSelected = false;

        public CheckboxListItem(String label) {
            this.label = label;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
        }

        public String toString() {
            return this.label;
        }
    }
}

