/*
 * Decompiled with CFR 0.152.
 */
package com.joelhalen.droptracker.ui;

import com.joelhalen.droptracker.DropTrackerPluginConfig;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

public class DropEntryOverlay
extends Overlay {
    private final PanelComponent panelComponent = new PanelComponent();
    private final Client client;
    private final DropTrackerPluginConfig config;

    @Inject
    private DropEntryOverlay(Client client, DropTrackerPluginConfig config) {
        this.setPosition(OverlayPosition.TOP_CENTER);
        this.client = client;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        this.panelComponent.getChildren().clear();
        String overlayTitle = "DropTracker";
        String overlayDesc = "You have a drop waiting to be submitted in the side panel!";
        TitleComponent titleComponent = TitleComponent.builder().text(overlayTitle).color(Color.GREEN).build();
        TitleComponent descComponent = TitleComponent.builder().text(overlayDesc).build();
        this.panelComponent.getChildren().add(titleComponent);
        this.panelComponent.getChildren().add(descComponent);
        int maxWidth = Math.max(graphics.getFontMetrics().stringWidth(overlayTitle), graphics.getFontMetrics().stringWidth(overlayDesc));
        int padding = 30;
        int preferredHeight = graphics.getFontMetrics().stringWidth(overlayDesc) + 30;
        this.panelComponent.setPreferredSize(new Dimension(maxWidth += padding, preferredHeight));
        return this.panelComponent.render(graphics);
    }
}

