/*
 * Decompiled with CFR 0.152.
 */
package com.joelhalen.droptracker;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import javax.inject.Inject;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class GroupMemberClient {
    @Inject
    private OkHttpClient client;

    public String[] getGroupMembers(Long serverId, String playerName) throws IOException {
        String groupUrl = "https://droptracker.io/admin/api/get_users_by_server_id.php?server_id=" + serverId;
        Request request = new Request.Builder().url(groupUrl).build();
        try (Response response = this.client.newCall(request).execute();){
            String responseBody = Objects.requireNonNull(response.body()).string();
            JsonParser parser = new JsonParser();
            JsonArray users = parser.parse(responseBody).getAsJsonArray();
            ArrayList<String> usernames = new ArrayList<String>();
            for (JsonElement element : users) {
                JsonObject user = element.getAsJsonObject();
                String rsn = user.get("rsn").getAsString();
                if (rsn.equalsIgnoreCase(playerName)) continue;
                usernames.add(rsn);
            }
            String[] stringArray = usernames.toArray(new String[0]);
            return stringArray;
        }
    }
}

