/*
 * Decompiled with CFR 0.152.
 */
package com.joelhalen.droptracker;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.inject.Provides;
import com.joelhalen.droptracker.DropEntry;
import com.joelhalen.droptracker.DropEntryStream;
import com.joelhalen.droptracker.DropTrackerEventPanel;
import com.joelhalen.droptracker.DropTrackerPanel;
import com.joelhalen.droptracker.DropTrackerPluginConfig;
import com.joelhalen.droptracker.GroupMemberClient;
import com.joelhalen.droptracker.ui.DropEntryOverlay;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.ItemComposition;
import net.runelite.api.NPC;
import net.runelite.api.events.GameTick;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.NpcLootReceived;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.ItemStack;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.loottracker.LootReceived;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.DrawManager;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.http.api.loottracker.LootRecordType;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="DropTracker", description="Automatically uploads your drops to the DropTracker discord bot!", tags={"droptracker", "drop", "leaderboard", "tracking"})
public class DropTrackerPlugin
extends Plugin {
    private OverlayManager overlayManager;
    private DropEntryOverlay overlay;
    public static final String CONFIG_GROUP = "droptracker";
    private final ExecutorService executor = Executors.newCachedThreadPool();
    @Inject
    private DropTrackerPluginConfig config;
    @Inject
    private OkHttpClient httpClient;
    private boolean panelRefreshed = false;
    private boolean eventPanelRefreshed = false;
    private String currentPlayerName = "";
    @Inject
    private ItemManager itemManager;
    @Inject
    public Client client;
    private DropTrackerPanel panel;
    private DropTrackerEventPanel eventPanel;
    @Inject
    public ChatMessageManager chatMessageManager;
    List<DropEntryStream> storedDrops = new CopyOnWriteArrayList<DropEntryStream>();
    @Inject
    private ClientThread clientThread;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private DrawManager drawManager;
    private long accountHash = -1L;
    private Map<String, Integer> serverMinimumLootVarMap;
    private Map<String, Long> clanServerDiscordIDMap;
    private Map<String, String> serverIdToClanNameMap;
    private Map<String, Boolean> serverIdToConfirmedOnlyMap;
    public Map<String, Boolean> clanEventActiveMap;
    private Set<DropEntryStream> sentDrops = new HashSet<DropEntryStream>();
    private boolean prepared = false;
    private static final Logger log = LoggerFactory.getLogger(DropTrackerPlugin.class);
    private static final BufferedImage ICON = ImageUtil.loadImageResource(DropTrackerPlugin.class, (String)"icon.png");
    private static final BufferedImage EVENT_ICON = ImageUtil.loadImageResource(DropTrackerPlugin.class, (String)"event_icon.png");
    private NavigationButton navButton;
    private NavigationButton eventNavButton;
    private String[] groupMembers = new String[0];
    private final Object groupMembersLock = new Object();
    @Inject
    private GroupMemberClient groupMemberClient;

    public void removeOverlay() {
        this.setOverlayManager(this.overlayManager);
        this.setDropEntryOverlay(this.overlay);
        if (this.overlay != null) {
            this.overlayManager.remove((Overlay)this.overlay);
        }
    }

    public void addOverlay() {
        this.setOverlayManager(this.overlayManager);
        this.setDropEntryOverlay(this.overlay);
        if (this.overlay != null) {
            this.overlayManager.add((Overlay)this.overlay);
        }
    }

    @Inject
    public void setOverlayManager(OverlayManager overlayManager) {
        this.overlayManager = overlayManager;
    }

    @Inject
    public void setDropEntryOverlay(DropEntryOverlay overlay) {
        this.overlay = overlay;
    }

    @Subscribe
    public void onNpcLootReceived(NpcLootReceived npcLootReceived) {
        NPC npc = npcLootReceived.getNpc();
        String npcName = npc.getName();
        int npcCombatLevel = npc.getCombatLevel();
        String playerName = this.config.permPlayerName().equals("") ? this.client.getLocalPlayer().getName() : this.config.permPlayerName();
        Collection items = npcLootReceived.getItems();
        for (ItemStack item : items) {
            int itemId = item.getId();
            int quantity = item.getQuantity();
            ArrayList futures = new ArrayList();
            int geValue = this.itemManager.getItemPrice(itemId);
            int haValue = this.itemManager.getItemComposition(itemId).getHaPrice();
            if (geValue == 0 && haValue == 0) continue;
            ItemComposition itemComp = this.itemManager.getItemComposition(itemId);
            String itemName = itemComp.getName();
            boolean ignoreDrops = this.config.ignoreDrops();
            SwingUtilities.invokeLater(() -> {
                if (geValue < this.serverMinimumLootVarMap.get(this.config.serverId())) {
                    String serverId = this.config.serverId();
                    if (!this.serverIdToConfirmedOnlyMap.get(serverId).booleanValue()) {
                        this.sendDropData(playerName, npcName, itemId, itemName, "", quantity, geValue, 0, this.config.authKey(), "");
                    }
                } else {
                    CompletableFuture<String> uploadFuture = this.getScreenshot(playerName, itemId);
                    if (this.config.sendChatMessages()) {
                        ChatMessageBuilder addedDropToPanelMessage = new ChatMessageBuilder();
                        addedDropToPanelMessage.append("[").append(ChatColorType.HIGHLIGHT).append("DropTracker").append(ChatColorType.NORMAL).append("] Added ").append(ChatColorType.HIGHLIGHT).append(itemName).append(ChatColorType.NORMAL).append(" to the RuneLite side panel for review");
                        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(addedDropToPanelMessage.build()).build());
                    }
                    DropEntry entry = new DropEntry();
                    if (this.config.permPlayerName().equals("")) {
                        entry.setPlayerName(playerName);
                    } else {
                        entry.setPlayerName(this.config.permPlayerName());
                    }
                    entry.setNpcOrEventName(npcName);
                    entry.setNpcCombatLevel(npcCombatLevel);
                    entry.setGeValue(geValue);
                    entry.setHaValue(haValue);
                    entry.setItemName(itemName);
                    entry.setItemId(itemId);
                    entry.setQuantity(quantity);
                    if (this.config.sendScreenshots()) {
                        this.getScreenshot(playerName, itemId).thenAccept(imageUrl -> SwingUtilities.invokeLater(() -> entry.setImageLink((String)imageUrl)));
                    } else {
                        entry.setImageLink("none");
                    }
                    this.panel.addDrop(entry);
                    if (this.config.showOverlay() && this.panel.getEntries() != null) {
                        this.addOverlay();
                    }
                }
            });
        }
    }

    public void loadGroupMembersAsync() {
        this.executor.execute(() -> {
            while (true) {
                try {
                    while (true) {
                        String[] newGroupMembers = this.groupMemberClient.getGroupMembers(Long.valueOf(this.config.serverId()), this.getLocalPlayerName());
                        Object object = this.groupMembersLock;
                        synchronized (object) {
                            this.groupMembers = newGroupMembers;
                        }
                        Thread.sleep(900000L);
                    }
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        });
    }

    @Subscribe
    public void onLootReceived(LootReceived lootReceived) {
        if (lootReceived.getType() == LootRecordType.NPC) {
            return;
        }
        Collection items = lootReceived.getItems();
        for (ItemStack item : items) {
            int itemId = item.getId();
            int quantity = item.getQuantity();
            ArrayList futures = new ArrayList();
            int geValue = this.itemManager.getItemPrice(itemId);
            int haValue = this.itemManager.getItemComposition(itemId).getHaPrice();
            if (geValue == 0 && haValue == 0) {
                return;
            }
            ItemComposition itemComp = this.itemManager.getItemComposition(itemId);
            String itemName = itemComp.getName();
            boolean ignoreDrops = this.config.ignoreDrops();
            SwingUtilities.invokeLater(() -> {
                String serverId = this.config.serverId();
                Integer clanMinimumLoot = this.serverMinimumLootVarMap.get(serverId);
                String submissionPlayer = "";
                submissionPlayer = !this.config.permPlayerName().equals("") ? this.config.permPlayerName() : this.client.getLocalPlayer().getName();
                if (geValue < clanMinimumLoot) {
                    if (!this.serverIdToConfirmedOnlyMap.get(serverId).booleanValue()) {
                        this.sendDropData(submissionPlayer, lootReceived.getName(), itemId, itemName, "", quantity, geValue, 0, this.config.authKey(), "");
                    }
                } else {
                    if (quantity > 1) {
                        return;
                    }
                    CompletableFuture<String> uploadFuture = this.getScreenshot(submissionPlayer, itemId);
                    if (this.config.sendChatMessages()) {
                        ChatMessageBuilder addedDropToPanelMessage = new ChatMessageBuilder();
                        addedDropToPanelMessage.append("[").append(ChatColorType.HIGHLIGHT).append("DropTracker").append(ChatColorType.NORMAL).append("] Added ").append(ChatColorType.HIGHLIGHT).append(itemName).append(ChatColorType.NORMAL).append(" to the RuneLite side panel for review");
                        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(addedDropToPanelMessage.build()).build());
                    }
                    DropEntry entry = new DropEntry();
                    if (this.config.permPlayerName().equals("")) {
                        entry.setPlayerName(submissionPlayer);
                    } else {
                        entry.setPlayerName(this.config.permPlayerName());
                    }
                    entry.setNpcOrEventName(lootReceived.getName());
                    entry.setNpcCombatLevel(0);
                    entry.setGeValue(geValue);
                    entry.setHaValue(haValue);
                    entry.setItemName(itemName);
                    entry.setItemId(itemId);
                    entry.setQuantity(quantity);
                    if (this.config.sendScreenshots()) {
                        ((CompletableFuture)uploadFuture.thenAccept(imageUrl -> SwingUtilities.invokeLater(() -> entry.setImageLink((String)imageUrl)))).exceptionally(ex -> {
                            log.error("Failed to get screenshot", ex);
                            return null;
                        });
                    } else {
                        entry.setImageLink("none");
                    }
                    this.panel.addDrop(entry);
                }
            });
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.client.getGameState() == GameState.LOGGED_IN && this.client.getLocalPlayer().getName() != null && !this.client.getLocalPlayer().getName().equals(this.currentPlayerName)) {
            this.currentPlayerName = this.client.getLocalPlayer().getName();
            if (!this.panelRefreshed) {
                log.debug("[DropTracker] Updating panel due to a new player state");
                this.panel.refreshPanel();
                this.panelRefreshed = true;
            }
            if (this.panel.getEntries() == null && this.overlay != null) {
                this.removeOverlay();
            }
            if (this.config.showOverlay() && this.panel.getEntries() != null) {
                this.addOverlay();
            }
            if (this.client.getGameState() == GameState.LOGGED_IN && !this.eventPanelRefreshed) {
                this.initializeEventPanel();
                this.eventPanelRefreshed = true;
            } else if (this.client.getGameState() != GameState.LOGGED_IN) {
                this.eventPanelRefreshed = false;
            }
        } else {
            this.panelRefreshed = false;
            this.eventPanelRefreshed = false;
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        this.panel.refreshPanel();
        if (this.config.showEventPanel() && this.clanEventActiveMap.get(this.config.serverId()).booleanValue() && this.eventPanel != null) {
            this.eventPanel.refreshPanel();
        }
        if (this.overlay != null) {
            if (!this.config.showOverlay()) {
                this.removeOverlay();
            } else if (this.config.showOverlay() && this.panel.getEntries() != null) {
                this.addOverlay();
            }
        }
    }

    @Provides
    DropTrackerPluginConfig provideConfig(ConfigManager configManager) {
        return (DropTrackerPluginConfig)configManager.getConfig(DropTrackerPluginConfig.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getGroupMembers() {
        Object object = this.groupMembersLock;
        synchronized (object) {
            return this.groupMembers;
        }
    }

    public String getLocalPlayerName() {
        if (this.client != null && this.client.getLocalPlayer() != null) {
            return this.client.getLocalPlayer().getName();
        }
        return null;
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.navButton);
        this.clientToolbar.removeNavigation(this.eventNavButton);
        this.removeOverlay();
        this.panel = null;
        this.eventPanel = null;
        this.navButton = null;
        this.overlayManager = null;
        this.overlay = null;
        this.accountHash = -1L;
    }

    public String getPlayerName() {
        if (this.config.permPlayerName().equals("")) {
            return this.client.getLocalPlayer().getName();
        }
        return this.config.permPlayerName();
    }

    protected void startUp() {
        this.initializeEventPanel();
        this.loadGroupMembersAsync();
        this.accountHash = this.client.getAccountHash();
        this.panel = new DropTrackerPanel(this, this.config, this.itemManager, this.chatMessageManager);
        this.navButton = NavigationButton.builder().tooltip("Drop Tracker").icon(ICON).priority(2).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
        if (!this.prepared) {
            this.clientThread.invoke(() -> {
                switch (this.client.getGameState()) {
                    case LOGGED_IN: {
                        if (!this.config.serverId().equals("") && !this.config.authKey().equals("")) {
                            this.prepared = true;
                        }
                    }
                    case LOGIN_SCREEN: 
                    case LOGIN_SCREEN_AUTHENTICATOR: 
                    case LOGGING_IN: 
                    case LOADING: 
                    case CONNECTION_LOST: 
                    case HOPPING: {
                        this.prepared = false;
                        return false;
                    }
                }
                return false;
            });
        }
    }

    private void initializeEventPanel() {
        ((CompletableFuture)this.grabServerConfiguration().thenRun(() -> {
            String serverId;
            Boolean isEventActive;
            if (this.client.getGameState() == GameState.LOGGED_IN && this.config.showEventPanel() && (isEventActive = this.clanEventActiveMap.getOrDefault(serverId = this.config.serverId(), false)).booleanValue() && this.eventPanel == null) {
                SwingUtilities.invokeLater(() -> {
                    this.eventPanel = new DropTrackerEventPanel(this, this.config, this.itemManager, this.chatMessageManager);
                    this.eventNavButton = NavigationButton.builder().tooltip("DropTracker - Events").icon(EVENT_ICON).priority(3).panel((PluginPanel)this.eventPanel).build();
                    this.clientToolbar.addNavigation(this.eventNavButton);
                });
            }
        })).exceptionally(ex -> {
            log.error("Error fetching server configuration", ex);
            return null;
        });
    }

    public String getServerName(String serverId) {
        if (serverId == "" || !this.serverIdToClanNameMap.containsKey(serverId)) {
            return "None!";
        }
        return this.serverIdToClanNameMap.get(serverId);
    }

    public int getServerMinimumLoot(String serverId) {
        if (serverId == "" || !this.serverMinimumLootVarMap.containsKey(serverId)) {
            return 0;
        }
        return this.serverMinimumLootVarMap.get(serverId);
    }

    public long getClanDiscordServerID(String serverId) {
        if (serverId == "" || !this.clanServerDiscordIDMap.containsKey(serverId)) {
            return 0L;
        }
        return this.clanServerDiscordIDMap.get(serverId);
    }

    public Boolean clanEventActive(String serverId) {
        if (serverId == "" | !this.clanEventActiveMap.containsKey(serverId)) {
            return false;
        }
        return this.clanEventActiveMap.get(serverId);
    }

    public String getIconUrl(int id) {
        return String.format("https://static.runelite.net/cache/item/icon/%d.png", id);
    }

    public ItemComposition getItemComposition(int itemId) {
        return this.itemManager.getItemComposition(itemId);
    }

    private CompletableFuture<Void> grabServerConfiguration() {
        return CompletableFuture.runAsync(() -> {
            String playerName = "";
            playerName = this.config.permPlayerName().equals("") ? this.client.getLocalPlayer().getName() : this.config.permPlayerName();
            MediaType mediaType = MediaType.parse((String)"application/x-www-form-urlencoded");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)("auth_token=" + this.config.authKey() + "&player_name=" + playerName));
            Request request = new Request.Builder().url("https://www.droptracker.io/admin/api/runelite_client_settings.php").post(body).addHeader("Content-Type", "application/x-www-form-urlencoded").build();
            try {
                Response response = this.httpClient.newCall(request).execute();
                String jsonData = response.body().string();
                JsonParser parser = new JsonParser();
                JsonObject jsonObject = parser.parse(jsonData).getAsJsonObject();
                this.serverIdToClanNameMap = new HashMap<String, String>();
                this.serverMinimumLootVarMap = new HashMap<String, Integer>();
                this.serverIdToConfirmedOnlyMap = new HashMap<String, Boolean>();
                this.clanEventActiveMap = new HashMap<String, Boolean>();
                String serverName = jsonObject.has("server_name") ? jsonObject.get("server_name").getAsString() : "";
                String serverId = this.config.serverId();
                JsonObject configObject = jsonObject.has("config") ? jsonObject.get("config").getAsJsonObject() : new JsonObject();
                String isEventActiveStr = configObject.has("is_event_currently_active") ? configObject.get("is_event_currently_active").getAsString() : "";
                String storeOnlyConfirmed = configObject.has("store_only_confirmed_drops") ? configObject.get("store_only_confirmed_drops").getAsString() : "";
                boolean isEventActive = "1".equals(isEventActiveStr);
                boolean storeOnlyConfirmedDrops = "1".equals(storeOnlyConfirmed);
                this.serverIdToClanNameMap.put(serverId, serverName);
                this.serverMinimumLootVarMap.put(serverId, configObject.has("minimum_loot_for_notifications") ? configObject.get("minimum_loot_for_notifications").getAsInt() : 1000000);
                this.serverIdToConfirmedOnlyMap.put(serverId, storeOnlyConfirmedDrops);
                this.clanEventActiveMap.put(serverId, isEventActive);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public CompletableFuture<Void> sendDropData(String playerName, String npcName, int itemId, String itemName, String memberList, int quantity, int geValue, int nonMembers, String authKey, String imageUrl) {
        boolean send_msg;
        HttpUrl url = HttpUrl.parse((String)"https://droptracker.io/admin/api/store_drop_data.php");
        String serverId = this.config.serverId();
        String notified_str = "1";
        if (geValue > this.getServerMinimumLoot(this.config.serverId())) {
            notified_str = "0";
            send_msg = true;
        } else {
            send_msg = false;
        }
        FormBody.Builder formBuilder = new FormBody.Builder().add("auth_token", authKey).add("item_name", itemName).add("item_id", String.valueOf(itemId)).add("player_name", playerName).add("server_id", serverId).add("quantity", String.valueOf(quantity)).add("value", String.valueOf(geValue)).add("nonmember", String.valueOf(nonMembers)).add("member_list", memberList).add("image_url", imageUrl).add("npc_name", npcName).add("notified", notified_str);
        Request request = new Request.Builder().url(url).post((RequestBody)formBuilder.build()).build();
        return CompletableFuture.runAsync(() -> {
            try (Response response = this.httpClient.newCall(request).execute();){
                if (!response.isSuccessful()) {
                    throw new IOException("Unexpected code " + response);
                }
                JsonParser parser = new JsonParser();
                String responseData = response.body().string();
                JsonObject jsonObj = parser.parse(responseData).getAsJsonObject();
                if (jsonObj.has("success") && send_msg) {
                    String playerTotalLoot = jsonObj.has("totalLootValue") ? jsonObj.get("totalLootValue").getAsString() : "0";
                    ChatMessageBuilder messageResponse = new ChatMessageBuilder();
                    NumberFormat playerLootFormat = NumberFormat.getNumberInstance();
                    String playerLootString = DropTrackerPanel.formatNumber(Double.parseDouble(playerTotalLoot));
                    messageResponse.append(ChatColorType.NORMAL).append("[").append(ChatColorType.HIGHLIGHT).append("DropTracker").append(ChatColorType.NORMAL).append("] ").append("Your drop has been submitted! You now have a total of " + playerLootString);
                    this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(messageResponse.build()).build());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private CompletableFuture<String> getScreenshot(String playerName, int itemId) {
        CompletableFuture<String> future = new CompletableFuture<String>();
        try {
            String serverId = this.config.serverId();
            this.drawManager.requestNextFrameListener(image -> {
                try {
                    ItemComposition itemComp = this.itemManager.getItemComposition(itemId);
                    String itemName = itemComp.getName();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)((Object)image), "png", baos);
                    byte[] imageData = baos.toByteArray();
                    String nicePlayerName = playerName.replace(" ", "_");
                    MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", nicePlayerName + "_" + itemName + ".png", RequestBody.create((MediaType)MediaType.parse((String)"image/png"), (byte[])imageData)).build();
                    this.executor.submit(() -> this.lambda$getScreenshot$14((RequestBody)requestBody, future));
                }
                catch (IOException e) {
                    future.completeExceptionally(e);
                }
            });
        }
        catch (Exception e) {
            future.completeExceptionally(e);
            this.executor.shutdown();
        }
        return future;
    }

    private /* synthetic */ void lambda$getScreenshot$14(RequestBody requestBody, CompletableFuture future) {
        Request request = new Request.Builder().url("https://www.droptracker.io/upload/upload.php").post(requestBody).build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected response code: " + response);
            }
            String responseBody = response.body().string();
            future.complete(responseBody.trim());
        }
        catch (IOException e) {
            future.completeExceptionally(e);
        }
    }
}

