/*
 * Decompiled with CFR 0.152.
 */
package com.joelhalen.droptracker;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.joelhalen.droptracker.DropEntry;
import com.joelhalen.droptracker.DropTrackerPlugin;
import com.joelhalen.droptracker.DropTrackerPluginConfig;
import com.joelhalen.droptracker.ui.DropEntryOverlay;
import com.joelhalen.droptracker.ui.MembersComboBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropTrackerPanel
extends PluginPanel {
    @Inject
    private final DropTrackerPlugin plugin;
    private final DropTrackerPluginConfig config;
    @Inject
    private final ItemManager itemManager;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private Client client;
    private JTable table = new JTable();
    private static final Logger log = LoggerFactory.getLogger(DropTrackerPlugin.class);
    public final List<DropEntry> entries = new ArrayList<DropEntry>();
    private final JPanel dropsPanel;
    @Inject
    private DropEntryOverlay overlay;
    public String localAuthKey = null;
    public String localPlayerName = null;
    private static final BufferedImage TOP_LOGO = ImageUtil.loadImageResource(DropTrackerPlugin.class, (String)"toplogo.png");

    public List<DropEntry> getEntries() {
        if (this.entries != null && !this.entries.isEmpty()) {
            return this.entries;
        }
        return null;
    }

    public DropTrackerPanel(DropTrackerPlugin plugin, DropTrackerPluginConfig config, ItemManager itemManager, ChatMessageManager chatMessageManager) {
        this.plugin = plugin;
        this.config = config;
        this.itemManager = itemManager;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.dropsPanel = new JPanel();
        this.dropsPanel.setLayout(new BoxLayout(this.dropsPanel, 1));
        this.dropsPanel.setBorder(new EmptyBorder(15, 0, 100, 0));
        this.dropsPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        ImageIcon logoIcon = new ImageIcon(TOP_LOGO);
        JLabel logoLabel = new JLabel(logoIcon);
        this.dropsPanel.add(logoLabel);
        JButton refreshButton = new JButton("Refresh");
        refreshButton.addActionListener(e -> this.refreshPanel());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(refreshButton);
        buttonPanel.add(Box.createHorizontalGlue());
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add(buttonPanel);
        topPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        topPanel.add((Component)logoLabel, "North");
        topPanel.add((Component)buttonPanel, "Center");
        this.dropsPanel.add((Component)topPanel, "North");
        this.dropsPanel.setLayout(new BoxLayout(this.dropsPanel, 1));
        String playerName = plugin.getPlayerName();
        if (config.serverId().equals("") || !config.authKey().equals("")) {
            JLabel descText = new JLabel("<html><center><h1>Welcome to the DropTracker!</h1><br><span>It appears that you do not have a server ID configured or that your auth token has been left blank.<br></span><span>This plugin requires registration and valid authentication!<br>Use your clan's Discord Server ID!</span><br />Try using /gettoken inside the discord server to retrieve your token if it's been lost.</html>");
            this.dropsPanel.add(descText);
        } else if (this.localAuthKey == null || this.localPlayerName != plugin.getLocalPlayerName()) {
            if (config.authKey().equals("")) {
                JLabel descText = new JLabel("<html>You do not have an authentication token in your plugin configuration!<br>This should have been provided to you when you registered in the Discord.<br>If you've lost it, visit www.droptracker.io to request a reset.</html>");
                descText.setAlignmentX(0.0f);
                Box descTextBox = Box.createHorizontalBox();
                descTextBox.add(descText);
                descTextBox.add(Box.createHorizontalGlue());
                this.dropsPanel.add(descTextBox);
            } else if (config.authKey().equals(this.checkAuthKey(playerName, config.serverId(), config.authKey()))) {
                JLabel descText = new JLabel("<html><center>The authentication token you entered is invalid.<br><br>If you play multiple accounts, ensure that the account you registered with is entered into the <b>Permanent Player Name</b> config option.<br><br>If you've lost your authentication token, use /gettoken inside Discord.</center></html>");
                descText.setAlignmentX(0.0f);
                Box descTextBox = Box.createHorizontalBox();
                descTextBox.add(descText);
                descTextBox.add(Box.createHorizontalGlue());
                this.dropsPanel.add(descTextBox);
            } else {
                String serverName = plugin.getServerName(config.serverId());
                int minimumClanLoot = plugin.getServerMinimumLoot(config.serverId());
                Long discordServerId = Long.valueOf(config.serverId());
                NumberFormat clanLootFormat = NumberFormat.getNumberInstance();
                String minimumLootString = clanLootFormat.format(minimumClanLoot);
                AtomicReference<String> playerLoot = new AtomicReference<String>("none");
                String formattedServerTotal = "0";
                if (!config.serverId().equals("")) {
                    AtomicReference<String> serverLootTotal = new AtomicReference<String>("none");
                    this.fetchLootFromServer().thenAccept(lootData -> SwingUtilities.invokeLater(() -> {
                        if (lootData != null) {
                            if (lootData.containsKey("player_total")) {
                                playerLoot.set(DropTrackerPanel.formatNumber(Double.parseDouble((String)lootData.get("playerLoot"))));
                            }
                            if (lootData.containsKey("server_total")) {
                                serverLootTotal.set(DropTrackerPanel.formatNumber(Double.parseDouble((String)lootData.get("serverLoot"))));
                            }
                        }
                    }));
                } else {
                    playerLoot.set("not signed in!");
                    formattedServerTotal = "0";
                }
                Object[][] data = new String[][]{{"Your Clan", serverName}, {"Minimum value", minimumLootString + " gp"}, {"Your total loot", "loading..."}, {"Clan Total:", "loading..."}};
                this.updateTable("load", "load");
                Object[] columnNames = new String[]{"Key", "Value"};
                DefaultTableModel model = new DefaultTableModel(data, columnNames){

                    @Override
                    public boolean isCellEditable(int row, int column) {
                        return false;
                    }
                };
                JTable table = new JTable(model);
                table.setPreferredScrollableViewportSize(new Dimension(500, 70));
                table.setFillsViewportHeight(true);
                table.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){
                    Font originalFont = null;

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        if (this.originalFont == null) {
                            this.originalFont = c.getFont();
                        }
                        c.setFont(this.originalFont.deriveFont(1));
                        return c;
                    }
                });
                this.dropsPanel.add(table);
                if (config.showHelpText()) {
                    JLabel descText = new JLabel("<html>The database will automatically track all drops you receive.<br><br>Any item above your clan's minimum, <b>" + minimumLootString + " gp</b>, will appear below.<br><br>You can select any clan members involved in the drop from the left-side dropdown list to credit them for their split.<br>The non-member dropdown allows you to specify the split-size if any players from outside of your clan were involved with the drop.<br><br><b>You can prevent this information from re-appearing in the plugin config!</b></html>");
                    descText.setAlignmentX(0.0f);
                    Box descTextBox = Box.createHorizontalBox();
                    descTextBox.add(descText);
                    descTextBox.add(Box.createHorizontalGlue());
                    this.dropsPanel.add(descTextBox);
                }
            }
        }
        this.add(this.dropsPanel, "Center");
    }

    public CompletableFuture<Map<String, String>> fetchLootFromServer() {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<String, String> lootData = new HashMap<String, String>();
            try {
                String line;
                String playerName = this.plugin.getPlayerName();
                playerName = URLEncoder.encode(playerName, StandardCharsets.UTF_8.toString());
                URL url = new URL("https://www.droptracker.io/admin/api/fetch_drop_data.php?server_id=" + this.config.serverId() + "&player_name=" + playerName);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder builder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    builder.append(line);
                }
                reader.close();
                JsonParser parser = new JsonParser();
                JsonObject jsonResponse = parser.parse(builder.toString()).getAsJsonObject();
                lootData.put("playerLoot", jsonResponse.has("player_total") ? jsonResponse.get("player_total").getAsString() : "");
                lootData.put("serverLoot", jsonResponse.has("server_total") ? jsonResponse.get("server_total").getAsString() : "");
                JsonArray recentDropsArray = jsonResponse.has("recent_drops") ? jsonResponse.get("recent_drops").getAsJsonArray() : new JsonArray();
                lootData.put("recentDrops", recentDropsArray.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return lootData;
        });
    }

    void refreshPanel() {
        SwingUtilities.invokeLater(() -> {
            JLabel descText;
            this.dropsPanel.removeAll();
            String playerName = this.plugin.getLocalPlayerName();
            this.dropsPanel.setLayout(new BoxLayout(this.dropsPanel, 1));
            AtomicReference<String> playerLoot = new AtomicReference<String>("loading...");
            AtomicReference<String> formattedServerTotalRef = new AtomicReference<String>("loading...");
            String formattedServerTotal = "0";
            AtomicBoolean isAllItemsBoxAdded = new AtomicBoolean(false);
            if (playerName != null) {
                if (this.config.serverId().equals("")) {
                    ChatMessageBuilder messageResponse = new ChatMessageBuilder();
                    messageResponse.append(ChatColorType.NORMAL).append("[").append(ChatColorType.HIGHLIGHT).append("DropTracker").append(ChatColorType.NORMAL).append("]").append("You have not configured a serverID in the plugin config! If your server is not part of the DropTracker, the plugin will not work!");
                    this.plugin.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(messageResponse.build()).build());
                    playerLoot.set("<em>...</em>");
                    try {
                        this.plugin.shutDown();
                    }
                    catch (Exception e2) {
                        throw new RuntimeException(e2);
                    }
                    return;
                }
                this.checkAuthKeyAsync(playerName, this.config.serverId(), this.config.authKey(), authRes -> SwingUtilities.invokeLater(() -> {
                    if (authRes.equals("User not found")) {
                        ChatMessageBuilder messageResponse = new ChatMessageBuilder();
                        messageResponse.append(ChatColorType.HIGHLIGHT).append("[").append("DropTracker").append("] Your account was not found in " + this.plugin.getServerName(this.config.serverId())).append("'s database!");
                        ChatMessageBuilder registrationMemberResponse = new ChatMessageBuilder();
                        messageResponse.append(ChatColorType.HIGHLIGHT).append("In order to register, type your").append("RSN inside of your clan's designated discord channel.");
                        playerLoot.set("<em>unregistered</em>");
                        this.plugin.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(messageResponse.build()).build());
                        this.plugin.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(registrationMemberResponse.build()).build());
                    } else if (authRes.equals("Invalid auth token")) {
                        ChatMessageBuilder messageResponse = new ChatMessageBuilder();
                        messageResponse.append(ChatColorType.HIGHLIGHT).append("[").append("DropTracker").append("] You have entered an invalid authentication").append(" token in the configuration for DropTracker.");
                        playerLoot.set("<em>unregistered</em>");
                        this.plugin.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(messageResponse.build()).build());
                    } else if (authRes.equals("yes")) {
                        this.localAuthKey = this.config.authKey();
                        if (this.plugin.getLocalPlayerName() != null) {
                            this.localPlayerName = this.plugin.getLocalPlayerName();
                        }
                        CompletableFuture.runAsync(() -> {
                            if (!this.config.permPlayerName().equals("")) {
                                this.localPlayerName = this.config.permPlayerName();
                            }
                            this.fetchLootFromServer().thenAccept(lootData -> SwingUtilities.invokeLater(() -> {
                                Box descTextBox;
                                JLabel descText;
                                if (lootData != null) {
                                    if (lootData.containsKey("playerLoot")) {
                                        playerLoot.set(DropTrackerPanel.formatNumber(Double.parseDouble((String)lootData.get("playerLoot"))));
                                    }
                                    if (lootData.containsKey("serverLoot")) {
                                        formattedServerTotalRef.set(DropTrackerPanel.formatNumber(Double.parseDouble((String)lootData.get("serverLoot"))));
                                    }
                                } else {
                                    playerLoot.set("unregistered");
                                }
                                this.updateTable((String)playerLoot.get(), (String)formattedServerTotalRef.get());
                                if (lootData.containsKey("recentDrops")) {
                                    descText = new JLabel("<html><h3><b>" + this.plugin.getServerName(this.config.serverId()) + "'s Recent Submissions:</b></h3></html>");
                                    descText.setAlignmentX(0.5f);
                                    descTextBox = Box.createHorizontalBox();
                                    descTextBox.add(Box.createHorizontalGlue());
                                    descTextBox.add(descText);
                                    descTextBox.add(Box.createHorizontalGlue());
                                    this.dropsPanel.add((Component)descTextBox, "North");
                                    JsonParser parser = new JsonParser();
                                    JsonArray recentDropsArray = parser.parse((String)lootData.get("recentDrops")).getAsJsonArray();
                                    ArrayList<JsonObject> dropList = new ArrayList<JsonObject>();
                                    for (JsonElement element : recentDropsArray) {
                                        dropList.add(element.getAsJsonObject());
                                    }
                                    dropList.sort((a, b) -> Integer.compare(b.get("value").getAsInt(), a.get("value").getAsInt()));
                                    List topDrops = dropList.stream().limit(3L).collect(Collectors.toList());
                                    Box allItemsBox = Box.createHorizontalBox();
                                    for (JsonObject drop : topDrops) {
                                        Box entryItemBox = Box.createVerticalBox();
                                        entryItemBox.setAlignmentX(0.5f);
                                        int itemId = drop.get("item_id").getAsInt();
                                        String dropPlayerName = drop.has("player_name") ? drop.get("player_name").getAsString() : "Unknown";
                                        String timeReceived = drop.has("time") ? drop.get("time").getAsString() : "";
                                        String itemName = drop.has("item_name") ? drop.get("item_name").getAsString() : "";
                                        AsyncBufferedImage itemImage = this.itemManager.getImage(itemId);
                                        JLabel imageLabel = new JLabel(new ImageIcon((Image)itemImage));
                                        imageLabel.setAlignmentX(0.5f);
                                        JLabel itemNameLabel = new JLabel("<html><b>" + itemName + "</b></html>");
                                        itemNameLabel.setAlignmentX(0.5f);
                                        JLabel playerLabel = new JLabel(dropPlayerName);
                                        playerLabel.setAlignmentX(0.5f);
                                        JLabel timeLabel = new JLabel("<html><em>" + timeReceived + "</em></html>");
                                        timeLabel.setAlignmentX(0.5f);
                                        entryItemBox.add(itemNameLabel);
                                        entryItemBox.add(imageLabel);
                                        entryItemBox.add(playerLabel);
                                        entryItemBox.add(timeLabel);
                                        allItemsBox.add(Box.createHorizontalStrut(10));
                                        allItemsBox.add(entryItemBox);
                                    }
                                    if (!isAllItemsBoxAdded.get()) {
                                        this.dropsPanel.add(allItemsBox);
                                        isAllItemsBoxAdded.set(true);
                                    }
                                }
                                this.dropsPanel.revalidate();
                                this.dropsPanel.repaint();
                                if (this.entries.isEmpty()) {
                                    descText = new JLabel("<html><i>You have not yet received any drops to submit.</i></html>");
                                    descText.setAlignmentX(0.0f);
                                    descTextBox = Box.createHorizontalBox();
                                    descTextBox.add(descText);
                                    descTextBox.add(Box.createHorizontalGlue());
                                    this.dropsPanel.add(descTextBox);
                                }
                            }));
                        });
                    } else {
                        log.debug("Some type of error occurred authenticating with the DropTracker database.");
                    }
                }));
            } else {
                playerLoot.set("not signed in!");
            }
            if (this.config.authKey().equals("")) {
                return;
            }
            this.dropsPanel.setBorder(new EmptyBorder(15, 0, 100, 0));
            this.dropsPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
            ImageIcon logoIcon = new ImageIcon(TOP_LOGO);
            JLabel logoLabel = new JLabel(logoIcon);
            this.dropsPanel.add(logoLabel);
            JButton refreshButton = new JButton("Refresh");
            refreshButton.addActionListener(e -> this.refreshPanel());
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
            buttonPanel.add(Box.createHorizontalGlue());
            buttonPanel.add(refreshButton);
            buttonPanel.add(Box.createHorizontalGlue());
            JPanel topPanel = new JPanel(new BorderLayout());
            topPanel.add(buttonPanel);
            topPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
            topPanel.add((Component)logoLabel, "North");
            topPanel.add((Component)buttonPanel, "Center");
            this.dropsPanel.add((Component)topPanel, "North");
            this.dropsPanel.setLayout(new BoxLayout(this.dropsPanel, 1));
            if (this.config.serverId().equals("") || this.config.authKey().equals("")) {
                descText = new JLabel("<html><br><br>Welcome to the DropTracker!<br><br>In order to start tracking drops,<br>your server must be added<br> to our database, and you must configure the plugin from settings panel -><br> Contact a member of your clan's staff team to get set up, or obtain your ServerID!</html>");
                descText.setAlignmentX(0.0f);
                Box descTextBox = Box.createHorizontalBox();
                descTextBox.add(descText);
                descTextBox.add(Box.createHorizontalGlue());
                this.dropsPanel.add(descTextBox);
            } else {
                String serverName = this.plugin.getServerName(this.config.serverId());
                int minimumClanLoot = this.plugin.getServerMinimumLoot(this.config.serverId());
                NumberFormat clanLootFormat = NumberFormat.getNumberInstance();
                String minimumLootString = clanLootFormat.format(minimumClanLoot);
                Object[][] data = new String[][]{{"Your Clan: ", serverName}, {"Minimum Value: ", minimumLootString + " gp"}, {"Your total loot: ", playerLoot.get(), ""}, {"Clan Total: ", formattedServerTotalRef.get()}};
                Object[] columnNames = new String[]{"Key", "Value"};
                DefaultTableModel model = new DefaultTableModel(data, columnNames){

                    @Override
                    public boolean isCellEditable(int row, int column) {
                        return false;
                    }
                };
                this.table.setModel(model);
                this.table.setPreferredScrollableViewportSize(new Dimension(500, 70));
                this.table.setFillsViewportHeight(true);
                if (this.table.getColumnModel().getColumnCount() > 0) {
                    this.table.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){
                        Font originalFont = null;

                        @Override
                        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                            if (this.originalFont == null) {
                                this.originalFont = c.getFont();
                            }
                            c.setFont(this.originalFont.deriveFont(1));
                            return c;
                        }
                    });
                }
                this.dropsPanel.add(this.table);
                if (this.config.showHelpText()) {
                    descText = new JLabel("<html>The database will automatically track all drops you receive.<br><br>Any item above your clan's minimum, <b>" + minimumLootString + " gp</b>, will appear below.<br><br>You can select any clan members involved in the drop from the left-side dropdown list to credit them for their split.<br>The non-member dropdown allows you to specify the split-size if any players from outside of your clan were involved with the drop.<br><br><b>You can prevent this information from re-appearing in the plugin config!</b></html>");
                    descText.setAlignmentX(0.0f);
                    Box descTextBox = Box.createHorizontalBox();
                    descTextBox.add(descText);
                    descTextBox.add(Box.createHorizontalGlue());
                    this.dropsPanel.add(descTextBox);
                }
            }
            if (!this.entries.isEmpty()) {
                for (DropEntry entry : this.entries) {
                    this.dropsPanel.setAlignmentX(0.0f);
                    Box entryItemBox = Box.createHorizontalBox();
                    AsyncBufferedImage itemImage = this.itemManager.getImage(entry.getItemId());
                    JLabel imageLabel = new JLabel(new ImageIcon((Image)itemImage));
                    String itemName = entry.getItemName();
                    int geValue = entry.getGeValue();
                    JLabel itemTextLabel = new JLabel("<html>Item: " + itemName + "<br>Value: " + String.valueOf(geValue) + "gp</html>");
                    JPanel nameFieldPanel = new JPanel(new BorderLayout());
                    JLabel nameLabel = new JLabel("Select Members:");
                    nameFieldPanel.add((Component)nameLabel, "North");
                    MembersComboBox membersComboBox = new MembersComboBox(this.plugin, this.config);
                    membersComboBox.setPreferredSize(new Dimension(75, 25));
                    nameFieldPanel.add((Component)membersComboBox, "Center");
                    Integer[] nonMemberOptions = new Integer[21];
                    for (int i = 0; i <= 20; ++i) {
                        nonMemberOptions[i] = i;
                    }
                    JPanel nonMemberDropdownPanel = new JPanel(new BorderLayout());
                    JLabel nonMemberLabel = new JLabel("Non-members:");
                    nonMemberDropdownPanel.add((Component)nonMemberLabel, "North");
                    JComboBox<Integer> nonMemberDropdown = new JComboBox<Integer>(nonMemberOptions);
                    nonMemberDropdown.setToolTipText("Select # of non-members involved in the drop.");
                    nonMemberDropdown.setPreferredSize(new Dimension(45, 25));
                    nonMemberDropdownPanel.add(nonMemberDropdown, "Center");
                    JButton submitButton = new JButton("Submit");
                    JComboBox<Integer> finalNonMemberDropdown = nonMemberDropdown;
                    submitButton.addActionListener(e -> {
                        List<String> selectedMembersList = membersComboBox.getSelectedItems();
                        String selectedMembersString = String.join((CharSequence)", ", selectedMembersList);
                        int nonMemberCount = (Integer)finalNonMemberDropdown.getSelectedItem();
                        entry.setClanMembers(selectedMembersString);
                        entry.setNonMemberCount(nonMemberCount);
                        this.submitDrop(entry);
                    });
                    submitButton.setPreferredSize(new Dimension(90, 20));
                    submitButton.setAlignmentX(0.5f);
                    submitButton.setAlignmentY(0.5f);
                    JPanel nameMemberPanel = new JPanel();
                    nameMemberPanel.add(nameFieldPanel);
                    nameMemberPanel.add(nonMemberDropdownPanel);
                    JPanel entryPanel = new JPanel();
                    entryPanel.setLayout(new BoxLayout(entryPanel, 1));
                    entryPanel.setAlignmentX(0.0f);
                    entryPanel.setBackground(Color.DARK_GRAY);
                    MatteBorder outerBorder = new MatteBorder(1, 1, 1, 1, Color.BLACK);
                    EmptyBorder innerBorder = new EmptyBorder(0, 0, 10, 0);
                    CompoundBorder compoundBorder = new CompoundBorder(outerBorder, innerBorder);
                    entryPanel.setBorder(compoundBorder);
                    JPanel itemContainer = new JPanel();
                    itemContainer.add(imageLabel);
                    imageLabel.setAlignmentX(0.0f);
                    itemTextLabel.setAlignmentX(0.0f);
                    itemContainer.add(itemTextLabel);
                    entryPanel.add(itemContainer);
                    entryPanel.add(nameMemberPanel);
                    entryPanel.add(submitButton);
                    entryPanel.setAlignmentX(0.0f);
                    entryItemBox.add(entryPanel);
                    this.dropsPanel.add(entryItemBox);
                }
            }
            this.dropsPanel.revalidate();
            this.dropsPanel.repaint();
        });
    }

    public static String formatNumber(double number) {
        if (number == 0.0) {
            return "0";
        }
        String[] units = new String[]{"", "K", "M", "B", "T"};
        int unit = (int)Math.floor(Math.log10(number) / 3.0);
        if (unit >= units.length) {
            unit = units.length - 1;
        }
        double num = number / Math.pow(1000.0, unit);
        DecimalFormat df = new DecimalFormat("#.#");
        String formattedNum = df.format(num);
        return formattedNum + units[unit];
    }

    private void updateTable(String playerLoot, String serverTotal) {
        SwingUtilities.invokeLater(() -> {
            String playerFormattedTotal;
            String serverFormattedTotal;
            String serverName = this.plugin.getServerName(this.config.serverId());
            Integer minimumClanLoot = this.plugin.getServerMinimumLoot(this.config.serverId());
            NumberFormat clanLootFormat = NumberFormat.getNumberInstance();
            String minimumLootString = clanLootFormat.format(minimumClanLoot);
            if (serverTotal.equals("load") && playerLoot.equals("load")) {
                serverFormattedTotal = "<em>unknown</em>";
                playerFormattedTotal = "<em>unknown</em>";
            } else {
                serverFormattedTotal = serverTotal;
                playerFormattedTotal = playerLoot;
            }
            Object[][] data = new String[][]{{"Your Clan: ", serverName}, {"Minimum Value: ", minimumLootString + " gp"}, {"Your total loot: ", playerFormattedTotal, " gp"}, {"Clan Total: ", serverFormattedTotal + " gp"}};
            Object[] columnNames = new String[]{"Key", "Value"};
            DefaultTableModel model = new DefaultTableModel(data, columnNames){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            this.table.setModel(model);
            this.table.setPreferredScrollableViewportSize(new Dimension(500, 70));
            this.table.setFillsViewportHeight(true);
            if (this.table.getColumnModel().getColumnCount() > 0) {
                this.table.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){
                    Font originalFont = null;

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        if (this.originalFont == null) {
                            this.originalFont = c.getFont();
                        }
                        c.setFont(this.originalFont.deriveFont(1));
                        return c;
                    }
                });
            }
            this.table.setModel(model);
            this.table.setPreferredScrollableViewportSize(new Dimension(500, 70));
            this.table.setFillsViewportHeight(true);
        });
    }

    public void addDrop(DropEntry entry) {
        SwingUtilities.invokeLater(() -> {
            this.entries.add(entry);
            if (this.config.showOverlay()) {
                this.plugin.addOverlay();
            }
            this.refreshPanel();
        });
    }

    public void checkAuthKeyAsync(String playerName, String serverId, String authKey, Consumer<String> callback) {
        this.executorService.submit(() -> {
            String finalPlayerName;
            String string = finalPlayerName = !this.config.permPlayerName().equals("") ? this.config.permPlayerName() : playerName;
            if (playerName != null && !serverId.equals("")) {
                String result = this.checkAuthKey(finalPlayerName, serverId, authKey);
                if (result.equals("Authenticated")) {
                    callback.accept("yes");
                } else {
                    callback.accept(result);
                }
            } else {
                callback.accept("invalid parameters");
            }
        });
    }

    public String checkAuthKey(String playerName, String serverId, String authKey) {
        try {
            String line;
            URL url = new URL("https://www.droptracker.io/admin/api/authenticate.php");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setDoOutput(true);
            String message = String.format("player_name=%s&server_id=%s&auth_key=%s", URLEncoder.encode(playerName, StandardCharsets.UTF_8.toString()), URLEncoder.encode(serverId, StandardCharsets.UTF_8.toString()), URLEncoder.encode(authKey, StandardCharsets.UTF_8.toString()));
            connection.getOutputStream().write(message.getBytes(StandardCharsets.UTF_8));
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            reader.close();
            connection.disconnect();
            JsonParser parser = new JsonParser();
            JsonObject jsonResponse = parser.parse(response.toString()).getAsJsonObject();
            if (jsonResponse.has("success")) {
                return "Authenticated";
            }
            if (jsonResponse.has("error")) {
                return jsonResponse.get("error").getAsString();
            }
            return "Unknown response";
        }
        catch (IOException e) {
            e.printStackTrace();
            return "error: " + e.getMessage();
        }
    }

    private void submitDrop(DropEntry entry) {
        SwingUtilities.invokeLater(() -> {
            String itemName = entry.getItemName();
            String playerName = entry.getPlayerName();
            String npcName = entry.getNpcOrEventName();
            int value = entry.getGeValue();
            int itemId = entry.getItemId();
            int npcLevel = entry.getNpcCombatLevel();
            int quantity = entry.getQuantity();
            int nonMembers = entry.getNonMemberCount();
            String imageUrl = entry.getImageLink();
            String memberList = entry.getClanMembers();
            String authKey = this.config.authKey();
            try {
                this.plugin.sendDropData(playerName, npcName, itemId, itemName, memberList, quantity, value, nonMembers, authKey, imageUrl);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.entries.remove(entry);
            if (this.entries.isEmpty()) {
                this.plugin.removeOverlay();
            }
            this.refreshPanel();
        });
    }
}

