/*
 * Decompiled with CFR 0.152.
 */
package com.joelhalen.droptracker;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.joelhalen.droptracker.DropTrackerPlugin;
import com.joelhalen.droptracker.DropTrackerPluginConfig;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.ImageUtil;

public class DropTrackerEventPanel
extends PluginPanel {
    private final JPanel mainPanel;
    @Inject
    private final DropTrackerPlugin plugin;
    private final DropTrackerPluginConfig config;
    private final ItemManager itemManager;
    private JLabel currentTaskLabel;
    private JLabel progressLabel;
    private JLabel descriptionLabel;
    private JTable infoTable;
    private JLabel imageLabel;
    private static final BufferedImage TOP_LOGO = ImageUtil.loadImageResource(DropTrackerPlugin.class, (String)"toplogo-events.png");

    public DropTrackerEventPanel(DropTrackerPlugin plugin, DropTrackerPluginConfig config, ItemManager itemManager, ChatMessageManager chatMessageManager) {
        this.plugin = plugin;
        this.config = config;
        this.itemManager = itemManager;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.mainPanel.setBorder(new EmptyBorder(15, 0, 100, 0));
        this.mainPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.initializePanel();
    }

    private void initializePanel() {
        SwingUtilities.invokeLater(() -> {
            this.removeAll();
            this.setLayout(new BorderLayout());
            JPanel logoPanel = new JPanel();
            logoPanel.setLayout(new BoxLayout(logoPanel, 0));
            logoPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
            ImageIcon logoIcon = new ImageIcon(TOP_LOGO);
            JLabel logoLabel = new JLabel(logoIcon);
            logoPanel.add(Box.createHorizontalGlue());
            logoPanel.add(logoLabel);
            logoPanel.add(Box.createHorizontalGlue());
            this.add(logoPanel, "North");
            JPanel mainContentPanel = new JPanel();
            mainContentPanel.setLayout(new BoxLayout(mainContentPanel, 1));
            mainContentPanel.setBorder(new EmptyBorder(15, 0, 10, 0));
            mainContentPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
            JPanel teamInfoPanel = this.createTeamInfoPanel();
            JPanel tileSectionPanel = this.createTileSectionPanel();
            mainContentPanel.add(teamInfoPanel);
            mainContentPanel.add(tileSectionPanel);
            JButton refreshButton = new JButton("Refresh");
            refreshButton.addActionListener(e -> this.refreshPanel());
            this.add(mainContentPanel, "Center");
            this.add(refreshButton, "South");
            this.revalidate();
            this.repaint();
        });
        this.refreshEventStatus();
    }

    private void updateTeamInfoTable(Map<String, String> eventData) {
        String[] columnNames = new String[]{"Info", "Value"};
        Object[][] newData = new Object[][]{{"<html><b>Your Team</b>:</html>", eventData.getOrDefault("teamName", "N/A")}, {"<html><b>Current Tile</b>:</html>", eventData.getOrDefault("currentTile", "N/A")}, {"<html><b>Points</b>:</html>", eventData.getOrDefault("currentPoints", "N/A")}, {"<html><b>Turn #</b>:</html>", eventData.getOrDefault("currentTurnNumber", "N/A")}, {"<html><b>Members</b>:</html>", eventData.getOrDefault("teamMembers", "N/A")}};
        SwingUtilities.invokeLater(() -> {
            DefaultTableModel model = new DefaultTableModel(newData, columnNames);
            this.infoTable.setModel(model);
        });
    }

    private void updateTileSectionPanel(Map<String, String> eventData) {
        SwingUtilities.invokeLater(() -> {
            String currentTask = eventData.getOrDefault("currentTask", "N/A");
            this.currentTaskLabel.setText(currentTask);
            String required_amount = eventData.getOrDefault("currentTaskAmt", "1");
            this.descriptionLabel.setText("<html>" + (String)((Object)eventData.getOrDefault("currentTaskDescription", "Obtain" + required_amount + " x " + currentTask + ".")) + "</html>");
            this.progressLabel.setText("<html><b>Status</b>: " + eventData.getOrDefault("currentTaskProgress", "N/A") + "/" + required_amount + ".</html>");
            try {
                this.imageLabel.setIcon(new ImageIcon(new URL(eventData.getOrDefault("currentTaskImage", "https://www.droptracker.io/img/dt-logo.png"))));
                this.imageLabel.setPreferredSize(new Dimension(50, 60));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void refreshEventStatus() {
        this.fetchEventStatus().thenAccept(eventData -> SwingUtilities.invokeLater(() -> {
            this.updateTeamInfoTable((Map<String, String>)eventData);
            this.updateTileSectionPanel((Map<String, String>)eventData);
        }));
    }

    private JPanel createTeamInfoPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel teamIconLabel = new JLabel(new ImageIcon("path/to/team/icon"));
        panel.add((Component)teamIconLabel, "West");
        Object[] columnNames = new String[]{"Info", "Value"};
        Object[][] data = new Object[][]{{"<html><b>Your Team</b>:</html>", "Zaros"}, {"<html><b>Current Tile</b>:</html>", "5"}, {"<html><b>Points</b>:</html>", "6"}, {"<html><b>Turn #</b>:</html>", "2"}, {"<html><b>Members</b>:</html>", "1"}};
        this.infoTable = new JTable(data, columnNames);
        this.infoTable.setPreferredScrollableViewportSize(new Dimension(250, 100));
        this.infoTable.setFillsViewportHeight(true);
        this.infoTable.setEnabled(false);
        this.infoTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (column == 0) {
                    c.setForeground(Color.WHITE);
                } else {
                    c.setForeground(table.getForeground());
                }
                return c;
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.infoTable);
        panel.add((Component)scrollPane, "Center");
        return panel;
    }

    public CompletableFuture<Map<String, String>> fetchEventStatus() {
        return CompletableFuture.supplyAsync(() -> {
            Long discordServerId = Long.valueOf(this.config.serverId());
            HashMap<String, String> eventData = new HashMap<String, String>();
            try {
                String line;
                String playerName = this.plugin.getPlayerName();
                playerName = URLEncoder.encode(playerName, StandardCharsets.UTF_8.toString());
                URL url = new URL("https://www.droptracker.io/admin/api/events/get_current_status.php?" + discordServerId + "&player_name=" + playerName);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder builder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    builder.append(line);
                }
                reader.close();
                JsonParser parser = new JsonParser();
                JsonObject jsonResponse = parser.parse(builder.toString()).getAsJsonObject();
                String value = jsonResponse.get("key").getAsString();
                eventData.put("currentTile", jsonResponse.get("team_current_tile").getAsString());
                eventData.put("teamName", jsonResponse.get("team_name").getAsString());
                eventData.put("currentPoints", jsonResponse.get("team_current_points").getAsString());
                eventData.put("currentTask", jsonResponse.get("current_task_string").getAsString());
                eventData.put("currentTaskDescription", jsonResponse.get("current_task_description").getAsString());
                eventData.put("currentPlayerPoints", jsonResponse.get("current_player_points").getAsString());
                eventData.put("teamMembers", jsonResponse.get("current_team_members").getAsString());
                eventData.put("currentTaskAmt", jsonResponse.get("current_task_quantity_required").getAsString());
                eventData.put("currentTaskProgress", jsonResponse.get("current_task_progress").getAsString());
                eventData.put("currentTaskItemsObtained", jsonResponse.get("current_task_items_obtained").getAsString());
                eventData.put("currentTurnNumber", jsonResponse.get("current_turn_number").getAsString());
                eventData.put("teamRank", jsonResponse.get("team_current_placement").getAsString());
                eventData.put("allTeamLocations", jsonResponse.get("all_team_locations").getAsString());
                eventData.put("currentEffects", jsonResponse.get("current_effects").getAsString());
                eventData.put("currentTaskImage", jsonResponse.get("current_task_image").getAsString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return eventData;
        });
    }

    private JPanel createTileSectionPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        AsyncBufferedImage itemImage = this.itemManager.getImage(20997);
        this.imageLabel = new JLabel(new ImageIcon((Image)itemImage));
        JPanel tilePanel = this.createTilePanel(this.imageLabel);
        panel.add((Component)tilePanel, "West");
        JLabel currentTaskTitleLabel = new JLabel("Current Task");
        this.progressLabel = new JLabel("<html><b>Status</b>: 0/1</html>");
        JPanel currentTaskTextPanel = new JPanel();
        currentTaskTextPanel.setLayout(new BoxLayout(currentTaskTextPanel, 1));
        currentTaskTextPanel.add((Component)currentTaskTitleLabel, "Center");
        panel.add((Component)currentTaskTextPanel, "Center");
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BoxLayout(textPanel, 1));
        textPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.currentTaskLabel = new JLabel("Unknown...");
        this.currentTaskLabel.setFont(new Font("Arial", 0, 12));
        this.descriptionLabel = new JLabel("<html><i>Your task could not be loaded...</i></html>");
        this.descriptionLabel.setFont(new Font("Arial", 0, 10));
        this.progressLabel = new JLabel("<html>Please try again later.</html>");
        this.progressLabel.setFont(new Font("Arial", 0, 11));
        textPanel.add(this.currentTaskLabel);
        textPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        textPanel.add(this.descriptionLabel);
        textPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        textPanel.add(this.progressLabel);
        panel.add((Component)textPanel, "Center");
        return panel;
    }

    private JPanel createTilePanel(JLabel imageLabel) {
        int padding = 10;
        int tileWidth = imageLabel.getIcon().getIconWidth() + 2 * padding;
        int tileHeight = imageLabel.getIcon().getIconHeight() + 2 * padding;
        JPanel tilePanel = new JPanel();
        tilePanel.setPreferredSize(new Dimension(tileWidth, tileHeight));
        tilePanel.setBackground(Color.GRAY);
        tilePanel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        tilePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        tilePanel.add((Component)imageLabel, gbc);
        return tilePanel;
    }

    void refreshPanel() {
        SwingUtilities.invokeLater(() -> {
            this.refreshEventStatus();
            this.mainPanel.removeAll();
            this.remove(this.mainPanel);
            this.initializePanel();
            this.mainPanel.revalidate();
            this.mainPanel.repaint();
        });
    }
}

