/*
 * Decompiled with CFR 0.152.
 */
package com.onetickflick;

import com.google.inject.Provides;
import com.onetickflick.OneTickFlickPluginConfiguration;
import java.util.Timer;
import java.util.TimerTask;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Preferences;
import net.runelite.api.events.GameTick;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;

@PluginDescriptor(name="One Tick Flick Metronome", description="A metronome timed specifically to aid with one tick prayer flicking.", tags={"tick", "timers"}, enabledByDefault=false)
public class OneTickFlickPlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private OneTickFlickPluginConfiguration config;
    @Inject
    private ClientThread clientThread;
    private long tickDelayMS = 85L;
    private long tockDelayMS = 515L;
    private Timer tickTimer = new Timer("Tick Timer");
    private Timer tockTimer = new Timer("Tock Timer");

    @Provides
    OneTickFlickPluginConfiguration provideConfig(ConfigManager configManager) {
        return (OneTickFlickPluginConfiguration)configManager.getConfig(OneTickFlickPluginConfiguration.class);
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        final Preferences preferences = this.client.getPreferences();
        TimerTask delayedTick = new TimerTask(){

            @Override
            public void run() {
                int previousVolume = preferences.getSoundEffectVolume();
                preferences.setSoundEffectVolume(OneTickFlickPlugin.this.config.tickVolume());
                OneTickFlickPlugin.this.clientThread.invoke(() -> OneTickFlickPlugin.this.client.playSoundEffect(3929, OneTickFlickPlugin.this.config.tickVolume()));
                preferences.setSoundEffectVolume(previousVolume);
            }
        };
        TimerTask delayedTock = new TimerTask(){

            @Override
            public void run() {
                int previousVolume = preferences.getSoundEffectVolume();
                preferences.setSoundEffectVolume(OneTickFlickPlugin.this.config.tockVolume());
                OneTickFlickPlugin.this.clientThread.invoke(() -> OneTickFlickPlugin.this.client.playSoundEffect(3930, OneTickFlickPlugin.this.config.tockVolume()));
                preferences.setSoundEffectVolume(previousVolume);
            }
        };
        this.tickTimer.schedule(delayedTick, this.tickDelayMS);
        this.tockTimer.schedule(delayedTock, this.tockDelayMS);
    }
}

