/*
 * Decompiled with CFR 0.152.
 */
package com.discordchatlogger;

import com.discordchatlogger.DiscordChatLoggerConfig;
import com.discordchatlogger.WebhookBody;
import com.google.common.base.Strings;
import com.google.inject.Provides;
import java.io.IOException;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Discord Chat Logger")
public class DiscordChatLoggerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(DiscordChatLoggerPlugin.class);
    @Inject
    private DiscordChatLoggerConfig config;
    @Inject
    private ItemManager itemManager;
    @Inject
    private OkHttpClient okHttpClient;
    @Inject
    private Client client;

    protected void startUp() {
    }

    protected void shutDown() {
    }

    @Provides
    DiscordChatLoggerConfig provideConfig(ConfigManager configManager) {
        return (DiscordChatLoggerConfig)configManager.getConfig(DiscordChatLoggerConfig.class);
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getType() == ChatMessageType.GAMEMESSAGE || chatMessage.getType() == ChatMessageType.SPAM) {
            return;
        }
        String sender = chatMessage.getName().replaceAll("\\<.*?>", "").replaceAll("[^0-9a-zA-Z ]+", " ");
        String inputMessage = chatMessage.getMessage();
        String outputMessage = Text.removeTags((String)inputMessage);
        if ((chatMessage.getType() == ChatMessageType.PRIVATECHATOUT || chatMessage.getType() == ChatMessageType.PRIVATECHAT) && this.config.usePrivate()) {
            String receiver;
            if (chatMessage.getType() == ChatMessageType.PRIVATECHATOUT && this.config.logSelf()) {
                receiver = sender;
                sender = this.getPlayerName();
                this.processPrivate(outputMessage, sender, receiver);
            }
            if (chatMessage.getType() == ChatMessageType.PRIVATECHAT && this.config.logOthers()) {
                receiver = this.getPlayerName();
                this.processPrivate(outputMessage, sender, receiver);
            }
        }
        if (chatMessage.getType() == ChatMessageType.CLAN_GIM_CHAT) {
            String groupName = chatMessage.getSender().replaceAll("\\<.*?>", "").replaceAll("[^0-9a-zA-Z ]+", " ");
            if (this.config.useGroup() && (sender.equals(this.getPlayerName()) && this.config.logSelf() || !sender.equals(this.getPlayerName()) && this.config.logOthers())) {
                this.processGroup(outputMessage, sender, groupName);
            }
        }
    }

    private String getPlayerName() {
        return this.client.getLocalPlayer().getName();
    }

    private void processPrivate(String outputText, String senderName, String receiverName) {
        WebhookBody webhookBody = new WebhookBody();
        StringBuilder stringBuilder = new StringBuilder();
        if (this.config.includeOtherUsername()) {
            if (senderName.equals(this.getPlayerName())) {
                stringBuilder.append("To **").append(receiverName).append("**").append(" : ");
            }
            if (receiverName.equals(this.getPlayerName())) {
                stringBuilder.append("From **").append(senderName).append("**").append(" : ");
            }
        }
        stringBuilder.append(outputText);
        webhookBody.setContent(stringBuilder.toString());
        this.sendWebhookPrivate(webhookBody);
    }

    private void sendWebhookPrivate(WebhookBody webhookBody) {
        String configUrl = this.config.webhookPrivate();
        if (Strings.isNullOrEmpty((String)configUrl)) {
            return;
        }
        HttpUrl url = HttpUrl.parse((String)configUrl);
        MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("payload_json", RuneLiteAPI.GSON.toJson((Object)webhookBody));
        this.buildRequestAndSend(url, requestBodyBuilder);
    }

    private void processGroup(String outputText, String senderName, String groupName) {
        WebhookBody webhookBody = new WebhookBody();
        StringBuilder stringBuilder = new StringBuilder();
        if (this.config.useGroupName()) {
            stringBuilder.append("**[").append(groupName).append("]** ");
        }
        if (senderName.equals(this.getPlayerName()) && this.config.includeUsername() || !senderName.equals(this.getPlayerName()) && this.config.includeOtherUsername()) {
            stringBuilder.append("**").append(senderName).append("**").append(" : ");
        }
        stringBuilder.append(outputText);
        webhookBody.setContent(stringBuilder.toString());
        this.sendWebhookGroup(webhookBody);
    }

    private void sendWebhookGroup(WebhookBody webhookBody) {
        String configUrl = this.config.webhookGroup();
        if (Strings.isNullOrEmpty((String)configUrl)) {
            return;
        }
        HttpUrl url = HttpUrl.parse((String)configUrl);
        MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("payload_json", RuneLiteAPI.GSON.toJson((Object)webhookBody));
        this.buildRequestAndSend(url, requestBodyBuilder);
    }

    private void buildRequestAndSend(HttpUrl url, MultipartBody.Builder requestBodyBuilder) {
        MultipartBody requestBody = requestBodyBuilder.build();
        Request request = new Request.Builder().url(url).post((RequestBody)requestBody).build();
        this.sendRequest(request);
    }

    private void sendRequest(Request request) {
        this.okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                log.debug("Error submitting webhook", (Throwable)e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                response.close();
            }
        });
    }
}

