/*
 * Decompiled with CFR 0.152.
 */
package com.discordchatlogger;

import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;

@ConfigGroup(value="discordchatlogger")
public interface DiscordChatLoggerConfig
extends Config {
    public static final String GROUP = "discordchatlogger";
    @ConfigSection(name="Private", description="Options for private message logging", position=100)
    public static final String privateOptions = "privateOptions";
    @ConfigSection(name="Group", description="Options for group message logging", position=200)
    public static final String groupOptions = "groupOptions";
    @ConfigSection(name="Logging", description="General options for logging", position=300)
    public static final String loggingOptions = "logginOptions";

    @ConfigItem(keyName="useprivate", name="Send Private Messages", description="Send private messages to discord webhook", position=1, section="privateOptions")
    default public boolean usePrivate() {
        return false;
    }

    @ConfigItem(keyName="webhookprivate", name="Webhook URL", description="The Discord Webhook URL for private messages", position=2, section="privateOptions")
    public String webhookPrivate();

    @ConfigItem(keyName="usegroup", name="Send Group Messages", description="Send group messages to discord webhook", position=1, section="groupOptions")
    default public boolean useGroup() {
        return false;
    }

    @ConfigItem(keyName="webhookgroup", name="Webhook URL", description="Send group messages to discord webhook", position=2, section="groupOptions")
    public String webhookGroup();

    @ConfigItem(keyName="usegroupname", name="Include Group Name", description="Include group name in discord message", position=3, section="groupOptions")
    default public boolean useGroupName() {
        return true;
    }

    @ConfigItem(keyName="logself", name="Log Self", description="Include messages sent", position=1, section="logginOptions")
    default public boolean logSelf() {
        return true;
    }

    @ConfigItem(keyName="logOthers", name="Log Others", description="Include messages received", position=2, section="logginOptions")
    default public boolean logOthers() {
        return true;
    }

    @ConfigItem(keyName="includeusername", name="Include Username", description="Include own RSN in the post", position=3, section="logginOptions")
    default public boolean includeUsername() {
        return true;
    }

    @ConfigItem(keyName="includeotherusername", name="Include Other's Username", description="Include Other's RSN in the post", position=4, section="logginOptions")
    default public boolean includeOtherUsername() {
        return true;
    }
}

