/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.util;

import java.time.Duration;
import java.time.LocalTime;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.runelite.api.Client;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class TimeUtils {
    private static final Pattern TIME_PATTERN = Pattern.compile("\\b(?:(?<hours>\\d+):)?(?<minutes>\\d+):(?<seconds>\\d{2})(?:\\.(?<fractional>\\d{2}))?\\b");
    @VisibleForTesting
    public static final int ENABLE_PRECISE_TIMING = 11866;

    public static boolean isPreciseTiming(@NotNull Client client) {
        return client.getVarbitValue(11866) > 0;
    }

    @NotNull
    public static Duration parseTime(@NotNull String in) {
        String fractional;
        Matcher m = TIME_PATTERN.matcher(in);
        if (!m.find()) {
            return Duration.ZERO;
        }
        int minutes = Integer.parseInt(m.group("minutes"));
        int seconds = Integer.parseInt(m.group("seconds"));
        Duration d = Duration.ofMinutes(minutes).plusSeconds(seconds);
        String hours = m.group("hours");
        if (hours != null) {
            d = d.plusHours(Integer.parseInt(hours));
        }
        if ((fractional = m.group("fractional")) != null) {
            String f = fractional.length() < 3 ? StringUtils.rightPad((String)fractional, (int)3, (char)'0') : fractional.substring(0, 3);
            d = d.plusMillis(Integer.parseInt(f));
        }
        return d;
    }

    @NotNull
    public static String format(@Nullable Duration duration, boolean precise) {
        Temporal time = ((Duration)ObjectUtils.defaultIfNull((Object)duration, (Object)Duration.ZERO)).addTo(LocalTime.of(0, 0));
        StringBuilder sb = new StringBuilder();
        int h = time.get(ChronoField.HOUR_OF_DAY);
        if (h > 0) {
            sb.append(String.format("%02d", h)).append(':');
        }
        sb.append(String.format("%02d", time.get(ChronoField.MINUTE_OF_HOUR))).append(':');
        sb.append(String.format("%02d", time.get(ChronoField.SECOND_OF_MINUTE)));
        if (precise) {
            sb.append('.').append(String.format("%02d", time.get(ChronoField.MILLI_OF_SECOND) / 10));
        }
        return sb.toString();
    }

    private TimeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

