/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.util;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QuestUtils {
    private static final Logger log = LoggerFactory.getLogger(QuestUtils.class);
    private static final Pattern QUEST_PATTERN_1 = Pattern.compile(".+?ve\\.*? (?<verb>been|rebuilt|.+?ed)? ?(?:the )?'?(?<quest>.+?)'?(?: [Qq]uest)?[!.]?$");
    private static final Pattern QUEST_PATTERN_2 = Pattern.compile("'?(?<quest>.+?)'?(?: [Qq]uest)? (?<verb>[a-z]\\w+?ed)?(?: f.*?)?[!.]?$");
    private static final Collection<String> RFD_TAGS = ImmutableList.of((Object)"Another Cook", (Object)"freed", (Object)"defeated", (Object)"saved");
    private static final Collection<String> WORD_QUEST_IN_NAME_TAGS = ImmutableList.of((Object)"Another Cook", (Object)"Doric", (Object)"Heroes", (Object)"Legends", (Object)"Observatory", (Object)"Olaf", (Object)"Waterfall");
    private static final Map<String, String> QUEST_REPLACEMENTS = Map.of("Lumbridge Cook... again", "Another Cook's", "Skrach 'Bone Crusher' Uglogwee", "Skrach Uglogwee");

    @Nullable
    public static String parseQuestWidget(String text) {
        Matcher matcher = QuestUtils.getMatcher(text);
        if (matcher == null) {
            log.warn("Unable to match quest: {}", (Object)text);
            return null;
        }
        Object quest = matcher.group("quest");
        quest = QUEST_REPLACEMENTS.getOrDefault(quest, (String)quest);
        String verb = StringUtils.defaultString((String)matcher.group("verb"));
        if (verb.contains("kind of")) {
            log.debug("Skipping partial completion of quest: {}", quest);
            return null;
        }
        if (verb.contains("completely")) {
            quest = (String)quest + " II";
        }
        if (RFD_TAGS.stream().anyMatch(((String)quest + verb)::contains)) {
            quest = "Recipe for Disaster - " + (String)quest;
        }
        if (WORD_QUEST_IN_NAME_TAGS.stream().anyMatch(((String)quest)::contains)) {
            quest = (String)quest + " Quest";
        }
        return quest;
    }

    @Nullable
    private static Matcher getMatcher(String text) {
        if (text == null) {
            return null;
        }
        Matcher questMatch1 = QUEST_PATTERN_1.matcher(text);
        if (questMatch1.matches()) {
            return questMatch1;
        }
        Matcher questMatch2 = QUEST_PATTERN_2.matcher(text);
        if (questMatch2.matches()) {
            return questMatch2;
        }
        return null;
    }

    private QuestUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

