/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.util;

import com.google.common.collect.ImmutableSet;
import dinkplugin.message.Embed;
import dinkplugin.message.Field;
import dinkplugin.message.templating.Evaluable;
import dinkplugin.message.templating.Replacements;
import dinkplugin.notifiers.data.SerializedItemStack;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.ItemStack;
import net.runelite.client.util.QuantityFormatter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemUtils {
    static final String ITEM_CACHE_BASE_URL = "https://static.runelite.net/cache/item/";
    private static final Set<Integer> NEVER_KEPT_ITEMS = ImmutableSet.of((Object)12789, (Object)11941, (Object)12853, (Object)12851, (Object)21816, (Object)21817, (Object[])new Integer[]{10499, 10498, 7409, 10836, 10837, 10838, 10839, 9096, 9097, 9098, 9099, 9100, 9101, 9102, 9104, 9084, 26511, 26503, 26515, 26505, 26509, 26513, 26507, 25046, 25054, 25042, 25052, 25048, 25044, 25050, 24376, 24384, 24372, 24382, 24378, 24374, 24380});
    private static final BinaryOperator<Item> SUM_ITEM_QUANTITIES = (a, b) -> new Item(a.getId(), a.getQuantity() + b.getQuantity());
    private static final BinaryOperator<ItemStack> SUM_ITEM_STACK_QUANTITIES = (a, b) -> new ItemStack(a.getId(), a.getQuantity() + b.getQuantity(), a.getLocation());

    public static boolean isItemNeverKeptOnDeath(int itemId) {
        return NEVER_KEPT_ITEMS.contains(itemId);
    }

    public static long getPrice(@NotNull ItemManager itemManager, int itemId) {
        return ItemUtils.getPrice(itemManager, itemId, null);
    }

    private static int getPrice(@NotNull ItemManager itemManager, int itemId, @Nullable ItemComposition item) {
        int price = itemManager.getItemPrice(itemId);
        if (price <= 0) {
            ItemComposition ic = item != null ? item : itemManager.getItemComposition(itemId);
            price = ic.getPrice();
        }
        return price;
    }

    public static long getTotalPrice(@NotNull Iterable<SerializedItemStack> items) {
        long sum = 0L;
        for (SerializedItemStack item : items) {
            sum += item.getTotalPrice();
        }
        return sum;
    }

    public static Collection<Item> getItems(Client client) {
        return Stream.of(InventoryID.INVENTORY, InventoryID.EQUIPMENT).map(arg_0 -> ((Client)client).getItemContainer(arg_0)).filter(Objects::nonNull).map(ItemContainer::getItems).flatMap(Arrays::stream).filter(Objects::nonNull).filter(item -> item.getId() >= 0).collect(Collectors.toList());
    }

    public static <K, V> Map<K, V> reduce(@NotNull Iterable<V> items, Function<V, K> deriveKey, BinaryOperator<V> aggregate) {
        LinkedHashMap map = new LinkedHashMap();
        items.forEach(v -> map.merge(deriveKey.apply(v), v, aggregate));
        return map;
    }

    public static Map<Integer, Item> reduceItems(@NotNull Iterable<Item> items) {
        return ItemUtils.reduce(items, Item::getId, SUM_ITEM_QUANTITIES);
    }

    @NotNull
    public static Collection<ItemStack> reduceItemStack(@NotNull Iterable<ItemStack> items) {
        return ItemUtils.reduce(items, ItemStack::getId, SUM_ITEM_STACK_QUANTITIES).values();
    }

    public static SerializedItemStack stackFromItem(ItemManager itemManager, Item item) {
        return ItemUtils.stackFromItem(itemManager, item.getId(), item.getQuantity());
    }

    public static SerializedItemStack stackFromItem(ItemManager itemManager, int id, int quantity) {
        ItemComposition composition = itemManager.getItemComposition(id);
        int price = ItemUtils.getPrice(itemManager, id, composition);
        return new SerializedItemStack(id, quantity, price, String.valueOf(composition.getMembersName()));
    }

    public static String formatStack(SerializedItemStack item, boolean includePrice) {
        if (includePrice) {
            return String.format("%d x %s (%s)", item.getQuantity(), item.getName(), QuantityFormatter.quantityToStackSize((long)item.getTotalPrice()));
        }
        return String.format("%d x %s", item.getQuantity(), item.getName());
    }

    public static Evaluable templateStack(SerializedItemStack item, boolean includePrice) {
        if (includePrice) {
            return Replacements.ofMultiple("", Replacements.ofText(String.valueOf(item.getQuantity())), Replacements.ofText(" x "), Replacements.ofWiki(item.getName()), Replacements.ofText(" (" + QuantityFormatter.quantityToStackSize((long)item.getTotalPrice()) + ")"));
        }
        return Replacements.ofMultiple("", Replacements.ofText(String.valueOf(item.getQuantity())), Replacements.ofText(" x "), Replacements.ofWiki(item.getName()));
    }

    public static String getItemImageUrl(int itemId) {
        return "https://static.runelite.net/cache/item/icon/" + itemId + ".png";
    }

    public static String getNpcImageUrl(int npcId) {
        return String.format("https://chisel.weirdgloop.org/static/img/osrs-npc/%d_128.png", npcId);
    }

    public static List<Embed> buildEmbeds(int[] itemIds) {
        return Arrays.stream(itemIds).mapToObj(ItemUtils::getItemImageUrl).map(Embed::ofImage).collect(Collectors.toList());
    }

    public static String formatGold(long amount) {
        return Field.formatBlock("ldif", QuantityFormatter.quantityToStackSize((long)amount) + " gp");
    }

    private ItemUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

