/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.notifiers.data;

import dinkplugin.message.Field;
import dinkplugin.notifiers.data.NotificationData;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class QuestNotificationData
extends NotificationData {
    @NotNull
    private final String questName;
    @Nullable
    private final Integer completedQuests;
    @Nullable
    private final Integer totalQuests;
    @Nullable
    private final Integer questPoints;
    @Nullable
    private final Integer totalQuestPoints;

    @Override
    public List<Field> getFields() {
        ArrayList<Field> fields = new ArrayList<Field>(2);
        if (this.completedQuests != null && this.totalQuests != null) {
            fields.add(new Field("Completed Quests", Field.formatProgress(this.completedQuests, this.totalQuests)));
        }
        if (this.questPoints != null && this.totalQuestPoints != null) {
            fields.add(new Field("Quest Points", Field.formatProgress(this.questPoints, this.totalQuestPoints)));
        }
        return fields;
    }

    public QuestNotificationData(@NotNull String questName, @Nullable Integer completedQuests, @Nullable Integer totalQuests, @Nullable Integer questPoints, @Nullable Integer totalQuestPoints) {
        if (questName == null) {
            throw new NullPointerException("questName is marked non-null but is null");
        }
        this.questName = questName;
        this.completedQuests = completedQuests;
        this.totalQuests = totalQuests;
        this.questPoints = questPoints;
        this.totalQuestPoints = totalQuestPoints;
    }

    @NotNull
    public String getQuestName() {
        return this.questName;
    }

    @Nullable
    public Integer getCompletedQuests() {
        return this.completedQuests;
    }

    @Nullable
    public Integer getTotalQuests() {
        return this.totalQuests;
    }

    @Nullable
    public Integer getQuestPoints() {
        return this.questPoints;
    }

    @Nullable
    public Integer getTotalQuestPoints() {
        return this.totalQuestPoints;
    }

    public String toString() {
        return "QuestNotificationData(questName=" + this.getQuestName() + ", completedQuests=" + this.getCompletedQuests() + ", totalQuests=" + this.getTotalQuests() + ", questPoints=" + this.getQuestPoints() + ", totalQuestPoints=" + this.getTotalQuestPoints() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuestNotificationData)) {
            return false;
        }
        QuestNotificationData other = (QuestNotificationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$completedQuests = this.getCompletedQuests();
        Integer other$completedQuests = other.getCompletedQuests();
        if (this$completedQuests == null ? other$completedQuests != null : !((Object)this$completedQuests).equals(other$completedQuests)) {
            return false;
        }
        Integer this$totalQuests = this.getTotalQuests();
        Integer other$totalQuests = other.getTotalQuests();
        if (this$totalQuests == null ? other$totalQuests != null : !((Object)this$totalQuests).equals(other$totalQuests)) {
            return false;
        }
        Integer this$questPoints = this.getQuestPoints();
        Integer other$questPoints = other.getQuestPoints();
        if (this$questPoints == null ? other$questPoints != null : !((Object)this$questPoints).equals(other$questPoints)) {
            return false;
        }
        Integer this$totalQuestPoints = this.getTotalQuestPoints();
        Integer other$totalQuestPoints = other.getTotalQuestPoints();
        if (this$totalQuestPoints == null ? other$totalQuestPoints != null : !((Object)this$totalQuestPoints).equals(other$totalQuestPoints)) {
            return false;
        }
        String this$questName = this.getQuestName();
        String other$questName = other.getQuestName();
        return !(this$questName == null ? other$questName != null : !this$questName.equals(other$questName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QuestNotificationData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $completedQuests = this.getCompletedQuests();
        result = result * 59 + ($completedQuests == null ? 43 : ((Object)$completedQuests).hashCode());
        Integer $totalQuests = this.getTotalQuests();
        result = result * 59 + ($totalQuests == null ? 43 : ((Object)$totalQuests).hashCode());
        Integer $questPoints = this.getQuestPoints();
        result = result * 59 + ($questPoints == null ? 43 : ((Object)$questPoints).hashCode());
        Integer $totalQuestPoints = this.getTotalQuestPoints();
        result = result * 59 + ($totalQuestPoints == null ? 43 : ((Object)$totalQuestPoints).hashCode());
        String $questName = this.getQuestName();
        result = result * 59 + ($questName == null ? 43 : $questName.hashCode());
        return result;
    }
}

