/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.notifiers.data;

import dinkplugin.message.Field;
import dinkplugin.notifiers.data.NotificationData;
import dinkplugin.notifiers.data.SerializedItemStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.kit.KitType;
import org.jetbrains.annotations.Nullable;

public final class PlayerKillNotificationData
extends NotificationData {
    private final String victimName;
    private final int victimCombatLevel;
    private final Map<KitType, SerializedItemStack> victimEquipment;
    @Nullable
    private final Integer world;
    @Nullable
    private final WorldPoint location;
    private final int myHitpoints;
    private final int myLastDamage;

    @Override
    public List<Field> getFields() {
        if (this.location == null) {
            return super.getFields();
        }
        ArrayList<Field> fields = new ArrayList<Field>(2);
        fields.add(new Field("World", Field.formatBlock("", String.valueOf(this.world))));
        fields.add(new Field("Location", Field.formatBlock("", String.format("X: %d, Y: %d, Plane: %d", this.location.getX(), this.location.getY(), this.location.getPlane()))));
        return fields;
    }

    public PlayerKillNotificationData(String victimName, int victimCombatLevel, Map<KitType, SerializedItemStack> victimEquipment, @Nullable Integer world, @Nullable WorldPoint location, int myHitpoints, int myLastDamage) {
        this.victimName = victimName;
        this.victimCombatLevel = victimCombatLevel;
        this.victimEquipment = victimEquipment;
        this.world = world;
        this.location = location;
        this.myHitpoints = myHitpoints;
        this.myLastDamage = myLastDamage;
    }

    public String getVictimName() {
        return this.victimName;
    }

    public int getVictimCombatLevel() {
        return this.victimCombatLevel;
    }

    public Map<KitType, SerializedItemStack> getVictimEquipment() {
        return this.victimEquipment;
    }

    @Nullable
    public Integer getWorld() {
        return this.world;
    }

    @Nullable
    public WorldPoint getLocation() {
        return this.location;
    }

    public int getMyHitpoints() {
        return this.myHitpoints;
    }

    public int getMyLastDamage() {
        return this.myLastDamage;
    }

    public String toString() {
        return "PlayerKillNotificationData(victimName=" + this.getVictimName() + ", victimCombatLevel=" + this.getVictimCombatLevel() + ", victimEquipment=" + this.getVictimEquipment() + ", world=" + this.getWorld() + ", location=" + this.getLocation() + ", myHitpoints=" + this.getMyHitpoints() + ", myLastDamage=" + this.getMyLastDamage() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerKillNotificationData)) {
            return false;
        }
        PlayerKillNotificationData other = (PlayerKillNotificationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getVictimCombatLevel() != other.getVictimCombatLevel()) {
            return false;
        }
        if (this.getMyHitpoints() != other.getMyHitpoints()) {
            return false;
        }
        if (this.getMyLastDamage() != other.getMyLastDamage()) {
            return false;
        }
        Integer this$world = this.getWorld();
        Integer other$world = other.getWorld();
        if (this$world == null ? other$world != null : !((Object)this$world).equals(other$world)) {
            return false;
        }
        String this$victimName = this.getVictimName();
        String other$victimName = other.getVictimName();
        if (this$victimName == null ? other$victimName != null : !this$victimName.equals(other$victimName)) {
            return false;
        }
        Map<KitType, SerializedItemStack> this$victimEquipment = this.getVictimEquipment();
        Map<KitType, SerializedItemStack> other$victimEquipment = other.getVictimEquipment();
        if (this$victimEquipment == null ? other$victimEquipment != null : !((Object)this$victimEquipment).equals(other$victimEquipment)) {
            return false;
        }
        WorldPoint this$location = this.getLocation();
        WorldPoint other$location = other.getLocation();
        return !(this$location == null ? other$location != null : !this$location.equals(other$location));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlayerKillNotificationData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getVictimCombatLevel();
        result = result * 59 + this.getMyHitpoints();
        result = result * 59 + this.getMyLastDamage();
        Integer $world = this.getWorld();
        result = result * 59 + ($world == null ? 43 : ((Object)$world).hashCode());
        String $victimName = this.getVictimName();
        result = result * 59 + ($victimName == null ? 43 : $victimName.hashCode());
        Map<KitType, SerializedItemStack> $victimEquipment = this.getVictimEquipment();
        result = result * 59 + ($victimEquipment == null ? 43 : ((Object)$victimEquipment).hashCode());
        WorldPoint $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : $location.hashCode());
        return result;
    }
}

