/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.notifiers.data;

import dinkplugin.message.Field;
import dinkplugin.notifiers.data.NotificationData;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class PetNotificationData
extends NotificationData {
    @Nullable
    private final String petName;
    @Nullable
    private final String milestone;
    private final boolean duplicate;
    @Nullable
    private final Boolean previouslyOwned;

    @Override
    public List<Field> getFields() {
        if (this.petName == null || this.petName.isEmpty()) {
            return super.getFields();
        }
        ArrayList<Field> fields = new ArrayList<Field>(3);
        fields.add(new Field("Name", Field.formatBlock("", this.petName)));
        String status = this.getStatus();
        if (status != null) {
            fields.add(new Field("Status", Field.formatBlock("", status)));
        }
        if (this.milestone != null) {
            fields.add(new Field("Milestone", Field.formatBlock("", this.milestone)));
        }
        return fields;
    }

    private String getStatus() {
        if (this.duplicate) {
            return "Already owned";
        }
        if (this.previouslyOwned == null) {
            return null;
        }
        return this.previouslyOwned != false ? "Previously owned" : "New!";
    }

    public PetNotificationData(@Nullable String petName, @Nullable String milestone, boolean duplicate, @Nullable Boolean previouslyOwned) {
        this.petName = petName;
        this.milestone = milestone;
        this.duplicate = duplicate;
        this.previouslyOwned = previouslyOwned;
    }

    @Nullable
    public String getPetName() {
        return this.petName;
    }

    @Nullable
    public String getMilestone() {
        return this.milestone;
    }

    public boolean isDuplicate() {
        return this.duplicate;
    }

    @Nullable
    public Boolean getPreviouslyOwned() {
        return this.previouslyOwned;
    }

    public String toString() {
        return "PetNotificationData(petName=" + this.getPetName() + ", milestone=" + this.getMilestone() + ", duplicate=" + this.isDuplicate() + ", previouslyOwned=" + this.getPreviouslyOwned() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PetNotificationData)) {
            return false;
        }
        PetNotificationData other = (PetNotificationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDuplicate() != other.isDuplicate()) {
            return false;
        }
        Boolean this$previouslyOwned = this.getPreviouslyOwned();
        Boolean other$previouslyOwned = other.getPreviouslyOwned();
        if (this$previouslyOwned == null ? other$previouslyOwned != null : !((Object)this$previouslyOwned).equals(other$previouslyOwned)) {
            return false;
        }
        String this$petName = this.getPetName();
        String other$petName = other.getPetName();
        if (this$petName == null ? other$petName != null : !this$petName.equals(other$petName)) {
            return false;
        }
        String this$milestone = this.getMilestone();
        String other$milestone = other.getMilestone();
        return !(this$milestone == null ? other$milestone != null : !this$milestone.equals(other$milestone));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PetNotificationData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDuplicate() ? 79 : 97);
        Boolean $previouslyOwned = this.getPreviouslyOwned();
        result = result * 59 + ($previouslyOwned == null ? 43 : ((Object)$previouslyOwned).hashCode());
        String $petName = this.getPetName();
        result = result * 59 + ($petName == null ? 43 : $petName.hashCode());
        String $milestone = this.getMilestone();
        result = result * 59 + ($milestone == null ? 43 : $milestone.hashCode());
        return result;
    }
}

