/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.notifiers.data;

import dinkplugin.message.Field;
import dinkplugin.notifiers.data.NotificationData;
import dinkplugin.notifiers.data.SerializedItemStack;
import dinkplugin.util.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import net.runelite.client.util.QuantityFormatter;
import net.runelite.http.api.loottracker.LootRecordType;

public final class LootNotificationData
extends NotificationData {
    private final List<SerializedItemStack> items;
    private final String source;
    private final LootRecordType category;
    private final Integer killCount;

    @Override
    public List<Field> getFields() {
        ArrayList<Field> fields = new ArrayList<Field>(2);
        if (this.killCount != null) {
            fields.add(new Field("Kill Count", Field.formatBlock("", QuantityFormatter.quantityToStackSize((long)this.killCount.intValue()))));
        }
        fields.add(new Field("Total Value", ItemUtils.formatGold(this.items.stream().mapToLong(SerializedItemStack::getTotalPrice).sum())));
        return fields;
    }

    public LootNotificationData(List<SerializedItemStack> items, String source, LootRecordType category, Integer killCount) {
        this.items = items;
        this.source = source;
        this.category = category;
        this.killCount = killCount;
    }

    public List<SerializedItemStack> getItems() {
        return this.items;
    }

    public String getSource() {
        return this.source;
    }

    public LootRecordType getCategory() {
        return this.category;
    }

    public Integer getKillCount() {
        return this.killCount;
    }

    public String toString() {
        return "LootNotificationData(items=" + this.getItems() + ", source=" + this.getSource() + ", category=" + this.getCategory() + ", killCount=" + this.getKillCount() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LootNotificationData)) {
            return false;
        }
        LootNotificationData other = (LootNotificationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$killCount = this.getKillCount();
        Integer other$killCount = other.getKillCount();
        if (this$killCount == null ? other$killCount != null : !((Object)this$killCount).equals(other$killCount)) {
            return false;
        }
        List<SerializedItemStack> this$items = this.getItems();
        List<SerializedItemStack> other$items = other.getItems();
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        LootRecordType this$category = this.getCategory();
        LootRecordType other$category = other.getCategory();
        return !(this$category == null ? other$category != null : !this$category.equals(other$category));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LootNotificationData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $killCount = this.getKillCount();
        result = result * 59 + ($killCount == null ? 43 : ((Object)$killCount).hashCode());
        List<SerializedItemStack> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        LootRecordType $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        return result;
    }
}

