/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.notifiers.data;

import dinkplugin.domain.LeagueTaskDifficulty;
import dinkplugin.message.Field;
import dinkplugin.notifiers.data.NotificationData;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LeaguesTaskNotificationData
extends NotificationData {
    @NotNull
    private final String taskName;
    @NotNull
    private final LeagueTaskDifficulty difficulty;
    private final int taskPoints;
    private final int totalPoints;
    private final int tasksCompleted;
    @Nullable
    private final Integer tasksUntilNextArea;
    @Nullable
    private final Integer pointsUntilNextRelic;
    @Nullable
    private final Integer pointsUntilNextTrophy;
    @Nullable
    private final String earnedTrophy;

    @Override
    public List<Field> getFields() {
        ArrayList<Field> fields = new ArrayList<Field>(3);
        fields.add(new Field("Total Tasks", Field.formatBlock("", String.valueOf(this.tasksCompleted))));
        fields.add(new Field("Total Points", Field.formatBlock("", String.valueOf(this.totalPoints))));
        if (this.earnedTrophy == null && this.pointsUntilNextRelic != null) {
            fields.add(new Field("Points until next Relic", Field.formatBlock("", String.valueOf(this.pointsUntilNextRelic))));
        } else if (this.pointsUntilNextTrophy != null) {
            fields.add(new Field("Points until next Trophy", Field.formatBlock("", String.valueOf(this.pointsUntilNextTrophy))));
        }
        return fields;
    }

    public LeaguesTaskNotificationData(@NotNull String taskName, @NotNull LeagueTaskDifficulty difficulty, int taskPoints, int totalPoints, int tasksCompleted, @Nullable Integer tasksUntilNextArea, @Nullable Integer pointsUntilNextRelic, @Nullable Integer pointsUntilNextTrophy, @Nullable String earnedTrophy) {
        if (taskName == null) {
            throw new NullPointerException("taskName is marked non-null but is null");
        }
        if (difficulty == null) {
            throw new NullPointerException("difficulty is marked non-null but is null");
        }
        this.taskName = taskName;
        this.difficulty = difficulty;
        this.taskPoints = taskPoints;
        this.totalPoints = totalPoints;
        this.tasksCompleted = tasksCompleted;
        this.tasksUntilNextArea = tasksUntilNextArea;
        this.pointsUntilNextRelic = pointsUntilNextRelic;
        this.pointsUntilNextTrophy = pointsUntilNextTrophy;
        this.earnedTrophy = earnedTrophy;
    }

    @NotNull
    public String getTaskName() {
        return this.taskName;
    }

    @NotNull
    public LeagueTaskDifficulty getDifficulty() {
        return this.difficulty;
    }

    public int getTaskPoints() {
        return this.taskPoints;
    }

    public int getTotalPoints() {
        return this.totalPoints;
    }

    public int getTasksCompleted() {
        return this.tasksCompleted;
    }

    @Nullable
    public Integer getTasksUntilNextArea() {
        return this.tasksUntilNextArea;
    }

    @Nullable
    public Integer getPointsUntilNextRelic() {
        return this.pointsUntilNextRelic;
    }

    @Nullable
    public Integer getPointsUntilNextTrophy() {
        return this.pointsUntilNextTrophy;
    }

    @Nullable
    public String getEarnedTrophy() {
        return this.earnedTrophy;
    }

    public String toString() {
        return "LeaguesTaskNotificationData(taskName=" + this.getTaskName() + ", difficulty=" + this.getDifficulty() + ", taskPoints=" + this.getTaskPoints() + ", totalPoints=" + this.getTotalPoints() + ", tasksCompleted=" + this.getTasksCompleted() + ", tasksUntilNextArea=" + this.getTasksUntilNextArea() + ", pointsUntilNextRelic=" + this.getPointsUntilNextRelic() + ", pointsUntilNextTrophy=" + this.getPointsUntilNextTrophy() + ", earnedTrophy=" + this.getEarnedTrophy() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LeaguesTaskNotificationData)) {
            return false;
        }
        LeaguesTaskNotificationData other = (LeaguesTaskNotificationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTaskPoints() != other.getTaskPoints()) {
            return false;
        }
        if (this.getTotalPoints() != other.getTotalPoints()) {
            return false;
        }
        if (this.getTasksCompleted() != other.getTasksCompleted()) {
            return false;
        }
        Integer this$tasksUntilNextArea = this.getTasksUntilNextArea();
        Integer other$tasksUntilNextArea = other.getTasksUntilNextArea();
        if (this$tasksUntilNextArea == null ? other$tasksUntilNextArea != null : !((Object)this$tasksUntilNextArea).equals(other$tasksUntilNextArea)) {
            return false;
        }
        Integer this$pointsUntilNextRelic = this.getPointsUntilNextRelic();
        Integer other$pointsUntilNextRelic = other.getPointsUntilNextRelic();
        if (this$pointsUntilNextRelic == null ? other$pointsUntilNextRelic != null : !((Object)this$pointsUntilNextRelic).equals(other$pointsUntilNextRelic)) {
            return false;
        }
        Integer this$pointsUntilNextTrophy = this.getPointsUntilNextTrophy();
        Integer other$pointsUntilNextTrophy = other.getPointsUntilNextTrophy();
        if (this$pointsUntilNextTrophy == null ? other$pointsUntilNextTrophy != null : !((Object)this$pointsUntilNextTrophy).equals(other$pointsUntilNextTrophy)) {
            return false;
        }
        String this$taskName = this.getTaskName();
        String other$taskName = other.getTaskName();
        if (this$taskName == null ? other$taskName != null : !this$taskName.equals(other$taskName)) {
            return false;
        }
        LeagueTaskDifficulty this$difficulty = this.getDifficulty();
        LeagueTaskDifficulty other$difficulty = other.getDifficulty();
        if (this$difficulty == null ? other$difficulty != null : !((Object)((Object)this$difficulty)).equals((Object)other$difficulty)) {
            return false;
        }
        String this$earnedTrophy = this.getEarnedTrophy();
        String other$earnedTrophy = other.getEarnedTrophy();
        return !(this$earnedTrophy == null ? other$earnedTrophy != null : !this$earnedTrophy.equals(other$earnedTrophy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LeaguesTaskNotificationData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTaskPoints();
        result = result * 59 + this.getTotalPoints();
        result = result * 59 + this.getTasksCompleted();
        Integer $tasksUntilNextArea = this.getTasksUntilNextArea();
        result = result * 59 + ($tasksUntilNextArea == null ? 43 : ((Object)$tasksUntilNextArea).hashCode());
        Integer $pointsUntilNextRelic = this.getPointsUntilNextRelic();
        result = result * 59 + ($pointsUntilNextRelic == null ? 43 : ((Object)$pointsUntilNextRelic).hashCode());
        Integer $pointsUntilNextTrophy = this.getPointsUntilNextTrophy();
        result = result * 59 + ($pointsUntilNextTrophy == null ? 43 : ((Object)$pointsUntilNextTrophy).hashCode());
        String $taskName = this.getTaskName();
        result = result * 59 + ($taskName == null ? 43 : $taskName.hashCode());
        LeagueTaskDifficulty $difficulty = this.getDifficulty();
        result = result * 59 + ($difficulty == null ? 43 : ((Object)((Object)$difficulty)).hashCode());
        String $earnedTrophy = this.getEarnedTrophy();
        result = result * 59 + ($earnedTrophy == null ? 43 : $earnedTrophy.hashCode());
        return result;
    }
}

