/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.notifiers.data;

import dinkplugin.message.Field;
import dinkplugin.notifiers.data.NotificationData;
import dinkplugin.notifiers.data.SerializedItemStack;
import dinkplugin.util.ItemUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class GroupStorageNotificationData
extends NotificationData {
    private final Collection<SerializedItemStack> deposits;
    private final Collection<SerializedItemStack> withdrawals;
    private final long netValue;
    private final String groupName;
    private final transient boolean includePrice;

    @Override
    public List<Field> getFields() {
        ArrayList<Field> fields = new ArrayList<Field>(2);
        if (StringUtils.isNotBlank((CharSequence)this.groupName)) {
            fields.add(new Field("Group", Field.formatBlock(null, this.groupName)));
        }
        if (this.includePrice) {
            fields.add(new Field("Net Value (GE)", ItemUtils.formatGold(this.netValue)));
        }
        return fields;
    }

    public GroupStorageNotificationData(Collection<SerializedItemStack> deposits, Collection<SerializedItemStack> withdrawals, long netValue, String groupName, boolean includePrice) {
        this.deposits = deposits;
        this.withdrawals = withdrawals;
        this.netValue = netValue;
        this.groupName = groupName;
        this.includePrice = includePrice;
    }

    public Collection<SerializedItemStack> getDeposits() {
        return this.deposits;
    }

    public Collection<SerializedItemStack> getWithdrawals() {
        return this.withdrawals;
    }

    public long getNetValue() {
        return this.netValue;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public boolean isIncludePrice() {
        return this.includePrice;
    }

    public String toString() {
        return "GroupStorageNotificationData(deposits=" + this.getDeposits() + ", withdrawals=" + this.getWithdrawals() + ", netValue=" + this.getNetValue() + ", groupName=" + this.getGroupName() + ", includePrice=" + this.isIncludePrice() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupStorageNotificationData)) {
            return false;
        }
        GroupStorageNotificationData other = (GroupStorageNotificationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNetValue() != other.getNetValue()) {
            return false;
        }
        Collection<SerializedItemStack> this$deposits = this.getDeposits();
        Collection<SerializedItemStack> other$deposits = other.getDeposits();
        if (this$deposits == null ? other$deposits != null : !((Object)this$deposits).equals(other$deposits)) {
            return false;
        }
        Collection<SerializedItemStack> this$withdrawals = this.getWithdrawals();
        Collection<SerializedItemStack> other$withdrawals = other.getWithdrawals();
        if (this$withdrawals == null ? other$withdrawals != null : !((Object)this$withdrawals).equals(other$withdrawals)) {
            return false;
        }
        String this$groupName = this.getGroupName();
        String other$groupName = other.getGroupName();
        return !(this$groupName == null ? other$groupName != null : !this$groupName.equals(other$groupName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GroupStorageNotificationData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $netValue = this.getNetValue();
        result = result * 59 + (int)($netValue >>> 32 ^ $netValue);
        Collection<SerializedItemStack> $deposits = this.getDeposits();
        result = result * 59 + ($deposits == null ? 43 : ((Object)$deposits).hashCode());
        Collection<SerializedItemStack> $withdrawals = this.getWithdrawals();
        result = result * 59 + ($withdrawals == null ? 43 : ((Object)$withdrawals).hashCode());
        String $groupName = this.getGroupName();
        result = result * 59 + ($groupName == null ? 43 : $groupName.hashCode());
        return result;
    }
}

