/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.notifiers.data;

import dinkplugin.message.Field;
import dinkplugin.notifiers.GrandExchangeNotifier;
import dinkplugin.notifiers.data.NotificationData;
import dinkplugin.notifiers.data.SerializedItemStack;
import dinkplugin.util.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import net.runelite.api.GrandExchangeOfferState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GrandExchangeNotificationData
extends NotificationData {
    private final int slot;
    @NotNull
    private final GrandExchangeOfferState status;
    @NotNull
    private final SerializedItemStack item;
    private final long marketPrice;
    private final long targetPrice;
    private final int targetQuantity;
    @Nullable
    private final Long sellerTax;

    @Override
    public List<Field> getFields() {
        ArrayList<Field> fields = new ArrayList<Field>(4);
        fields.add(new Field("Status", Field.formatBlock("", GrandExchangeNotifier.getHumanStatus(this.status))));
        if (this.status == GrandExchangeOfferState.BUYING || this.status == GrandExchangeOfferState.SELLING) {
            fields.add(new Field("Target Quantity", Field.formatBlock("", String.valueOf(this.targetQuantity))));
        }
        if (this.sellerTax != null && this.sellerTax > 0L) {
            fields.add(new Field("After-Tax Value", ItemUtils.formatGold(this.item.getTotalPrice() - this.sellerTax)));
        }
        if (this.marketPrice > 0L) {
            fields.add(new Field("Market Unit Price", ItemUtils.formatGold(this.marketPrice)));
        }
        return fields;
    }

    public GrandExchangeNotificationData(int slot, @NotNull GrandExchangeOfferState status, @NotNull SerializedItemStack item, long marketPrice, long targetPrice, int targetQuantity, @Nullable Long sellerTax) {
        if (status == null) {
            throw new NullPointerException("status is marked non-null but is null");
        }
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        this.slot = slot;
        this.status = status;
        this.item = item;
        this.marketPrice = marketPrice;
        this.targetPrice = targetPrice;
        this.targetQuantity = targetQuantity;
        this.sellerTax = sellerTax;
    }

    public int getSlot() {
        return this.slot;
    }

    @NotNull
    public GrandExchangeOfferState getStatus() {
        return this.status;
    }

    @NotNull
    public SerializedItemStack getItem() {
        return this.item;
    }

    public long getMarketPrice() {
        return this.marketPrice;
    }

    public long getTargetPrice() {
        return this.targetPrice;
    }

    public int getTargetQuantity() {
        return this.targetQuantity;
    }

    @Nullable
    public Long getSellerTax() {
        return this.sellerTax;
    }

    public String toString() {
        return "GrandExchangeNotificationData(slot=" + this.getSlot() + ", status=" + this.getStatus() + ", item=" + this.getItem() + ", marketPrice=" + this.getMarketPrice() + ", targetPrice=" + this.getTargetPrice() + ", targetQuantity=" + this.getTargetQuantity() + ", sellerTax=" + this.getSellerTax() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GrandExchangeNotificationData)) {
            return false;
        }
        GrandExchangeNotificationData other = (GrandExchangeNotificationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSlot() != other.getSlot()) {
            return false;
        }
        if (this.getMarketPrice() != other.getMarketPrice()) {
            return false;
        }
        if (this.getTargetPrice() != other.getTargetPrice()) {
            return false;
        }
        if (this.getTargetQuantity() != other.getTargetQuantity()) {
            return false;
        }
        Long this$sellerTax = this.getSellerTax();
        Long other$sellerTax = other.getSellerTax();
        if (this$sellerTax == null ? other$sellerTax != null : !((Object)this$sellerTax).equals(other$sellerTax)) {
            return false;
        }
        GrandExchangeOfferState this$status = this.getStatus();
        GrandExchangeOfferState other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        SerializedItemStack this$item = this.getItem();
        SerializedItemStack other$item = other.getItem();
        return !(this$item == null ? other$item != null : !((Object)this$item).equals(other$item));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GrandExchangeNotificationData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSlot();
        long $marketPrice = this.getMarketPrice();
        result = result * 59 + (int)($marketPrice >>> 32 ^ $marketPrice);
        long $targetPrice = this.getTargetPrice();
        result = result * 59 + (int)($targetPrice >>> 32 ^ $targetPrice);
        result = result * 59 + this.getTargetQuantity();
        Long $sellerTax = this.getSellerTax();
        result = result * 59 + ($sellerTax == null ? 43 : ((Object)$sellerTax).hashCode());
        GrandExchangeOfferState $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        SerializedItemStack $item = this.getItem();
        result = result * 59 + ($item == null ? 43 : ((Object)$item).hashCode());
        return result;
    }
}

