/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.notifiers.data;

import dinkplugin.domain.AchievementDiary;
import dinkplugin.message.Field;
import dinkplugin.notifiers.data.NotificationData;
import java.util.ArrayList;
import java.util.List;

public final class DiaryNotificationData
extends NotificationData {
    private final String area;
    private final AchievementDiary.Difficulty difficulty;
    private final int total;
    private final int tasksCompleted;
    private final int tasksTotal;
    private final int areaTasksCompleted;
    private final int areaTasksTotal;

    @Override
    public List<Field> getFields() {
        ArrayList<Field> fields = new ArrayList<Field>(2);
        if (this.areaTasksCompleted > 0 && this.areaTasksTotal > 0) {
            fields.add(new Field(this.area + " Progress", Field.formatProgress(this.areaTasksCompleted, this.areaTasksTotal)));
        }
        if (this.tasksCompleted > 0 && this.tasksTotal > 0) {
            fields.add(new Field("Overall Progress", Field.formatProgress(this.tasksCompleted, this.tasksTotal)));
        }
        return fields;
    }

    public DiaryNotificationData(String area, AchievementDiary.Difficulty difficulty, int total, int tasksCompleted, int tasksTotal, int areaTasksCompleted, int areaTasksTotal) {
        this.area = area;
        this.difficulty = difficulty;
        this.total = total;
        this.tasksCompleted = tasksCompleted;
        this.tasksTotal = tasksTotal;
        this.areaTasksCompleted = areaTasksCompleted;
        this.areaTasksTotal = areaTasksTotal;
    }

    public String getArea() {
        return this.area;
    }

    public AchievementDiary.Difficulty getDifficulty() {
        return this.difficulty;
    }

    public int getTotal() {
        return this.total;
    }

    public int getTasksCompleted() {
        return this.tasksCompleted;
    }

    public int getTasksTotal() {
        return this.tasksTotal;
    }

    public int getAreaTasksCompleted() {
        return this.areaTasksCompleted;
    }

    public int getAreaTasksTotal() {
        return this.areaTasksTotal;
    }

    public String toString() {
        return "DiaryNotificationData(area=" + this.getArea() + ", difficulty=" + this.getDifficulty() + ", total=" + this.getTotal() + ", tasksCompleted=" + this.getTasksCompleted() + ", tasksTotal=" + this.getTasksTotal() + ", areaTasksCompleted=" + this.getAreaTasksCompleted() + ", areaTasksTotal=" + this.getAreaTasksTotal() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DiaryNotificationData)) {
            return false;
        }
        DiaryNotificationData other = (DiaryNotificationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        if (this.getTasksCompleted() != other.getTasksCompleted()) {
            return false;
        }
        if (this.getTasksTotal() != other.getTasksTotal()) {
            return false;
        }
        if (this.getAreaTasksCompleted() != other.getAreaTasksCompleted()) {
            return false;
        }
        if (this.getAreaTasksTotal() != other.getAreaTasksTotal()) {
            return false;
        }
        String this$area = this.getArea();
        String other$area = other.getArea();
        if (this$area == null ? other$area != null : !this$area.equals(other$area)) {
            return false;
        }
        AchievementDiary.Difficulty this$difficulty = this.getDifficulty();
        AchievementDiary.Difficulty other$difficulty = other.getDifficulty();
        return !(this$difficulty == null ? other$difficulty != null : !((Object)((Object)this$difficulty)).equals((Object)other$difficulty));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DiaryNotificationData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTotal();
        result = result * 59 + this.getTasksCompleted();
        result = result * 59 + this.getTasksTotal();
        result = result * 59 + this.getAreaTasksCompleted();
        result = result * 59 + this.getAreaTasksTotal();
        String $area = this.getArea();
        result = result * 59 + ($area == null ? 43 : $area.hashCode());
        AchievementDiary.Difficulty $difficulty = this.getDifficulty();
        result = result * 59 + ($difficulty == null ? 43 : ((Object)((Object)$difficulty)).hashCode());
        return result;
    }
}

