/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.notifiers.data;

import dinkplugin.domain.CombatAchievementTier;
import dinkplugin.message.Field;
import dinkplugin.notifiers.data.NotificationData;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CombatAchievementData
extends NotificationData {
    @NotNull
    private final CombatAchievementTier tier;
    @NotNull
    private final String task;
    private final int taskPoints;
    private final int totalPoints;
    @Nullable
    private final Integer tierProgress;
    @Nullable
    private final Integer tierTotalPoints;
    @Nullable
    private final CombatAchievementTier justCompletedTier;

    @Override
    public List<Field> getFields() {
        ArrayList<Field> fields = new ArrayList<Field>(3);
        fields.add(new Field("Points Earned", Field.formatBlock(null, String.valueOf(this.taskPoints))));
        fields.add(new Field("Total Points", Field.formatBlock(null, String.valueOf(this.totalPoints))));
        if (this.tierProgress != null && this.tierTotalPoints != null) {
            fields.add(new Field("Next Unlock Progress", Field.formatProgress(this.tierProgress, this.tierTotalPoints)));
        }
        return fields;
    }

    public CombatAchievementData(@NotNull CombatAchievementTier tier, @NotNull String task, int taskPoints, int totalPoints, @Nullable Integer tierProgress, @Nullable Integer tierTotalPoints, @Nullable CombatAchievementTier justCompletedTier) {
        if (tier == null) {
            throw new NullPointerException("tier is marked non-null but is null");
        }
        if (task == null) {
            throw new NullPointerException("task is marked non-null but is null");
        }
        this.tier = tier;
        this.task = task;
        this.taskPoints = taskPoints;
        this.totalPoints = totalPoints;
        this.tierProgress = tierProgress;
        this.tierTotalPoints = tierTotalPoints;
        this.justCompletedTier = justCompletedTier;
    }

    @NotNull
    public CombatAchievementTier getTier() {
        return this.tier;
    }

    @NotNull
    public String getTask() {
        return this.task;
    }

    public int getTaskPoints() {
        return this.taskPoints;
    }

    public int getTotalPoints() {
        return this.totalPoints;
    }

    @Nullable
    public Integer getTierProgress() {
        return this.tierProgress;
    }

    @Nullable
    public Integer getTierTotalPoints() {
        return this.tierTotalPoints;
    }

    @Nullable
    public CombatAchievementTier getJustCompletedTier() {
        return this.justCompletedTier;
    }

    public String toString() {
        return "CombatAchievementData(tier=" + this.getTier() + ", task=" + this.getTask() + ", taskPoints=" + this.getTaskPoints() + ", totalPoints=" + this.getTotalPoints() + ", tierProgress=" + this.getTierProgress() + ", tierTotalPoints=" + this.getTierTotalPoints() + ", justCompletedTier=" + this.getJustCompletedTier() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CombatAchievementData)) {
            return false;
        }
        CombatAchievementData other = (CombatAchievementData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTaskPoints() != other.getTaskPoints()) {
            return false;
        }
        if (this.getTotalPoints() != other.getTotalPoints()) {
            return false;
        }
        Integer this$tierProgress = this.getTierProgress();
        Integer other$tierProgress = other.getTierProgress();
        if (this$tierProgress == null ? other$tierProgress != null : !((Object)this$tierProgress).equals(other$tierProgress)) {
            return false;
        }
        Integer this$tierTotalPoints = this.getTierTotalPoints();
        Integer other$tierTotalPoints = other.getTierTotalPoints();
        if (this$tierTotalPoints == null ? other$tierTotalPoints != null : !((Object)this$tierTotalPoints).equals(other$tierTotalPoints)) {
            return false;
        }
        CombatAchievementTier this$tier = this.getTier();
        CombatAchievementTier other$tier = other.getTier();
        if (this$tier == null ? other$tier != null : !((Object)((Object)this$tier)).equals((Object)other$tier)) {
            return false;
        }
        String this$task = this.getTask();
        String other$task = other.getTask();
        if (this$task == null ? other$task != null : !this$task.equals(other$task)) {
            return false;
        }
        CombatAchievementTier this$justCompletedTier = this.getJustCompletedTier();
        CombatAchievementTier other$justCompletedTier = other.getJustCompletedTier();
        return !(this$justCompletedTier == null ? other$justCompletedTier != null : !((Object)((Object)this$justCompletedTier)).equals((Object)other$justCompletedTier));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CombatAchievementData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTaskPoints();
        result = result * 59 + this.getTotalPoints();
        Integer $tierProgress = this.getTierProgress();
        result = result * 59 + ($tierProgress == null ? 43 : ((Object)$tierProgress).hashCode());
        Integer $tierTotalPoints = this.getTierTotalPoints();
        result = result * 59 + ($tierTotalPoints == null ? 43 : ((Object)$tierTotalPoints).hashCode());
        CombatAchievementTier $tier = this.getTier();
        result = result * 59 + ($tier == null ? 43 : ((Object)((Object)$tier)).hashCode());
        String $task = this.getTask();
        result = result * 59 + ($task == null ? 43 : $task.hashCode());
        CombatAchievementTier $justCompletedTier = this.getJustCompletedTier();
        result = result * 59 + ($justCompletedTier == null ? 43 : ((Object)((Object)$justCompletedTier)).hashCode());
        return result;
    }
}

