/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.notifiers.data;

import dinkplugin.message.Field;
import dinkplugin.notifiers.data.NotificationData;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CollectionNotificationData
extends NotificationData {
    @NotNull
    private final String itemName;
    @Nullable
    private final Integer itemId;
    @Nullable
    private final Long price;
    @Nullable
    private final Integer completedEntries;
    @Nullable
    private final Integer totalEntries;

    @Override
    public List<Field> getFields() {
        if (this.completedEntries == null || this.totalEntries == null) {
            return super.getFields();
        }
        return Collections.singletonList(new Field("Completed Entries", Field.formatProgress(this.completedEntries, this.totalEntries)));
    }

    public CollectionNotificationData(@NotNull String itemName, @Nullable Integer itemId, @Nullable Long price, @Nullable Integer completedEntries, @Nullable Integer totalEntries) {
        if (itemName == null) {
            throw new NullPointerException("itemName is marked non-null but is null");
        }
        this.itemName = itemName;
        this.itemId = itemId;
        this.price = price;
        this.completedEntries = completedEntries;
        this.totalEntries = totalEntries;
    }

    @NotNull
    public String getItemName() {
        return this.itemName;
    }

    @Nullable
    public Integer getItemId() {
        return this.itemId;
    }

    @Nullable
    public Long getPrice() {
        return this.price;
    }

    @Nullable
    public Integer getCompletedEntries() {
        return this.completedEntries;
    }

    @Nullable
    public Integer getTotalEntries() {
        return this.totalEntries;
    }

    public String toString() {
        return "CollectionNotificationData(itemName=" + this.getItemName() + ", itemId=" + this.getItemId() + ", price=" + this.getPrice() + ", completedEntries=" + this.getCompletedEntries() + ", totalEntries=" + this.getTotalEntries() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CollectionNotificationData)) {
            return false;
        }
        CollectionNotificationData other = (CollectionNotificationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$itemId = this.getItemId();
        Integer other$itemId = other.getItemId();
        if (this$itemId == null ? other$itemId != null : !((Object)this$itemId).equals(other$itemId)) {
            return false;
        }
        Long this$price = this.getPrice();
        Long other$price = other.getPrice();
        if (this$price == null ? other$price != null : !((Object)this$price).equals(other$price)) {
            return false;
        }
        Integer this$completedEntries = this.getCompletedEntries();
        Integer other$completedEntries = other.getCompletedEntries();
        if (this$completedEntries == null ? other$completedEntries != null : !((Object)this$completedEntries).equals(other$completedEntries)) {
            return false;
        }
        Integer this$totalEntries = this.getTotalEntries();
        Integer other$totalEntries = other.getTotalEntries();
        if (this$totalEntries == null ? other$totalEntries != null : !((Object)this$totalEntries).equals(other$totalEntries)) {
            return false;
        }
        String this$itemName = this.getItemName();
        String other$itemName = other.getItemName();
        return !(this$itemName == null ? other$itemName != null : !this$itemName.equals(other$itemName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CollectionNotificationData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $itemId = this.getItemId();
        result = result * 59 + ($itemId == null ? 43 : ((Object)$itemId).hashCode());
        Long $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
        Integer $completedEntries = this.getCompletedEntries();
        result = result * 59 + ($completedEntries == null ? 43 : ((Object)$completedEntries).hashCode());
        Integer $totalEntries = this.getTotalEntries();
        result = result * 59 + ($totalEntries == null ? 43 : ((Object)$totalEntries).hashCode());
        String $itemName = this.getItemName();
        result = result * 59 + ($itemName == null ? 43 : $itemName.hashCode());
        return result;
    }
}

