/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.notifiers.data;

import dinkplugin.message.Field;
import dinkplugin.notifiers.data.NotificationData;
import dinkplugin.notifiers.data.SerializedItemStack;
import dinkplugin.util.ItemUtils;
import java.util.Collections;
import java.util.List;

public final class ClueNotificationData
extends NotificationData {
    private final String clueType;
    private final int numberCompleted;
    private final List<SerializedItemStack> items;

    @Override
    public List<Field> getFields() {
        return Collections.singletonList(new Field("Total Value", ItemUtils.formatGold(this.items.stream().mapToLong(SerializedItemStack::getTotalPrice).sum())));
    }

    public ClueNotificationData(String clueType, int numberCompleted, List<SerializedItemStack> items) {
        this.clueType = clueType;
        this.numberCompleted = numberCompleted;
        this.items = items;
    }

    public String getClueType() {
        return this.clueType;
    }

    public int getNumberCompleted() {
        return this.numberCompleted;
    }

    public List<SerializedItemStack> getItems() {
        return this.items;
    }

    public String toString() {
        return "ClueNotificationData(clueType=" + this.getClueType() + ", numberCompleted=" + this.getNumberCompleted() + ", items=" + this.getItems() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClueNotificationData)) {
            return false;
        }
        ClueNotificationData other = (ClueNotificationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNumberCompleted() != other.getNumberCompleted()) {
            return false;
        }
        String this$clueType = this.getClueType();
        String other$clueType = other.getClueType();
        if (this$clueType == null ? other$clueType != null : !this$clueType.equals(other$clueType)) {
            return false;
        }
        List<SerializedItemStack> this$items = this.getItems();
        List<SerializedItemStack> other$items = other.getItems();
        return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClueNotificationData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNumberCompleted();
        String $clueType = this.getClueType();
        result = result * 59 + ($clueType == null ? 43 : $clueType.hashCode());
        List<SerializedItemStack> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        return result;
    }
}

