/*
 * Decompiled with CFR 0.152.
 */
package dinkplugin.notifiers;

import dinkplugin.message.NotificationBody;
import dinkplugin.message.NotificationType;
import dinkplugin.message.templating.Replacements;
import dinkplugin.message.templating.Template;
import dinkplugin.notifiers.BaseNotifier;
import dinkplugin.notifiers.data.SpeedrunNotificationData;
import dinkplugin.util.QuestUtils;
import dinkplugin.util.TimeUtils;
import dinkplugin.util.Utils;
import java.time.Duration;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeedrunNotifier
extends BaseNotifier {
    private static final Logger log = LoggerFactory.getLogger(SpeedrunNotifier.class);
    @VisibleForTesting
    static final int SPEEDRUN_COMPLETED_GROUP_ID = 781;
    @VisibleForTesting
    static final int SPEEDRUN_COMPLETED_QUEST_NAME_CHILD_ID = 4;
    @VisibleForTesting
    static final int SPEEDRUN_COMPLETED_DURATION_CHILD_ID = 10;
    @VisibleForTesting
    static final int SPEEDRUN_COMPLETED_PB_CHILD_ID = 12;
    private boolean isPersonalBest = false;

    @Override
    public boolean isEnabled() {
        return this.config.notifySpeedrun() && this.settingsManager.isNamePermitted(this.client.getLocalPlayer().getName());
    }

    @Override
    protected String getWebhookUrl() {
        return this.config.speedrunWebhook();
    }

    public void reset() {
        this.isPersonalBest = false;
    }

    public void onWidgetLoaded(WidgetLoaded event) {
        if (event.getGroupId() == 781 && this.isEnabled()) {
            Widget questName = this.client.getWidget(781, 4);
            Widget duration = this.client.getWidget(781, 10);
            Widget personalBest = this.client.getWidget(781, 12);
            if (questName != null && duration != null && personalBest != null) {
                this.attemptNotify(QuestUtils.parseQuestWidget(questName.getText()), duration.getText(), personalBest.getText());
            } else {
                log.error("Found speedrun finished widget (group id {}) but it is missing something, questName={}, duration={}, pb={}", new Object[]{781, questName, duration, personalBest});
            }
        }
    }

    private void attemptNotify(String questName, String duration, String pb) {
        if (!this.isPersonalBest && this.config.speedrunPBOnly()) {
            return;
        }
        Template notifyMessage = Template.builder().template(this.isPersonalBest ? this.config.speedrunPBMessage() : this.config.speedrunMessage()).replacementBoundary("%").replacement("%USERNAME%", Replacements.ofText(Utils.getPlayerName(this.client))).replacement("%QUEST%", Replacements.ofWiki(questName)).replacement("%TIME%", Replacements.ofText(duration)).replacement("%BEST%", Replacements.ofText(pb)).build();
        Duration bestTime = TimeUtils.parseTime(pb);
        Duration currentTime = TimeUtils.parseTime(duration);
        this.createMessage(this.config.speedrunSendImage(), NotificationBody.builder().text(notifyMessage).extra(new SpeedrunNotificationData(questName, bestTime.toString(), currentTime.toString(), this.isPersonalBest)).type(NotificationType.SPEEDRUN).build());
        this.reset();
    }

    public void onGameMessage(String chatMessage) {
        if (!this.isEnabled()) {
            return;
        }
        if (chatMessage.startsWith("Speedrun duration: ")) {
            this.isPersonalBest = chatMessage.endsWith(" (new personal best)");
        }
    }
}

